/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.functions;

import de.jexcellence.gpeee.Tuple;
import de.jexcellence.gpeee.error.InvalidFunctionArgumentTypeError;
import de.jexcellence.gpeee.functions.ExpressionFunctionArgument;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import de.jexcellence.gpeee.interpreter.IValueInterpreter;
import de.jexcellence.gpeee.parser.expression.FunctionInvocationExpression;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class AExpressionFunction {
    public abstract Object apply(IEvaluationEnvironment var1, List<@Nullable Object> var2);

    @Nullable
    public abstract List<ExpressionFunctionArgument> getArguments();

    protected <T> T nonNull(List<@Nullable Object> args, int index) {
        return (T)Objects.requireNonNull(args.get(index));
    }

    @Nullable
    protected <T> T nullable(List<@Nullable Object> args, int index) {
        return (T)(index >= args.size() ? null : args.get(index));
    }

    protected <T> T nullableWithFallback(List<@Nullable Object> args, int index, T fallback) {
        T result;
        Object object = result = index >= args.size() ? fallback : args.get(index);
        if (result == null) {
            return fallback;
        }
        return result;
    }

    public void validateArguments(FunctionInvocationExpression expression, IValueInterpreter valueInterpreter, List<@Nullable Object> args) throws InvalidFunctionArgumentTypeError {
        List<ExpressionFunctionArgument> argumentDefinitions = this.getArguments();
        if (argumentDefinitions == null) {
            return;
        }
        for (int i = 0; i < argumentDefinitions.size(); ++i) {
            ExpressionFunctionArgument definition = argumentDefinitions.get(i);
            Object argument = i >= args.size() ? null : args.get(i);
            Tuple<Boolean, @Nullable Object> result = definition.checkDescriptionAndPossiblyConvert(argument, valueInterpreter);
            if (!((Boolean)result.a).booleanValue()) {
                throw new InvalidFunctionArgumentTypeError(expression, definition, i, argument);
            }
            if (i >= args.size()) continue;
            args.set(i, result.b);
        }
    }
}

