/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee.error;

import de.jexcellence.gpeee.error.AEvaluatorError;
import de.jexcellence.gpeee.functions.AExpressionFunction;
import de.jexcellence.gpeee.functions.ExpressionFunctionArgument;
import de.jexcellence.gpeee.parser.expression.IdentifierExpression;
import java.util.List;
import java.util.stream.Collectors;

public class UndefinedFunctionArgumentNameError
extends AEvaluatorError {
    public UndefinedFunctionArgumentNameError(AExpressionFunction function, IdentifierExpression name) {
        super(name.getHead().getRow(), name.getHead().getCol(), name.getFullContainingExpression(), "Undefined function argument name >" + name.getSymbol() + "<, needs to be any of: " + UndefinedFunctionArgumentNameError.stringifyAvailableArguments(function));
    }

    private static String stringifyAvailableArguments(AExpressionFunction function) {
        List<ExpressionFunctionArgument> args = function.getArguments();
        if (args == null) {
            return "This function has no arguments";
        }
        return args.stream().map(ExpressionFunctionArgument::getName).collect(Collectors.joining(" | "));
    }
}

