/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.gpeee;

import de.jexcellence.gpeee.IExpressionEvaluator;
import de.jexcellence.gpeee.error.AEvaluatorError;
import de.jexcellence.gpeee.functions.AExpressionFunction;
import de.jexcellence.gpeee.functions.IStandardFunctionRegistry;
import de.jexcellence.gpeee.functions.std.AStandardFunction;
import de.jexcellence.gpeee.functions.std.BoolFunction;
import de.jexcellence.gpeee.functions.std.DateFormatFunction;
import de.jexcellence.gpeee.functions.std.FlattenFunction;
import de.jexcellence.gpeee.functions.std.IterCatFunction;
import de.jexcellence.gpeee.functions.std.KeyFunction;
import de.jexcellence.gpeee.functions.std.LIndexFunction;
import de.jexcellence.gpeee.functions.std.LenFunction;
import de.jexcellence.gpeee.functions.std.ListFunction;
import de.jexcellence.gpeee.functions.std.ListOfFunction;
import de.jexcellence.gpeee.functions.std.MapFunction;
import de.jexcellence.gpeee.functions.std.MapOfFunction;
import de.jexcellence.gpeee.functions.std.MaxFunction;
import de.jexcellence.gpeee.functions.std.MinFunction;
import de.jexcellence.gpeee.functions.std.PrintFunction;
import de.jexcellence.gpeee.functions.std.RIndexFunction;
import de.jexcellence.gpeee.functions.std.RangeFunction;
import de.jexcellence.gpeee.functions.std.SplitFunction;
import de.jexcellence.gpeee.functions.std.StrFunction;
import de.jexcellence.gpeee.functions.std.SubstringFunction;
import de.jexcellence.gpeee.functions.std.TitleCaseFunction;
import de.jexcellence.gpeee.functions.std.ValueFunction;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import de.jexcellence.gpeee.interpreter.IValueInterpreter;
import de.jexcellence.gpeee.interpreter.Interpreter;
import de.jexcellence.gpeee.interpreter.StandardValueInterpreter;
import de.jexcellence.gpeee.parser.Optimizer;
import de.jexcellence.gpeee.parser.Parser;
import de.jexcellence.gpeee.parser.expression.AExpression;
import de.jexcellence.gpeee.tokenizer.Tokenizer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public class GPEEE
implements IExpressionEvaluator,
IStandardFunctionRegistry {
    public static final IValueInterpreter STD_VALUE_INTERPRETER = new StandardValueInterpreter();
    public static final IEvaluationEnvironment EMPTY_ENVIRONMENT = GPEEE.createEmptyEnvironment();
    private final Map<String, AStandardFunction> standardFunctions;
    private final Parser parser;
    private final Interpreter interpreter;
    private final Optimizer optimizer;
    private final Logger logger;
    private EvaluationEnvironmentBuilder baseEnvironment;

    public GPEEE(Logger logger) {
        this.logger = logger;
        this.parser = new Parser(this.logger);
        this.interpreter = new Interpreter(this.logger, this);
        this.optimizer = new Optimizer(this.logger, this.interpreter, this);
        this.standardFunctions = new HashMap<String, AStandardFunction>();
        this.loadStandardFunctions();
    }

    public void setBaseEnvironment(EvaluationEnvironmentBuilder baseEnvironment) {
        this.baseEnvironment = baseEnvironment;
    }

    @Override
    public AExpression parseString(String input) throws AEvaluatorError {
        return this.parser.parse(new Tokenizer(this.logger, input));
    }

    @Override
    public AExpression optimizeExpression(AExpression expression) throws AEvaluatorError {
        return this.optimizer.optimizeAST(expression);
    }

    @Override
    public Object evaluateExpression(AExpression expression, IEvaluationEnvironment environment) throws AEvaluatorError {
        if (this.baseEnvironment != null) {
            environment = this.baseEnvironment.build(environment);
        }
        return this.interpreter.evaluateExpression(expression, environment);
    }

    @Override
    public EvaluationEnvironmentBuilder getBaseEnvironment() {
        if (this.baseEnvironment == null) {
            return new EvaluationEnvironmentBuilder();
        }
        return this.baseEnvironment.duplicate();
    }

    @Override
    public void register(String name, AStandardFunction function) {
        this.standardFunctions.put(name, function);
    }

    @Override
    @Nullable
    public AStandardFunction lookup(String name) {
        return this.standardFunctions.get(name);
    }

    private void loadStandardFunctions() {
        new IterCatFunction().registerSelf(this);
        new StrFunction().registerSelf(this);
        new KeyFunction().registerSelf(this);
        new ValueFunction().registerSelf(this);
        new BoolFunction().registerSelf(this);
        new ListFunction().registerSelf(this);
        new LenFunction().registerSelf(this);
        new ListOfFunction().registerSelf(this);
        new MapOfFunction().registerSelf(this);
        new SplitFunction().registerSelf(this);
        new PrintFunction().registerSelf(this);
        new TitleCaseFunction().registerSelf(this);
        new MapFunction().registerSelf(this);
        new DateFormatFunction().registerSelf(this);
        new LIndexFunction().registerSelf(this);
        new RIndexFunction().registerSelf(this);
        new SubstringFunction().registerSelf(this);
        new RangeFunction().registerSelf(this);
        new FlattenFunction().registerSelf(this);
        new MinFunction().registerSelf(this);
        new MaxFunction().registerSelf(this);
    }

    private static IEvaluationEnvironment createEmptyEnvironment() {
        return new IEvaluationEnvironment(){

            @Override
            public Map<String, AExpressionFunction> getFunctions() {
                return new HashMap<String, AExpressionFunction>();
            }

            @Override
            public Map<String, Supplier<?>> getLiveVariables() {
                return new HashMap();
            }

            @Override
            public Map<String, ?> getStaticVariables() {
                return new HashMap();
            }

            @Override
            public IValueInterpreter getValueInterpreter() {
                return STD_VALUE_INTERPRETER;
            }
        };
    }
}

