/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.evaluable.textures;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import de.jexcellence.evaluable.textures.TexturesHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;

public class GameProfileTexturesHandler
implements TexturesHandler {
    private static final Class<?> HEAD_META_CLASS = new ItemStack(Material.PLAYER_HEAD).getItemMeta().getClass();
    @Nullable
    private static Method setProfileMethod;
    @Nullable
    private static Field profileField;

    @Override
    public void setBase64Textures(ItemMeta meta, String base64Textures) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), "");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", base64Textures));
        if (!(meta instanceof SkullMeta)) {
            return;
        }
        try {
            if (setProfileMethod != null) {
                setProfileMethod.invoke((Object)meta, profile);
                return;
            }
            if (profileField != null) {
                profileField.set(meta, profile);
                return;
            }
            throw new IllegalStateException("Couldn't apply head-textures, as neither the method nor the field were accessible");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    @Nullable
    public String getBase64Textures(ItemMeta meta) {
        if (profileField == null || !(meta instanceof SkullMeta)) {
            return null;
        }
        SkullMeta skullMeta = (SkullMeta)meta;
        try {
            return ((Property)((GameProfile)profileField.get(meta)).getProperties().get((Object)"textures").iterator().next()).getValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        try {
            setProfileMethod = HEAD_META_CLASS.getMethod("setProfile", new Class[0]);
            setProfileMethod.setAccessible(true);
        }
        catch (Exception e) {
            setProfileMethod = null;
        }
        try {
            profileField = HEAD_META_CLASS.getDeclaredField("profile");
            profileField.setAccessible(true);
        }
        catch (Exception e) {
            profileField = null;
        }
    }
}

