/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.evaluable.section;

import de.jexcellence.configmapper.ScalarType;
import de.jexcellence.configmapper.sections.AConfigSection;
import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.evaluable.BukkitEvaluable;
import de.jexcellence.evaluable.EPatchFlag;
import de.jexcellence.evaluable.IItemBuildable;
import de.jexcellence.evaluable.ItemBuilder;
import de.jexcellence.evaluable.section.ComparisonMismatch;
import de.jexcellence.evaluable.section.ItemStackBannerPatternSection;
import de.jexcellence.evaluable.section.ItemStackBaseEffectSection;
import de.jexcellence.evaluable.section.ItemStackCustomEffectSection;
import de.jexcellence.evaluable.section.ItemStackEnchantmentSection;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import de.jexcellence.remapped.com.cryptomorin.xseries.XMaterial;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.Nullable;

public class ItemStackSection
extends AConfigSection {
    @Nullable
    private BukkitEvaluable amount;
    @Nullable
    private BukkitEvaluable type;
    @Nullable
    private BukkitEvaluable name;
    @Nullable
    private BukkitEvaluable lore;
    @Nullable
    private BukkitEvaluable flags;
    @Nullable
    private BukkitEvaluable color;
    private ItemStackEnchantmentSection @Nullable [] enchantments;
    @Nullable
    private BukkitEvaluable textures;
    @Nullable
    private ItemStackBaseEffectSection baseEffect;
    private ItemStackCustomEffectSection @Nullable [] customEffects;
    private ItemStackBannerPatternSection @Nullable [] bannerPatterns;
    @CSAlways
    private List<EPatchFlag> patchFlags;

    public ItemStackSection(EvaluationEnvironmentBuilder baseEnvironment) {
        super(baseEnvironment);
    }

    public IItemBuildable asItem() {
        return new ItemBuilder(new ItemStack(Material.BARRIER), 1).setType(this.type).setAmount(this.amount).extendBannerPatterns(this.bannerPatterns).setName(this.name).extendLore(this.lore).extendFlags(this.flags).extendEnchantments(this.enchantments).setColor(this.color).setTextures(this.textures).setBaseEffect(this.baseEffect).extendCustomEffects(this.customEffects);
    }

    @Nullable
    public BukkitEvaluable getAmount() {
        return this.amount;
    }

    @Nullable
    public BukkitEvaluable getType() {
        return this.type;
    }

    @Nullable
    public BukkitEvaluable getName() {
        return this.name;
    }

    @Nullable
    public BukkitEvaluable getLore() {
        return this.lore;
    }

    @Nullable
    public BukkitEvaluable getFlags() {
        return this.flags;
    }

    @Nullable
    public BukkitEvaluable getColor() {
        return this.color;
    }

    public ItemStackEnchantmentSection[] getEnchantments() {
        return this.enchantments;
    }

    @Nullable
    public BukkitEvaluable getTextures() {
        return this.textures;
    }

    public ItemStackBaseEffectSection getBaseEffect() {
        return this.baseEffect;
    }

    public ItemStackBannerPatternSection[] getBannerPatterns() {
        return this.bannerPatterns;
    }

    public ItemStackCustomEffectSection[] getCustomEffects() {
        return this.customEffects;
    }

    public List<EPatchFlag> getPatchFlags() {
        return this.patchFlags;
    }

    private boolean addMismatchAndPossiblyBreak(ComparisonMismatch mismatch, Set<ComparisonMismatch> mismatches, @Nullable Set<ComparisonMismatch> nonBreakers) {
        mismatches.add(mismatch);
        return nonBreakers == null || !nonBreakers.contains((Object)mismatch);
    }

    public Set<ComparisonMismatch> describesItem(@Nullable ItemStack item, @Nullable Set<ComparisonMismatch> nonBreakers, IEvaluationEnvironment environment) {
        XMaterial material;
        HashSet<ComparisonMismatch> mismatches = new HashSet<ComparisonMismatch>();
        if (item == null) {
            mismatches.add(ComparisonMismatch.IS_NULL);
            return mismatches;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            mismatches.add(ComparisonMismatch.META_UNREADABLE);
            return mismatches;
        }
        if (this.type != null && (material = this.type.asXMaterial(environment)) != null && !material.isSimilar(item) && this.addMismatchAndPossiblyBreak(ComparisonMismatch.TYPE_MISMATCH, mismatches, nonBreakers)) {
            return mismatches;
        }
        if (this.amount != null && this.amount.asScalar(ScalarType.LONG, environment).intValue() != item.getAmount() && this.addMismatchAndPossiblyBreak(ComparisonMismatch.AMOUNT_MISMATCH, mismatches, nonBreakers)) {
            return mismatches;
        }
        if (this.name != null && !this.name.asScalar(ScalarType.STRING, environment).equals(meta.getDisplayName()) && this.addMismatchAndPossiblyBreak(ComparisonMismatch.DISPLAY_NAME_MISMATCH, mismatches, nonBreakers)) {
            return mismatches;
        }
        if (this.lore != null && this.doCollectionsDiffer(this.lore.asList(ScalarType.STRING, environment), meta.getLore()) && this.addMismatchAndPossiblyBreak(ComparisonMismatch.LORE_MISMATCH, mismatches, nonBreakers)) {
            return mismatches;
        }
        if (this.flags != null && this.doCollectionsDiffer(this.flags.asEnumerationConstantSet(ItemFlag.class, environment), meta.getItemFlags()) && this.addMismatchAndPossiblyBreak(ComparisonMismatch.FLAGS_MISMATCH, mismatches, nonBreakers)) {
            return mismatches;
        }
        if (!this.isColorSatisfied(meta, environment) && this.addMismatchAndPossiblyBreak(ComparisonMismatch.COLOR_MISMATCH, mismatches, nonBreakers)) {
            return mismatches;
        }
        if (!this.areEnchantmentsSatisfied(meta, environment) && this.addMismatchAndPossiblyBreak(ComparisonMismatch.ENCHANTMENTS_MISMATCH, mismatches, nonBreakers)) {
            return mismatches;
        }
        if (!this.areTexturesSatisfied(meta, environment) && this.addMismatchAndPossiblyBreak(ComparisonMismatch.TEXTURES_MISMATCH, mismatches, nonBreakers)) {
            return mismatches;
        }
        if (!this.isBaseEffectSatisfied(meta, environment) && this.addMismatchAndPossiblyBreak(ComparisonMismatch.BASE_EFFECT_MISMATCH, mismatches, nonBreakers)) {
            return mismatches;
        }
        if (!this.areCustomEffectsSatisfied(meta, environment) && this.addMismatchAndPossiblyBreak(ComparisonMismatch.CUSTOM_EFFECTS_MISMATCH, mismatches, nonBreakers)) {
            return mismatches;
        }
        if (!this.areBannerPatternsSatisfied(meta, environment) && this.addMismatchAndPossiblyBreak(ComparisonMismatch.BANNER_PATTERNS_MISMATCH, mismatches, nonBreakers)) {
            return mismatches;
        }
        return mismatches;
    }

    private boolean areBannerPatternsSatisfied(ItemMeta meta, IEvaluationEnvironment environment) {
        if (this.bannerPatterns == null) {
            return true;
        }
        if (!(meta instanceof BannerMeta)) {
            return false;
        }
        List patterns = ((BannerMeta)meta).getPatterns();
        for (ItemStackBannerPatternSection patternSection : this.bannerPatterns) {
            boolean anyMatched = false;
            for (Pattern pattern : patterns) {
                if (!patternSection.describesPattern(pattern, environment)) continue;
                anyMatched = true;
                break;
            }
            if (anyMatched) continue;
            return false;
        }
        return true;
    }

    private boolean areCustomEffectsSatisfied(ItemMeta meta, IEvaluationEnvironment environment) {
        if (this.customEffects == null) {
            return true;
        }
        if (!(meta instanceof PotionMeta)) {
            return false;
        }
        List effects = ((PotionMeta)meta).getCustomEffects();
        for (ItemStackCustomEffectSection effectSection : this.customEffects) {
            boolean anyMatched = false;
            for (PotionEffect customEffect : effects) {
                if (!effectSection.describesEffect(customEffect, environment)) continue;
                anyMatched = true;
                break;
            }
            if (anyMatched) continue;
            return false;
        }
        return true;
    }

    private boolean isColorSatisfied(ItemMeta meta, IEvaluationEnvironment environment) {
        if (this.color == null) {
            return true;
        }
        Color bukkitColor = this.color.asBukkitColor(environment);
        if (this.color == null) {
            return true;
        }
        if (meta instanceof PotionMeta) {
            return ((PotionMeta)meta).getColor().equals((Object)bukkitColor);
        }
        if (meta instanceof LeatherArmorMeta) {
            return ((LeatherArmorMeta)meta).getColor().equals((Object)bukkitColor);
        }
        if (meta instanceof MapMeta) {
            return ((MapMeta)meta).getColor().equals((Object)bukkitColor);
        }
        return false;
    }

    private boolean areEnchantmentsSatisfied(ItemMeta meta, IEvaluationEnvironment environment) {
        if (this.enchantments == null) {
            return true;
        }
        for (ItemStackEnchantmentSection enchantment : this.enchantments) {
            boolean enchantmentSatisfied = enchantment.describesEnchantment((e, l) -> {
                if (e == null && l == null) {
                    return true;
                }
                if (e != null && !meta.hasEnchant(e)) {
                    return false;
                }
                if (l != null) {
                    if (e != null) {
                        return meta.getEnchantLevel(e) == l.intValue();
                    }
                    return meta.getEnchants().containsValue(l);
                }
                return true;
            }, environment);
            if (enchantmentSatisfied) continue;
            return false;
        }
        return true;
    }

    private boolean isBaseEffectSatisfied(ItemMeta meta, IEvaluationEnvironment environment) {
        if (this.baseEffect == null) {
            return true;
        }
        if (!(meta instanceof PotionMeta)) {
            return false;
        }
        return this.baseEffect.describesData(((PotionMeta)meta).getBasePotionData(), environment);
    }

    private boolean areTexturesSatisfied(ItemMeta meta, IEvaluationEnvironment environment) {
        if (this.textures == null) {
            return true;
        }
        if (ItemBuilder.texturesHandler == null) {
            return false;
        }
        String itemTextures = ItemBuilder.texturesHandler.getBase64Textures(meta);
        String envTextures = this.textures.asScalar(ScalarType.STRING, environment);
        return envTextures.equals(itemTextures);
    }

    private <T> boolean doCollectionsDiffer(@Nullable Collection<T> a, @Nullable Collection<T> b) {
        if (a == null && b == null) {
            return false;
        }
        if (a == null || b == null) {
            return true;
        }
        if (a.size() != b.size()) {
            return true;
        }
        return !a.containsAll(b);
    }
}

