/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.evaluable.section;

import de.jexcellence.configmapper.ScalarType;
import de.jexcellence.configmapper.sections.AConfigSection;
import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.configmapper.sections.CSIgnore;
import de.jexcellence.evaluable.BukkitEvaluable;
import de.jexcellence.evaluable.IEnumInfo;
import de.jexcellence.evaluable.error.ErrorContext;
import de.jexcellence.evaluable.section.CommandErrorMessagesSection;
import de.jexcellence.evaluable.section.PermissionsSection;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ACommandSection
extends AConfigSection {
    @CSIgnore
    private final String defaultCommandName;
    private String name;
    private String description;
    private String usage;
    @CSAlways
    private List<String> aliases;
    @CSAlways
    private PermissionsSection permissions;
    @CSAlways
    private Map<String, BukkitEvaluable> argumentUsages;
    @CSAlways
    private CommandErrorMessagesSection errorMessages;

    public ACommandSection(String defaultCommandName, EvaluationEnvironmentBuilder environmentBuilder) {
        super(environmentBuilder);
        this.defaultCommandName = defaultCommandName;
    }

    @Override
    @Nullable
    public Object defaultFor(Field field) {
        if (field.getName().equals("name")) {
            return this.defaultCommandName;
        }
        if (field.getType() == String.class) {
            return "";
        }
        return null;
    }

    public Component getMalformedDoubleMessage(ErrorContext errorContext) {
        return this.errorMessages.getMalformedDouble().asComponent(this.getErrorContextEnvironment(errorContext));
    }

    public Component getMalformedFloatMessage(ErrorContext errorContext) {
        return this.errorMessages.getMalformedFloat().asComponent(this.getErrorContextEnvironment(errorContext));
    }

    public Component getMalformedLongMessage(ErrorContext errorContext) {
        return this.errorMessages.getMalformedLong().asComponent(this.getErrorContextEnvironment(errorContext));
    }

    public Component getMalformedIntegerMessage(ErrorContext errorContext) {
        return this.errorMessages.getMalformedInteger().asComponent(this.getErrorContextEnvironment(errorContext));
    }

    public Component getMalformedUuidMessage(ErrorContext errorContext) {
        return this.errorMessages.getMalformedUuid().asComponent(this.getErrorContextEnvironment(errorContext));
    }

    public Component getMalformedEnumMessage(ErrorContext errorContext, IEnumInfo enumInfo) {
        return this.errorMessages.getMalformedEnum().asComponent(new EvaluationEnvironmentBuilder().withStaticVariable("constant_names", enumInfo.getEnumConstantNames()).build(this.getErrorContextEnvironment(errorContext)));
    }

    public Component getMissingArgumentMessage(ErrorContext errorContext) {
        if (errorContext.argumentIndex == null) {
            throw new IllegalStateException("Argument index cannot be null if a usage string is requested");
        }
        int index = errorContext.argumentIndex + 1;
        BukkitEvaluable usageEvaluable = this.argumentUsages.get(String.valueOf(index));
        if (usageEvaluable == null) {
            return MiniMessage.miniMessage().deserialize((Object)("<red>There's no usage string configured for index " + index + "</red>"));
        }
        return Component.join((JoinConfiguration)JoinConfiguration.newlines(), usageEvaluable.asList(ScalarType.COMPONENT, this.getErrorContextEnvironment(errorContext)));
    }

    public Component getNotAPlayerMessage(ErrorContext errorContext) {
        return this.errorMessages.getNotAPlayer().asComponent(this.getErrorContextEnvironment(errorContext));
    }

    public Component getNotAConsoleMessage(ErrorContext errorContext) {
        return this.errorMessages.getNotAConsole().asComponent(this.getErrorContextEnvironment(errorContext));
    }

    public Component getPlayerUnknownMessage(ErrorContext errorContext) {
        return this.errorMessages.getPlayerUnknown().asComponent(this.getErrorContextEnvironment(errorContext));
    }

    public Component getPlayerNotOnlineMessage(ErrorContext errorContext) {
        return this.errorMessages.getPlayerNotOnline().asComponent(this.getErrorContextEnvironment(errorContext));
    }

    public Component getInternalErrorMessage(ErrorContext errorContext) {
        return this.errorMessages.getInternalError().asComponent(this.getErrorContextEnvironment(errorContext));
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases == null ? List.of() : this.aliases;
    }

    @NotNull
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public PermissionsSection getPermissions() {
        return this.permissions;
    }

    @NotNull
    public String getUsage() {
        return this.usage;
    }

    @NotNull
    public String getDefaultCommandName() {
        return this.defaultCommandName;
    }

    private IEvaluationEnvironment getErrorContextEnvironment(ErrorContext context) {
        String value = null;
        if (context.argumentIndex != null && context.argumentIndex < context.arguments.length) {
            value = context.arguments[context.argumentIndex];
        }
        return new EvaluationEnvironmentBuilder().withStaticVariable("value", value).withStaticVariable("alias", context.alias).withStaticVariable("sender_name", context.sender.getName()).build();
    }
}

