/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.evaluable;

import de.jexcellence.configmapper.ScalarType;
import de.jexcellence.evaluable.BukkitEvaluable;
import de.jexcellence.evaluable.EPatchFlag;
import de.jexcellence.evaluable.IItemBuildable;
import de.jexcellence.evaluable.section.ItemStackBannerPatternSection;
import de.jexcellence.evaluable.section.ItemStackBaseEffectSection;
import de.jexcellence.evaluable.section.ItemStackCustomEffectSection;
import de.jexcellence.evaluable.section.ItemStackEnchantmentSection;
import de.jexcellence.evaluable.section.ItemStackSection;
import de.jexcellence.evaluable.textures.TexturesHandler;
import de.jexcellence.gpeee.GPEEE;
import de.jexcellence.gpeee.Tuple;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import de.jexcellence.remapped.com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder
implements IItemBuildable {
    @Nullable
    public static TexturesHandler texturesHandler;
    private final ItemStack baseItem;
    private final ItemMeta baseMeta;
    private boolean loreOverride;
    private boolean flagsOverride;
    private boolean enchantmentsOverride;
    private boolean customEffectsOverride;
    private boolean patternOverride;
    @Nullable
    private BukkitEvaluable name;
    private final List<BukkitEvaluable> loreBlocks;
    @Nullable
    private BukkitEvaluable amount;
    @Nullable
    private BukkitEvaluable type;
    @Nullable
    private BukkitEvaluable color;
    @Nullable
    private BukkitEvaluable textures;
    @Nullable
    private ItemStackBaseEffectSection baseEffect;
    private final List<ItemStackCustomEffectSection> customEffects;
    private final List<ItemStackEnchantmentSection> enchantments;
    private final List<ItemStackBannerPatternSection> bannerPatterns;
    private final List<BukkitEvaluable> flags;

    private ItemBuilder(ItemStack baseItem, ItemMeta baseMeta, boolean loreOverride, boolean flagsOverride, boolean enchantmentsOverride, boolean customEffectsOverride, boolean patternOverride, @Nullable BukkitEvaluable name, List<BukkitEvaluable> loreBlocks, @Nullable BukkitEvaluable amount, @Nullable BukkitEvaluable type, @Nullable BukkitEvaluable color, @Nullable BukkitEvaluable textures, @Nullable ItemStackBaseEffectSection baseEffect, List<ItemStackCustomEffectSection> customEffects, List<ItemStackEnchantmentSection> enchantments, List<ItemStackBannerPatternSection> bannerPatterns, List<BukkitEvaluable> flags) {
        this.baseItem = new ItemStack(baseItem);
        this.baseMeta = baseMeta.clone();
        this.loreOverride = loreOverride;
        this.flagsOverride = flagsOverride;
        this.enchantmentsOverride = enchantmentsOverride;
        this.customEffectsOverride = customEffectsOverride;
        this.patternOverride = patternOverride;
        this.name = name;
        this.loreBlocks = new ArrayList<BukkitEvaluable>(loreBlocks);
        this.amount = amount;
        this.type = type;
        this.color = color;
        this.textures = textures;
        this.baseEffect = baseEffect;
        this.customEffects = new ArrayList<ItemStackCustomEffectSection>(customEffects);
        this.enchantments = new ArrayList<ItemStackEnchantmentSection>(enchantments);
        this.bannerPatterns = new ArrayList<ItemStackBannerPatternSection>(bannerPatterns);
        this.flags = new ArrayList<BukkitEvaluable>(flags);
    }

    public ItemBuilder(Material material, int amount) {
        this(new ItemStack(material), amount);
    }

    public ItemBuilder(ItemStack item, int amount) {
        if (item == null) {
            throw new IllegalStateException("Item cannot be null");
        }
        this.baseItem = new ItemStack(item);
        this.baseItem.setAmount(amount);
        this.baseMeta = item.getItemMeta();
        if (this.baseMeta == null) {
            throw new IllegalStateException("Could not get meta of item");
        }
        this.loreBlocks = new ArrayList<BukkitEvaluable>();
        this.enchantments = new ArrayList<ItemStackEnchantmentSection>();
        this.flags = new ArrayList<BukkitEvaluable>();
        this.customEffects = new ArrayList<ItemStackCustomEffectSection>();
        this.bannerPatterns = new ArrayList<ItemStackBannerPatternSection>();
    }

    public ItemBuilder setType(@Nullable BukkitEvaluable type) {
        if (type == null) {
            return this;
        }
        this.type = type;
        return this;
    }

    public ItemBuilder setAmount(@Nullable BukkitEvaluable amount) {
        if (amount == null) {
            return this;
        }
        this.amount = amount;
        return this;
    }

    public ItemBuilder setName(@Nullable BukkitEvaluable name) {
        this.name = name;
        return this;
    }

    public ItemBuilder extendLore(@Nullable BukkitEvaluable lore) {
        if (lore == null) {
            return this;
        }
        this.loreOverride = false;
        this.loreBlocks.add(lore);
        return this;
    }

    public ItemBuilder overrideLore(@Nullable BukkitEvaluable lore) {
        if (lore == null) {
            return this;
        }
        this.loreOverride = true;
        this.loreBlocks.clear();
        this.loreBlocks.add(lore);
        return this;
    }

    public ItemBuilder extendEnchantments(@Nullable ItemStackEnchantmentSection[] enchantments) {
        if (enchantments == null) {
            return this;
        }
        this.enchantmentsOverride = false;
        Collections.addAll(this.enchantments, enchantments);
        return this;
    }

    public ItemBuilder overrideEnchantments(@Nullable ItemStackEnchantmentSection[] enchantments) {
        this.enchantmentsOverride = true;
        this.enchantments.clear();
        if (enchantments != null) {
            Collections.addAll(this.enchantments, enchantments);
        }
        return this;
    }

    public ItemBuilder extendFlags(@Nullable BukkitEvaluable flags) {
        if (flags == null) {
            return this;
        }
        this.flagsOverride = false;
        this.flags.add(flags);
        return this;
    }

    public ItemBuilder overrideFlags(@Nullable BukkitEvaluable flag) {
        if (flag == null) {
            return this;
        }
        this.flagsOverride = true;
        this.flags.clear();
        this.flags.add(flag);
        return this;
    }

    public ItemBuilder setColor(@Nullable BukkitEvaluable color) {
        if (color == null) {
            return this;
        }
        this.color = color;
        return this;
    }

    public ItemBuilder setBaseEffect(@Nullable ItemStackBaseEffectSection effect) {
        if (effect == null) {
            return this;
        }
        this.baseEffect = effect;
        return this;
    }

    public ItemBuilder extendCustomEffects(@Nullable ItemStackCustomEffectSection[] effects) {
        if (effects == null) {
            return this;
        }
        this.customEffectsOverride = false;
        Collections.addAll(this.customEffects, effects);
        return this;
    }

    public ItemBuilder overrideCustomEffects(@Nullable ItemStackCustomEffectSection[] effects) {
        this.customEffectsOverride = true;
        this.customEffects.clear();
        if (effects != null) {
            Collections.addAll(this.customEffects, effects);
        }
        return this;
    }

    public ItemBuilder setTextures(@Nullable BukkitEvaluable textures) {
        if (textures == null) {
            return this;
        }
        this.textures = textures;
        return this;
    }

    public ItemBuilder extendBannerPatterns(@Nullable ItemStackBannerPatternSection[] patterns) {
        if (patterns == null) {
            return this;
        }
        this.patternOverride = false;
        Collections.addAll(this.bannerPatterns, patterns);
        return this;
    }

    public ItemBuilder overrideBannerPatterns(@Nullable ItemStackBannerPatternSection[] patterns) {
        this.patternOverride = true;
        this.bannerPatterns.clear();
        if (patterns != null) {
            Collections.addAll(this.bannerPatterns, patterns);
        }
        return this;
    }

    @Override
    public ItemStack build() {
        return this.build(GPEEE.EMPTY_ENVIRONMENT);
    }

    @Override
    public ItemStack build(IEvaluationEnvironment environment) {
        Object data;
        Color bukkitColor;
        XMaterial material;
        ItemStack res = this.baseItem.clone();
        ItemMeta resMeta = this.baseMeta.clone();
        if (this.type != null && (material = this.type.asXMaterial(environment)) != null) {
            material.setType(res);
            resMeta = res.getItemMeta();
        }
        if (this.amount != null) {
            res.setAmount(this.amount.asScalar(ScalarType.LONG, environment).intValue());
        }
        if (this.name != null) {
            resMeta.displayName(this.name.asScalar(ScalarType.COMPONENT, environment));
        }
        if (this.loreOverride) {
            resMeta.lore(null);
        }
        if (!this.loreBlocks.isEmpty()) {
            ArrayList<Component> lines = resMeta.lore();
            if (lines == null) {
                lines = new ArrayList<Component>();
            }
            for (BukkitEvaluable line : this.loreBlocks) {
                for (Component lineItem : line.asList(ScalarType.COMPONENT, environment)) {
                    if (lineItem == null) continue;
                    lines.add(lineItem);
                }
            }
            resMeta.lore(lines);
        }
        if (this.color != null && (bukkitColor = this.color.asBukkitColor(environment)) != null) {
            this.applyColor(resMeta, bukkitColor);
        }
        if (this.textures != null) {
            this.applyTextures(resMeta, this.textures.asScalar(ScalarType.STRING, environment));
        }
        if (this.baseEffect != null && (data = this.baseEffect.asData(environment)) != null) {
            this.applyBaseEffect(resMeta, (PotionData)data);
        }
        if (resMeta instanceof PotionMeta) {
            if (this.customEffectsOverride) {
                ((PotionMeta)resMeta).clearCustomEffects();
            }
            for (ItemStackCustomEffectSection customEffect : this.customEffects) {
                PotionEffect effect = customEffect.asEffect(environment);
                if (effect == null) continue;
                this.applyCustomEffect(resMeta, effect);
            }
        }
        if (this.enchantmentsOverride) {
            resMeta.getEnchants().keySet().forEach(arg_0 -> ((ItemMeta)resMeta).removeEnchant(arg_0));
        }
        for (ItemStackEnchantmentSection enchantment : this.enchantments) {
            Tuple<Enchantment, Integer> enchantmentData = enchantment.asEnchantment(environment);
            if (enchantmentData == null) continue;
            resMeta.addEnchant((Enchantment)enchantmentData.a, ((Integer)enchantmentData.b).intValue(), true);
        }
        if (this.flagsOverride) {
            for (ItemFlag flag : ItemFlag.values()) {
                resMeta.removeItemFlags(new ItemFlag[]{flag});
            }
        }
        for (BukkitEvaluable flag : this.flags) {
            for (ItemFlag itemFlag : flag.asEnumerationConstantSet(ItemFlag.class, environment)) {
                resMeta.addItemFlags(new ItemFlag[]{itemFlag});
            }
        }
        if (resMeta instanceof BannerMeta) {
            BannerMeta bannerMeta = (BannerMeta)resMeta;
            if (this.patternOverride) {
                while (!bannerMeta.getPatterns().isEmpty()) {
                    bannerMeta.removePattern(0);
                }
            }
            for (ItemStackBannerPatternSection bannerPattern : this.bannerPatterns) {
                Pattern pattern = bannerPattern.asPattern(environment);
                if (pattern == null) continue;
                this.applyPattern(resMeta, pattern);
            }
        }
        res.setItemMeta(resMeta);
        return res;
    }

    @Override
    public ItemBuilder copy() {
        return new ItemBuilder(this.baseItem, this.baseMeta, this.loreOverride, this.flagsOverride, this.enchantmentsOverride, this.customEffectsOverride, this.patternOverride, this.name, this.loreBlocks, this.amount, this.type, this.color, this.textures, this.baseEffect, this.customEffects, this.enchantments, this.bannerPatterns, this.flags);
    }

    @Override
    public ItemBuilder patch(ItemStackSection data) {
        ItemBuilder res = this.copy();
        if (data.getAmount() != null) {
            res.setAmount(data.getAmount());
        }
        if (data.getType() != null) {
            res.setType(data.getType());
        }
        if (data.getName() != null) {
            res.setName(data.getName());
        }
        if (data.getPatchFlags().contains((Object)EPatchFlag.OVERRIDE_LORE)) {
            res.overrideLore(data.getLore());
        } else {
            res.extendLore(data.getLore());
        }
        if (data.getPatchFlags().contains((Object)EPatchFlag.OVERRIDE_FLAGS)) {
            res.overrideFlags(data.getFlags());
        } else {
            res.extendFlags(data.getFlags());
        }
        if (data.getColor() != null) {
            res.setColor(data.getColor());
        }
        if (data.getPatchFlags().contains((Object)EPatchFlag.OVERRIDE_ENCHANTMENTS)) {
            res.overrideEnchantments(data.getEnchantments());
        } else {
            res.extendEnchantments(data.getEnchantments());
        }
        if (data.getTextures() != null) {
            res.setTextures(data.getTextures());
        }
        if (data.getBaseEffect() != null) {
            res.setBaseEffect(data.getBaseEffect());
        }
        if (data.getPatchFlags().contains((Object)EPatchFlag.OVERRIDE_CUSTOM_EFFECTS)) {
            res.overrideCustomEffects(data.getCustomEffects());
        } else {
            res.extendCustomEffects(data.getCustomEffects());
        }
        if (data.getPatchFlags().contains((Object)EPatchFlag.OVERRIDE_BANNER_PATTERNS)) {
            res.overrideBannerPatterns(data.getBannerPatterns());
        } else {
            res.extendBannerPatterns(data.getBannerPatterns());
        }
        return res;
    }

    private void applyColor(ItemMeta meta, Color color) {
        if (meta instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)meta).setColor(color);
        } else if (meta instanceof PotionMeta) {
            ((PotionMeta)meta).setColor(color);
        } else if (meta instanceof MapMeta) {
            ((MapMeta)meta).setColor(color);
        }
    }

    private void applyBaseEffect(ItemMeta meta, PotionData effect) {
        if (meta instanceof PotionMeta) {
            ((PotionMeta)meta).setBasePotionData(effect);
        }
    }

    private void applyCustomEffect(ItemMeta meta, @Nullable PotionEffect effect) {
        if (effect == null) {
            return;
        }
        if (meta instanceof PotionMeta) {
            ((PotionMeta)meta).addCustomEffect(effect, true);
        }
    }

    private void applyTextures(ItemMeta meta, String textures) {
        if (texturesHandler != null) {
            texturesHandler.setBase64Textures(meta, textures);
        }
    }

    private void applyPattern(ItemMeta meta, Pattern pattern) {
        if (meta instanceof BannerMeta) {
            ((BannerMeta)meta).addPattern(pattern);
        }
    }

    static {
        try {
            try {
                Class.forName("org.bukkit.profile.PlayerProfile");
                texturesHandler = (TexturesHandler)Class.forName("de/jexcellence/evaluable/textures/PlayerProfileTexturesHandler".replace('/', '.')).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                texturesHandler = (TexturesHandler)Class.forName("de/jexcellence/evaluable/textures/GameProfileTexturesHandler".replace('/', '.')).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            texturesHandler = null;
            e.printStackTrace();
        }
    }
}

