/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.evaluable;

import de.jexcellence.evaluable.IEnumInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnumInfo
implements IEnumInfo {
    private final Class<? extends Enum<?>> enumClass;
    private final List<String> enumConstantNames;
    private final List<Enum<?>> enumConstants;
    public final Map<String, Enum<?>> enumConstantByLowerCaseName;

    public EnumInfo(Class<? extends Enum<?>> enumClass) {
        this.enumClass = enumClass;
        this.enumConstants = Collections.unmodifiableList(Arrays.asList(enumClass.getEnumConstants()));
        ArrayList<String> names = new ArrayList<String>();
        HashMap table = new HashMap();
        for (Enum<?> constant : this.enumConstants) {
            String name = constant.name();
            names.add(name);
            table.put(name.toLowerCase(), constant);
        }
        this.enumConstantNames = Collections.unmodifiableList(names);
        this.enumConstantByLowerCaseName = Collections.unmodifiableMap(table);
    }

    @Override
    public Class<? extends Enum<?>> getEnumClass() {
        return this.enumClass;
    }

    @Override
    public List<Enum<?>> getEnumConstants() {
        return this.enumConstants;
    }

    @Override
    public List<String> getEnumConstantNames() {
        return this.enumConstantNames;
    }
}

