/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.evaluable;

import com.google.common.base.Charsets;
import de.jexcellence.configmapper.ConfigMapper;
import de.jexcellence.configmapper.FValueConverter;
import de.jexcellence.configmapper.IConfigMapper;
import de.jexcellence.configmapper.IValueConverterRegistry;
import de.jexcellence.configmapper.YamlConfig;
import de.jexcellence.configmapper.preprocessor.PreProcessor;
import de.jexcellence.configmapper.preprocessor.PreProcessorException;
import de.jexcellence.configmapper.preprocessor.PreProcessorInput;
import de.jexcellence.configmapper.preprocessor.PreProcessorInputException;
import de.jexcellence.evaluable.BukkitEvaluable;
import de.jexcellence.evaluable.BukkitValueInterpreter;
import de.jexcellence.evaluable.IConfigManager;
import de.jexcellence.evaluable.IItemBuildable;
import de.jexcellence.evaluable.functions.Base64ToSkinUrlFunction;
import de.jexcellence.evaluable.functions.SkinUrlToBase64Function;
import de.jexcellence.evaluable.section.ItemStackSection;
import de.jexcellence.gpeee.GPEEE;
import de.jexcellence.gpeee.IExpressionEvaluator;
import de.jexcellence.gpeee.Tuple;
import de.jexcellence.gpeee.functions.AExpressionFunction;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import de.jexcellence.gpeee.parser.expression.AExpression;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class ConfigManager
implements IConfigManager,
IValueConverterRegistry {
    private static final String EXPRESSION_MARKER_SUFFIX = "$";
    private static final String PREPROCESSOR_INPUT_MARKER = "PRE-PROCESSOR-INPUT ";
    private static final Map<URI, FileSystem> fileSystemCache = new HashMap<URI, FileSystem>();
    private final Map<String, Tuple<IExpressionEvaluator, IConfigMapper>> mapperByFileName = new HashMap<String, Tuple<IExpressionEvaluator, IConfigMapper>>();
    private final Map<String, PreProcessorInput> preProcessorInputByFileName = new HashMap<String, PreProcessorInput>();
    private final Logger logger;
    private final Plugin plugin;
    private final AExpressionFunction base64ToSkinUrlFunction;
    private final AExpressionFunction skinUrlToBase64Function;
    private final String folderName;
    private final File folder;
    private final PreProcessor preProcessor;

    public ConfigManager(Logger logger, Path path, String folderName) throws Exception {
        this.plugin = null;
        this.logger = logger;
        this.folderName = folderName.charAt(0) == '/' ? folderName : "/" + folderName;
        this.preProcessor = new PreProcessor();
        this.folder = new File(path.toFile(), folderName);
        if (!this.folder.exists() && !this.folder.mkdirs()) {
            throw new IllegalStateException("Could not create directories for " + String.valueOf(this.folder));
        }
        this.base64ToSkinUrlFunction = new Base64ToSkinUrlFunction();
        this.skinUrlToBase64Function = new SkinUrlToBase64Function();
        this.loadAndPossiblyMigrateInputFiles();
    }

    public ConfigManager(Plugin plugin, String folderName) throws Exception {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.folderName = folderName.charAt(0) == '/' ? folderName : "/" + folderName;
        this.preProcessor = new PreProcessor();
        this.folder = new File(plugin.getDataFolder(), folderName);
        if (!this.folder.exists() && !this.folder.mkdirs()) {
            throw new IllegalStateException("Could not create directories for " + String.valueOf(this.folder));
        }
        this.base64ToSkinUrlFunction = new Base64ToSkinUrlFunction();
        this.skinUrlToBase64Function = new SkinUrlToBase64Function();
        this.loadAndPossiblyMigrateInputFiles();
    }

    private void loadAndPossiblyMigrateInputFile(@Nullable Path internalPath, File externalFile) throws Exception {
        PreProcessorInput externalInput;
        String fileName;
        block32: {
            fileName = externalFile.getName().toLowerCase();
            PreProcessorInput internalInput = null;
            if (internalPath != null) {
                internalInput = new PreProcessorInput();
                try {
                    InputStream internalFileStream = ConfigManager.class.getResourceAsStream(internalPath.toString());
                    if (internalFileStream == null) {
                        throw new IllegalStateException("Expected " + String.valueOf(internalPath) + " to exist within jar");
                    }
                    try (InputStreamReader internalFileStreamReader = new InputStreamReader(internalFileStream, Charsets.UTF_8);){
                        internalInput.load(internalFileStreamReader);
                    }
                }
                catch (PreProcessorInputException e) {
                    throw new IllegalStateException("Conflict " + String.valueOf((Object)e.conflict) + " occurred on line " + e.lineNumber + " while trying to load " + String.valueOf(internalPath));
                }
                if (!externalFile.exists()) {
                    try (FileWriter writer = new FileWriter(externalFile, Charsets.UTF_8);){
                        internalInput.save(writer);
                    }
                    this.preProcessorInputByFileName.put(fileName, internalInput);
                    return;
                }
            }
            if (!externalFile.isFile()) {
                throw new IllegalStateException("Expected file at " + String.valueOf(externalFile) + ", but found directory");
            }
            externalInput = new PreProcessorInput();
            try {
                try (FileReader externalFileReader = new FileReader(externalFile, Charsets.UTF_8);){
                    externalInput.load(externalFileReader);
                }
                if (internalInput == null) break block32;
                int numExtendedKeys = externalInput.migrateTo(internalInput);
                if (numExtendedKeys > 0) {
                    this.logger.log(Level.INFO, "Extended " + numExtendedKeys + " new keys on the pre-processor input " + fileName);
                }
                try (FileWriter writer = new FileWriter(externalFile, Charsets.UTF_8);){
                    externalInput.save(writer);
                }
            }
            catch (PreProcessorInputException e) {
                throw new IllegalStateException("Conflict " + String.valueOf((Object)e.conflict) + " occurred on line " + e.lineNumber + " while trying to load " + String.valueOf(externalFile));
            }
        }
        this.preProcessorInputByFileName.put(fileName, externalInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem acquireFileSystem(URI uri) throws Exception {
        Map<URI, FileSystem> map = fileSystemCache;
        synchronized (map) {
            FileSystem fs = fileSystemCache.get(uri);
            if (fs != null) {
                return fs;
            }
            try {
                fs = FileSystems.getFileSystem(uri);
            }
            catch (FileSystemNotFoundException e) {
                fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
            }
            fileSystemCache.put(uri, fs);
            return fs;
        }
    }

    private List<Path> getTextFilesInFolderWithinResources() throws Exception {
        Path folderPath;
        URL folderUrl = ConfigManager.class.getResource(this.folderName);
        if (folderUrl == null) {
            this.logger.log(Level.FINE, () -> "No bundled resources found at " + this.folderName + "; skipping migration");
            return Collections.emptyList();
        }
        URI folderUri = folderUrl.toURI();
        if (folderUri.getScheme().equals("jar")) {
            FileSystem fileSystem = ConfigManager.acquireFileSystem(folderUri);
            folderPath = fileSystem.getPath(this.folderName, new String[0]);
        } else {
            folderPath = Paths.get(folderUri);
        }
        ArrayList<Path> result = new ArrayList<Path>();
        try (Stream<Path> walkStream = Files.walk(folderPath, 1, new FileVisitOption[0]);){
            Iterator iterator = walkStream.iterator();
            while (iterator.hasNext()) {
                Path parent;
                Path internalPath = (Path)iterator.next();
                if (!internalPath.getFileName().toString().endsWith(".txt") || (parent = internalPath.getParent()) == null || !parent.getFileName().toString().equals(this.folderName.substring(1))) continue;
                result.add(internalPath);
            }
        }
        return result;
    }

    public void loadAndPossiblyMigrateInputFiles() throws Exception {
        for (Path textFilePath : this.getTextFilesInFolderWithinResources()) {
            this.loadAndPossiblyMigrateInputFile(textFilePath, new File(this.folder, textFilePath.getFileName().toString()));
        }
        File[] files = this.folder.listFiles();
        if (files == null) {
            return;
        }
        for (File fileInFolder : files) {
            String fileName = fileInFolder.getName();
            if (!fileName.endsWith(".txt") || this.preProcessorInputByFileName.containsKey(fileName)) continue;
            this.loadAndPossiblyMigrateInputFile(null, fileInFolder);
        }
    }

    @Override
    public IConfigMapper getMapper(String fileName) throws FileNotFoundException {
        Tuple<IExpressionEvaluator, IConfigMapper> mapper = this.mapperByFileName.get(fileName.toLowerCase());
        if (mapper == null) {
            throw new FileNotFoundException("Could not find the config at " + this.folderName + "/" + fileName);
        }
        return (IConfigMapper)mapper.b;
    }

    @Override
    @Nullable
    public Class<?> getRequiredTypeFor(Class<?> type) {
        if (type == BukkitEvaluable.class) {
            return Object.class;
        }
        if (type == IItemBuildable.class) {
            return ItemStackSection.class;
        }
        return null;
    }

    @Override
    @Nullable
    public FValueConverter getConverterFor(Class<?> type) {
        if (type == BukkitEvaluable.class) {
            return BukkitEvaluable::new;
        }
        if (type == IItemBuildable.class) {
            return (value, evaluator) -> ((ItemStackSection)value).asItem();
        }
        return null;
    }

    private String getPluginResourcePath(String fileName) {
        return this.folderName.substring(1) + "/" + fileName;
    }

    private int extendConfig(String fileName, YamlConfig config) throws Exception {
        String resourcePath = this.getPluginResourcePath(fileName);
        try (InputStream resourceStream = this.plugin.getResource(resourcePath);){
            if (resourceStream == null) {
                throw new IllegalStateException("Could not load resource file at " + resourcePath);
            }
            YamlConfig resourceConfig = new YamlConfig(null, this.logger, null);
            try (InputStreamReader resourceStreamReader = new InputStreamReader(resourceStream, Charsets.UTF_8);){
                resourceConfig.load(resourceStreamReader);
            }
            int n = config.extendMissingKeys(resourceConfig);
            return n;
        }
    }

    private void saveConfig(YamlConfig config, String fileName) throws Exception {
        File file = new File(this.folder, fileName);
        if (file.exists() && !file.isFile()) {
            throw new IllegalStateException("Tried to write file; unexpected directory at " + String.valueOf(file));
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);
             OutputStreamWriter outputWriter = new OutputStreamWriter(outputStream);){
            config.save(outputWriter);
        }
    }

    @Nullable
    private String parsePreProcessorFileName(String fileName, YamlConfig config) {
        String inputArgument;
        File file = new File(this.folder, fileName);
        String configHeader = config.getHeader();
        int inputMarkerIndex = configHeader.indexOf(PREPROCESSOR_INPUT_MARKER);
        if (inputMarkerIndex < 0) {
            return null;
        }
        int inputArgumentBegin = inputMarkerIndex += PREPROCESSOR_INPUT_MARKER.length();
        while (inputMarkerIndex < configHeader.length()) {
            char currentChar = configHeader.charAt(inputMarkerIndex);
            if (currentChar == ' ' || currentChar == '\n') {
                --inputMarkerIndex;
                break;
            }
            ++inputMarkerIndex;
        }
        if (!(inputArgument = configHeader.substring(inputArgumentBegin, inputMarkerIndex + 1)).endsWith(".txt")) {
            return null;
        }
        return inputArgument;
    }

    public ConfigMapper loadConfig(String fileName) throws Exception {
        boolean hasBeenCreated = false;
        File file = new File(this.folder, fileName);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IllegalStateException("Tried to read file; unexpected directory at " + String.valueOf(file));
            }
        } else {
            this.plugin.saveResource(this.getPluginResourcePath(fileName), true);
            hasBeenCreated = true;
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            ConfigMapper configMapper;
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, Charsets.UTF_8);){
                Object lutValue;
                String preProcessorFileName;
                int numExtendedKeys;
                GPEEE evaluator = new GPEEE(this.logger);
                YamlConfig config = new YamlConfig(evaluator, this.logger, EXPRESSION_MARKER_SUFFIX);
                config.load(inputStreamReader);
                if (!hasBeenCreated && (numExtendedKeys = this.extendConfig(fileName, config)) > 0) {
                    this.logger.log(Level.INFO, "Extended " + numExtendedKeys + " new keys on the configuration " + fileName);
                    this.saveConfig(config, fileName);
                }
                if ((preProcessorFileName = this.parsePreProcessorFileName(fileName, config)) != null) {
                    PreProcessorInput preProcessorInput = this.preProcessorInputByFileName.get(preProcessorFileName);
                    if (preProcessorInput == null) {
                        throw new IllegalStateException("Could not locate pre-processor input named " + preProcessorFileName + " as requested in " + String.valueOf(file));
                    }
                    this.preProcessor.forEachScalarValue(config, scalarNode -> {
                        String nodeValue = scalarNode.getValue();
                        try {
                            Tuple<String, Boolean> result = this.preProcessor.preProcess(nodeValue, preProcessorInput);
                            this.preProcessor.setScalarValue(scalarNode, (String)result.a);
                            return (Boolean)result.b;
                        }
                        catch (PreProcessorException e) {
                            int lineNumber = scalarNode.getStartMark().getLine();
                            this.logger.severe("An error (" + String.valueOf((Object)e.conflict) + ") occurred while pre-processing " + String.valueOf(file) + " at line " + lineNumber);
                            this.logger.severe("Conflicting position (beginning of output): " + nodeValue.substring(e.charIndex).trim());
                            throw e;
                        }
                    });
                    config.clearKeyCache();
                    this.logger.log(Level.INFO, () -> "Applied pre-processor input " + String.valueOf(preProcessorInput) + " to " + String.valueOf(file));
                    String preProcessorFileNameWithoutExtension = preProcessorFileName.substring(0, preProcessorFileName.lastIndexOf(46));
                    File outputFile = new File(file.getParentFile(), "result." + preProcessorFileNameWithoutExtension + ".yml");
                    try (FileWriter writer = new FileWriter(outputFile, StandardCharsets.UTF_8);){
                        config.save(writer);
                    }
                    this.logger.log(Level.INFO, () -> "Saved read-only pre-processed version of " + String.valueOf(file) + " at " + String.valueOf(outputFile));
                }
                Map lut = (lutValue = config.get("lut")) instanceof Map ? (Map)lutValue : new HashMap();
                EvaluationEnvironmentBuilder baseEnvironment = new EvaluationEnvironmentBuilder().withFunction("base64_to_skin_url", this.base64ToSkinUrlFunction).withFunction("skin_url_to_base64", this.skinUrlToBase64Function).withValueInterpreter(BukkitValueInterpreter.getInstance());
                baseEnvironment.withStaticVariable("lut", this.evaluateLeafExpressions(evaluator, baseEnvironment.build(), lut));
                evaluator.setBaseEnvironment(baseEnvironment);
                ConfigMapper mapper = new ConfigMapper(config, this.logger, evaluator, this);
                this.mapperByFileName.put(fileName.toLowerCase(), new Tuple<GPEEE, ConfigMapper>(evaluator, mapper));
                configMapper = mapper;
            }
            return configMapper;
        }
    }

    private Object evaluateLeafExpressions(GPEEE evaluator, IEvaluationEnvironment environment, Object input) {
        if (input instanceof List) {
            List list = (List)input;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object entry : list) {
                result.add(this.evaluateLeafExpressions(evaluator, environment, entry));
            }
            return result;
        }
        if (input instanceof Map) {
            Map map = (Map)input;
            HashMap result = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                result.put(entry.getKey(), this.evaluateLeafExpressions(evaluator, environment, entry.getValue()));
            }
            return result;
        }
        while (input instanceof AExpression) {
            input = evaluator.evaluateExpression((AExpression)input, environment);
        }
        return input;
    }
}

