/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.evaluable;

import de.jexcellence.configmapper.sections.AConfigSection;
import de.jexcellence.evaluable.ConfigManager;
import java.util.ArrayList;
import java.util.List;

public class ConfigKeeper<T extends AConfigSection> {
    private final ConfigManager configManager;
    private final String fileName;
    private final Class<T> rootSectionType;
    private final List<Runnable> reloadListeners;
    public T rootSection;

    public ConfigKeeper(ConfigManager configManager, String fileName, Class<T> rootSectionType) throws Exception {
        this.configManager = configManager;
        this.fileName = fileName;
        this.rootSectionType = rootSectionType;
        this.reloadListeners = new ArrayList<Runnable>();
        this.rootSection = this.loadRootSection(true);
    }

    public void registerReloadListener(Runnable listener) {
        this.reloadListeners.add(listener);
    }

    public void reload() throws Exception {
        this.rootSection = this.loadRootSection(false);
        for (Runnable listener : this.reloadListeners) {
            listener.run();
        }
    }

    public T mapSection(String rootSection) throws Exception {
        return this.configManager.loadConfig(this.fileName).mapSection(rootSection, this.rootSectionType);
    }

    private T loadRootSection(boolean initial) throws Exception {
        if (!initial) {
            this.configManager.loadAndPossiblyMigrateInputFiles();
        }
        return this.configManager.loadConfig(this.fileName).mapSection(null, this.rootSectionType);
    }
}

