/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.evaluable;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.plugin.Plugin;

public class CommandUpdater {
    private final Field commandMapField;
    private final Method syncCommandsMethod;
    private final SimpleCommandMap commandMap;
    private final Map<String, Command> commandMapCommands;
    private final Logger logger;
    private final String pluginPrefix;

    public CommandUpdater(Plugin plugin) {
        this.logger = plugin.getLogger();
        this.pluginPrefix = plugin.getName().toLowerCase(Locale.ROOT);
        Class<?> craftServerClass = this.locateCraftServerClass(Bukkit.getServer().getClass().getPackageName());
        this.commandMapField = this.locateCommandMapField();
        this.commandMap = this.locateCommandMap(craftServerClass);
        this.commandMapCommands = this.locateCommandMapCommands(this.commandMap);
        this.syncCommandsMethod = this.locateSyncCommandsMethod(craftServerClass);
    }

    public boolean tryUnregisterCommand(Command command) {
        try {
            CommandMap commandMap = (CommandMap)this.commandMapField.get(command);
            if (commandMap == null) {
                throw new IllegalStateException("Expected command " + command.getName() + " to be registered");
            }
            command.unregister(commandMap);
            ArrayList<String> targetNames = new ArrayList<String>();
            for (Map.Entry<String, Command> commandEntry : this.commandMapCommands.entrySet()) {
                if (commandEntry.getValue() != command) continue;
                targetNames.add(commandEntry.getKey());
            }
            for (String targetName : targetNames) {
                this.commandMapCommands.remove(targetName);
            }
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not unregister command " + command.getName(), e);
            return false;
        }
    }

    public void tryRegisterCommand(Command command) {
        try {
            this.commandMap.register(this.pluginPrefix, command);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not register command " + command.getName(), e);
        }
    }

    public void trySyncCommands() {
        try {
            this.syncCommandsMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not sync commands", e);
        }
    }

    private SimpleCommandMap locateCommandMap(Class<?> craftServerClass) {
        try {
            for (Field field : craftServerClass.getDeclaredFields()) {
                if (!SimpleCommandMap.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                return (SimpleCommandMap)field.get(Bukkit.getServer());
            }
            throw new IllegalStateException("No field was of type SimpleCommandMap");
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not locate the CommandMap", e);
        }
    }

    private Map<String, Command> locateCommandMapCommands(SimpleCommandMap commandMap) {
        try {
            for (Field field : SimpleCommandMap.class.getDeclaredFields()) {
                if (!field.getName().equals("knownCommands")) continue;
                field.setAccessible(true);
                return (Map)field.get(commandMap);
            }
            throw new IllegalStateException("Encountered no field named knownCommands");
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not locate commands within CommandMap");
        }
    }

    private Method locateSyncCommandsMethod(Class<?> craftServerClass) {
        try {
            return craftServerClass.getDeclaredMethod("syncCommands", new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not locate CraftServer#syncCommands", e);
        }
    }

    private Class<?> locateCraftServerClass(String bukkitPackage) {
        try {
            return Class.forName(bukkitPackage + ".CraftServer");
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not locate the CraftServer class", e);
        }
    }

    private Field locateCommandMapField() {
        for (Field field : Command.class.getDeclaredFields()) {
            if (field.getType() != CommandMap.class) continue;
            field.setAccessible(true);
            return field;
        }
        throw new IllegalStateException("Could not locate command-map field");
    }
}

