/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.evaluable;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

public class ColorUtil {
    private static final Map<Character, String> LEGACY_TO_MINI_MAP = new HashMap<Character, String>();
    private static final Map<String, String> MINI_TO_LEGACY_MAP = new HashMap<String, String>();
    private static final Pattern MINI_MESSAGE_TAG_PATTERN = Pattern.compile("<(/?)([a-z_]+)>");

    @NotNull
    public static String convertLegacyColorsToMiniMessage(@NotNull String message) {
        String coloredMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        StringBuilder miniMessage = new StringBuilder();
        char[] chars = coloredMessage.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\u00a7' && i + 1 < chars.length) {
                char code;
                String miniTag;
                if ((miniTag = LEGACY_TO_MINI_MAP.get(Character.valueOf(code = chars[++i]))) == null) continue;
                miniMessage.append('<').append(miniTag).append('>');
                continue;
            }
            miniMessage.append(chars[i]);
        }
        return miniMessage.toString();
    }

    @NotNull
    public static String convertMiniMessageToLegacyColors(@NotNull String message) {
        Matcher matcher = MINI_MESSAGE_TAG_PATTERN.matcher(message);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String closingTag = matcher.group(1);
            String tagName = matcher.group(2);
            String legacyCode = MINI_TO_LEGACY_MAP.get(tagName);
            if (legacyCode != null) {
                if (closingTag.isEmpty()) {
                    matcher.appendReplacement(result, legacyCode);
                    continue;
                }
                matcher.appendReplacement(result, "&r");
                continue;
            }
            matcher.appendReplacement(result, "");
        }
        matcher.appendTail(result);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)result.toString());
    }

    static {
        LEGACY_TO_MINI_MAP.put(Character.valueOf('0'), "black");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('1'), "dark_blue");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('2'), "dark_green");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('3'), "dark_aqua");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('4'), "dark_red");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('5'), "dark_purple");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('6'), "gold");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('7'), "gray");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('8'), "dark_gray");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('9'), "blue");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('a'), "green");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('b'), "aqua");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('c'), "red");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('d'), "light_purple");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('e'), "yellow");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('f'), "white");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('k'), "obfuscated");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('l'), "bold");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('m'), "strikethrough");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('n'), "underlined");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('o'), "italic");
        LEGACY_TO_MINI_MAP.put(Character.valueOf('r'), "reset");
        for (Map.Entry<Character, String> entry : LEGACY_TO_MINI_MAP.entrySet()) {
            MINI_TO_LEGACY_MAP.put(entry.getValue(), "&" + String.valueOf(entry.getKey()));
        }
    }
}

