/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.evaluable;

import de.jexcellence.configmapper.ConfigValue;
import de.jexcellence.configmapper.ScalarType;
import de.jexcellence.evaluable.ColorUtil;
import de.jexcellence.evaluable.FUnsafeTriFunction;
import de.jexcellence.gpeee.GPEEE;
import de.jexcellence.gpeee.IExpressionEvaluator;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import de.jexcellence.remapped.com.cryptomorin.xseries.XEnchantment;
import de.jexcellence.remapped.com.cryptomorin.xseries.XMaterial;
import de.jexcellence.remapped.com.cryptomorin.xseries.XPotion;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.ChatColor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.Nullable;

public class BukkitEvaluable
extends ConfigValue {
    public static final BukkitEvaluable UNDEFINED_STRING = BukkitEvaluable.of("undefined");
    private static final Map<Class<?>, Map<String, Object>> enumCache = new HashMap();

    public BukkitEvaluable(@Nullable Object value, @Nullable IExpressionEvaluator evaluator) {
        super(value, evaluator);
    }

    public static BukkitEvaluable of(@Nullable Object value) {
        return new BukkitEvaluable(value, null);
    }

    public Component asComponent(IEvaluationEnvironment environment) {
        return MiniMessage.miniMessage().deserialize((Object)ColorUtil.convertLegacyColorsToMiniMessage(this.asString(environment)));
    }

    @Nullable
    public XMaterial asXMaterial(IEvaluationEnvironment environment) {
        return XMaterial.matchXMaterial((String)this.asString(environment)).orElse(null);
    }

    @Nullable
    public Enchantment asEnchantment(IEvaluationEnvironment environment) {
        XEnchantment xEnchantment = XEnchantment.matchXEnchantment((String)this.asString(environment)).orElse(null);
        return xEnchantment == null ? null : xEnchantment.getEnchant();
    }

    @Nullable
    public PotionType asPotionType(IEvaluationEnvironment environment) {
        String stringValue = this.asString(environment);
        Optional xPotion = XPotion.matchXPotion((String)stringValue);
        if (xPotion.isPresent()) {
            return ((XPotion)xPotion.get()).getPotionType();
        }
        try {
            return PotionType.valueOf((String)stringValue.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Nullable
    public PotionEffectType asPotionEffectType(IEvaluationEnvironment environment) {
        XPotion potion = XPotion.matchXPotion((String)this.asString(environment)).orElse(null);
        return potion == null ? null : potion.getPotionEffectType();
    }

    @Nullable
    public Color asJavaColor(IEvaluationEnvironment environment) {
        String stringValue = this.asString(environment);
        return this.parseRGBNotation(stringValue, Color::new);
    }

    @Nullable
    public org.bukkit.Color asBukkitColor(IEvaluationEnvironment environment) {
        String stringValue = this.asString(environment);
        org.bukkit.Color enumValue = BukkitEvaluable.parseEnum(org.bukkit.Color.class, stringValue);
        if (enumValue != null) {
            return enumValue;
        }
        return this.parseRGBNotation(stringValue, org.bukkit.Color::fromRGB);
    }

    @Nullable
    private <T> T parseRGBNotation(String value, FUnsafeTriFunction<Integer, Integer, Integer, T, Exception> parser) {
        String[] parts = value.split(" ");
        if (parts.length != 3) {
            return null;
        }
        try {
            return parser.apply(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public <T> T asEnumerationConstant(Class<T> enumerationClass, IEvaluationEnvironment environment) {
        return BukkitEvaluable.parseEnum(enumerationClass, this.asString(environment));
    }

    public <T> Set<T> asEnumerationConstantSet(Class<T> enumerationClass, IEvaluationEnvironment environment) {
        Set<String> values = this.asSet(ScalarType.STRING, environment);
        HashSet<T> constants = new HashSet<T>();
        for (String value : values) {
            T constant = BukkitEvaluable.parseEnum(enumerationClass, value);
            if (constant == null) continue;
            constants.add(constant);
        }
        return constants;
    }

    public String stringify(IEvaluationEnvironment environment, BukkitEvaluable ... others) {
        String self = this.asScalar(ScalarType.STRING, environment);
        if (others.length == 0) {
            return self;
        }
        StringJoiner joiner = new StringJoiner("");
        joiner.add(self);
        for (BukkitEvaluable evaluable : others) {
            joiner.add(evaluable.asScalar(ScalarType.STRING, environment));
        }
        return joiner.toString();
    }

    public String stringify(BukkitEvaluable ... others) {
        return this.stringify(GPEEE.EMPTY_ENVIRONMENT, others);
    }

    @Override
    protected <T> T interpretScalar(@Nullable Object input, ScalarType<T> type, IEvaluationEnvironment env) {
        Object scalar = super.interpretScalar(input, type, env);
        if (scalar instanceof String) {
            scalar = ColorUtil.convertMiniMessageToLegacyColors(ChatColor.translateAlternateColorCodes((char)'&', (String)((String)scalar)));
        }
        return scalar;
    }

    private String asString(IEvaluationEnvironment environment) {
        return ColorUtil.convertMiniMessageToLegacyColors(this.asScalar(ScalarType.STRING, environment));
    }

    @Nullable
    private static <T> T parseEnum(Class<T> type, String value) {
        value = value.trim().toLowerCase(Locale.ROOT);
        Optional<Object> cacheLookup = BukkitEvaluable.performEnumCacheLookup(type, value);
        Object result = null;
        if (cacheLookup.isPresent()) {
            return (T)cacheLookup.get();
        }
        if (type.isEnum()) {
            for (T enumConstant : type.getEnumConstants()) {
                if (!((Enum)enumConstant).name().toLowerCase().equals(value)) continue;
                result = enumConstant;
                break;
            }
        } else {
            try {
                List<Field> constants = Arrays.stream(type.getDeclaredFields()).filter(field -> field.getType().equals(type) && Modifier.isStatic(field.getModifiers())).toList();
                for (Field constant : constants) {
                    if (!constant.getName().toLowerCase().equals(value)) continue;
                    result = constant.get(null);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (result != null) {
            BukkitEvaluable.cacheEnumLookup(type, value, result);
        }
        return (T)result;
    }

    private static Optional<Object> performEnumCacheLookup(Class<?> type, String value) {
        Map<String, Object> constantCache = enumCache.get(type);
        if (constantCache != null && constantCache.containsKey(value)) {
            return Optional.of(constantCache.get(value));
        }
        return Optional.empty();
    }

    private static void cacheEnumLookup(Class<?> type, String value, Object constant) {
        enumCache.computeIfAbsent(type, key -> new HashMap()).put(value, constant);
    }
}

