/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.dependency.remapper;

import de.jexcellence.dependency.downloader.DependencyDownloader;
import de.jexcellence.dependency.injector.ClasspathInjector;
import de.jexcellence.dependency.loader.YamlDependencyLoader;
import de.jexcellence.dependency.model.DependencyCoordinate;
import de.jexcellence.dependency.model.DownloadResult;
import de.jexcellence.dependency.module.Deencapsulation;
import de.jexcellence.dependency.remapper.PackageRemapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class RemappingDependencyManager {
    private static final Logger LOGGER = Logger.getLogger(RemappingDependencyManager.class.getName());
    private static final String LIBRARIES_DIR_NAME = "libraries";
    private static final String REMAPPED_DIR_NAME = "remapped";
    private static final String RELOCATIONS_PROPERTY = "jedependency.relocations";
    private static final String RELOCATIONS_PREFIX_PROPERTY = "jedependency.relocations.prefix";
    private static final String RELOCATIONS_EXCLUDES_PROPERTY = "jedependency.relocations.excludes";
    private static final long MINIMUM_VALID_JAR_SIZE = 1024L;
    private final DependencyDownloader downloader = new DependencyDownloader();
    private final ClasspathInjector injector = new ClasspathInjector();
    private final YamlDependencyLoader yamlLoader = new YamlDependencyLoader();
    @Nullable
    private final JavaPlugin plugin;
    @Nullable
    private final Class<?> anchorClass;
    private final Path dataDirectory;
    private final Path librariesDirectory;
    private final Path remappedDirectory;
    private final List<DependencyCoordinate> coordinates = new ArrayList<DependencyCoordinate>();
    private final Map<String, String> relocations = new LinkedHashMap<String, String>();

    public RemappingDependencyManager(@NotNull Path dataDirectory) {
        this.plugin = null;
        this.anchorClass = null;
        this.dataDirectory = Objects.requireNonNull(dataDirectory, "dataDirectory");
        this.librariesDirectory = this.dataDirectory.resolve(LIBRARIES_DIR_NAME);
        this.remappedDirectory = this.librariesDirectory.resolve(REMAPPED_DIR_NAME);
        this.ensureDirectories();
        this.loadRelocationsFromSystemProperties();
    }

    public RemappingDependencyManager(@NotNull JavaPlugin plugin, @NotNull Class<?> anchorClass) {
        this.plugin = Objects.requireNonNull(plugin, "plugin");
        this.anchorClass = Objects.requireNonNull(anchorClass, "anchorClass");
        this.dataDirectory = plugin.getDataFolder().toPath();
        this.librariesDirectory = this.dataDirectory.resolve(LIBRARIES_DIR_NAME);
        this.remappedDirectory = this.librariesDirectory.resolve(REMAPPED_DIR_NAME);
        this.ensureDirectories();
        this.loadRelocationsFromSystemProperties();
    }

    public RemappingDependencyManager() {
        this.plugin = null;
        this.anchorClass = null;
        String base = System.getProperty("jedependency.dataDir", ".");
        this.dataDirectory = Path.of(base, new String[0]);
        this.librariesDirectory = this.dataDirectory.resolve(LIBRARIES_DIR_NAME);
        this.remappedDirectory = this.librariesDirectory.resolve(REMAPPED_DIR_NAME);
        this.ensureDirectories();
        this.loadRelocationsFromSystemProperties();
    }

    public void relocate(@NotNull String fromPackage, @NotNull String toPackage) {
        String from = RemappingDependencyManager.normalizePackage(fromPackage);
        String to = RemappingDependencyManager.normalizePackage(toPackage);
        if (from.isEmpty() || to.isEmpty()) {
            LOGGER.warning("Ignoring relocation with empty package: '" + fromPackage + "' => '" + toPackage + "'");
            return;
        }
        if (RemappingDependencyManager.isRestrictedRoot(from)) {
            LOGGER.warning("Ignoring relocation from restricted root: '" + from + "'");
            return;
        }
        if (from.equals(to)) {
            return;
        }
        this.relocations.put(from, to);
        LOGGER.fine(() -> "Registered relocation: " + from + " => " + to);
    }

    public void remap(@NotNull Path inputJar, @NotNull Path outputJar) throws IOException {
        Objects.requireNonNull(inputJar, "inputJar");
        Objects.requireNonNull(outputJar, "outputJar");
        if (this.relocations.isEmpty()) {
            RemappingDependencyManager.copyJarVerbatim(inputJar, outputJar);
            return;
        }
        RemappingDependencyManager.ensureParent(outputJar);
        try {
            PackageRemapper remapper = new PackageRemapper();
            remapper.addMappings(this.relocations);
            remapper.remap(inputJar, outputJar);
        }
        catch (IOException ioe) {
            RemappingDependencyManager.safeDelete(outputJar);
            throw ioe;
        }
        if (!RemappingDependencyManager.isValidJar(outputJar)) {
            RemappingDependencyManager.safeDelete(outputJar);
            throw new IOException("Remapper produced no valid output for: " + String.valueOf(inputJar.getFileName()));
        }
        LOGGER.fine(() -> "Remapped " + String.valueOf(inputJar.getFileName()) + " -> " + String.valueOf(outputJar.getFileName()) + " at " + String.valueOf(Instant.now()));
    }

    public void initialize(@Nullable String[] additionalDependencies) {
        Class<?> deencapClass = this.anchorClass != null ? this.anchorClass : this.getClass();
        try {
            Deencapsulation.deencapsulate(deencapClass);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Deencapsulation failed (continuing): " + ex.getMessage(), ex);
        }
        this.loadYamlDependencies(deencapClass);
        if (additionalDependencies != null && additionalDependencies.length > 0) {
            this.addDependencies(additionalDependencies);
        }
        ClassLoader cl = this.anchorClass != null ? this.anchorClass.getClassLoader() : Thread.currentThread().getContextClassLoader();
        try {
            this.downloadRemapAndInject(cl);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to initialize dependencies with remapping", ex);
        }
    }

    public void addDependencies(@Nullable String[] additionalDependencies) {
        if (additionalDependencies == null || additionalDependencies.length == 0) {
            return;
        }
        for (String dep : additionalDependencies) {
            DependencyCoordinate coord = DependencyCoordinate.parse(dep);
            if (coord != null) {
                this.coordinates.add(coord);
                LOGGER.fine("Added additional dependency: " + dep);
                continue;
            }
            LOGGER.warning("Invalid dependency coordinate: " + dep);
        }
    }

    public void loadAll(@NotNull ClassLoader classLoader) {
        try {
            this.downloadRemapAndInject(classLoader);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to load all dependencies with remapping", ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void downloadRemapAndInject(@NotNull ClassLoader classLoader) throws IOException {
        void var5_9;
        ArrayList<Path> inputJars = new ArrayList<Path>();
        ArrayList<DependencyCoordinate> toProcess = new ArrayList<DependencyCoordinate>(this.coordinates);
        if (toProcess.isEmpty()) {
            LOGGER.info("No dependencies registered for remapping/injection");
            return;
        }
        for (DependencyCoordinate dependencyCoordinate : toProcess) {
            DownloadResult result = this.downloader.download(dependencyCoordinate, this.librariesDirectory.toFile());
            if (result.success() && result.file() != null) {
                inputJars.add(result.file().toPath());
                LOGGER.fine("Downloaded " + dependencyCoordinate.toGavString() + " -> " + result.file().getName());
                continue;
            }
            LOGGER.warning("Failed to download dependency: " + dependencyCoordinate.toGavString());
        }
        ArrayList<Path> jarsToInject = new ArrayList<Path>();
        if (this.relocations.isEmpty()) {
            jarsToInject.addAll(inputJars);
            LOGGER.info("No relocations specified; injecting original libraries");
        } else {
            this.ensureDirectories();
            for (Path input : inputJars) {
                Path output = this.remappedDirectory.resolve(input.getFileName().toString());
                if (RemappingDependencyManager.isOutputUpToDate(output, input)) {
                    LOGGER.fine("Using cached remapped JAR: " + String.valueOf(output.getFileName()));
                    jarsToInject.add(output);
                    continue;
                }
                try {
                    this.remap(input, output);
                    jarsToInject.add(output);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, "Remapping failed for " + String.valueOf(input.getFileName()) + " (injecting original)", ex);
                    jarsToInject.add(input);
                }
            }
            LOGGER.info("Remapping complete: " + jarsToInject.size() + " artifact(s) prepared");
        }
        boolean bl = false;
        for (Path jar : jarsToInject) {
            try {
                if (this.injector.tryInject(classLoader, jar.toFile())) {
                    ++var5_9;
                    LOGGER.fine("Injected into classpath: " + String.valueOf(jar.getFileName()));
                    continue;
                }
                LOGGER.warning("Injection failed: " + String.valueOf(jar.getFileName()));
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Injection error for " + String.valueOf(jar.getFileName()), ex);
            }
        }
        LOGGER.info("Injected " + (int)var5_9 + " of " + jarsToInject.size() + " JAR(s) into classpath");
    }

    private void loadYamlDependencies(@NotNull Class<?> contextClass) {
        try {
            List<String> yamlDeps = this.yamlLoader.loadDependencies(contextClass);
            if (yamlDeps == null || yamlDeps.isEmpty()) {
                LOGGER.info("No dependencies found in YAML configuration");
                return;
            }
            LOGGER.info("Loaded " + yamlDeps.size() + " dependencies from YAML");
            for (String dep : yamlDeps) {
                DependencyCoordinate coord = DependencyCoordinate.parse(dep);
                if (coord != null) {
                    this.coordinates.add(coord);
                    LOGGER.fine("YAML dependency: " + dep);
                    continue;
                }
                LOGGER.warning("Invalid dependency format in YAML: " + dep);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to load YAML dependencies", ex);
        }
    }

    private static Manifest copyOrCreateManifest(JarFile in) throws IOException {
        Manifest manifest = in.getManifest();
        if (manifest != null) {
            Attributes main = manifest.getMainAttributes();
            if (main.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
                main.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            }
            return manifest;
        }
        Manifest mf = new Manifest();
        mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        return mf;
    }

    private static void writeEntryIfAbsent(JarFile in, JarEntry src, JarOutputStream out, Set<String> written, String name) throws IOException {
        if (written.add(name)) {
            JarEntry dst = new JarEntry(name);
            if (src.getLastModifiedTime() != null) {
                dst.setLastModifiedTime(src.getLastModifiedTime());
            }
            out.putNextEntry(dst);
            try (InputStream is = in.getInputStream(src);){
                is.transferTo(out);
            }
            out.closeEntry();
        }
    }

    private static void writeBytes(JarOutputStream out, Set<String> written, String name, byte[] bytes) throws IOException {
        if (written.add(name)) {
            JarEntry dst = new JarEntry(name);
            out.putNextEntry(dst);
            out.write(bytes);
            out.closeEntry();
        }
    }

    private static byte[] readAll(JarFile in, JarEntry entry) throws IOException {
        try (InputStream is = in.getInputStream(entry);){
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
    }

    private static byte[] transformClass(byte[] original, Remapper remapper) {
        ClassReader cr = new ClassReader(original);
        ClassWriter cw = new ClassWriter(0);
        ClassRemapper classRemapper = new ClassRemapper((ClassVisitor)cw, remapper);
        cr.accept((ClassVisitor)classRemapper, 0);
        return cw.toByteArray();
    }

    private static void copyJarVerbatim(@NotNull Path inputJar, @NotNull Path outputJar) throws IOException {
        RemappingDependencyManager.ensureParent(outputJar);
        try (JarFile in = new JarFile(inputJar.toFile());
             JarOutputStream out = new JarOutputStream(Files.newOutputStream(outputJar, new OpenOption[0]), RemappingDependencyManager.copyOrCreateManifest(in));){
            AtomicInteger count = new AtomicInteger(0);
            in.stream().sorted(Comparator.comparing(ZipEntry::getName)).forEach(entry -> {
                try {
                    if (!entry.isDirectory()) {
                        RemappingDependencyManager.writeEntryIfAbsent(in, entry, out, new LinkedHashSet<String>(), entry.getName());
                        count.incrementAndGet();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            out.flush();
            LOGGER.fine("Copied " + count.get() + " entries: " + String.valueOf(inputJar.getFileName()) + " -> " + String.valueOf(outputJar.getFileName()));
        }
        catch (UncheckedIOException uioe) {
            RemappingDependencyManager.safeDelete(outputJar);
            throw uioe.getCause();
        }
        catch (IOException ioe) {
            RemappingDependencyManager.safeDelete(outputJar);
            throw ioe;
        }
    }

    private static boolean isValidJar(@NotNull Path jar) {
        try {
            return Files.isRegularFile(jar, new LinkOption[0]) && Files.size(jar) >= 1024L && jar.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".jar");
        }
        catch (IOException e) {
            return false;
        }
    }

    private static void ensureParent(@NotNull Path file) throws IOException {
        Path parent = file.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    private static void safeDelete(@NotNull Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Failed to delete file: " + String.valueOf(file), ex);
        }
    }

    private static String normalizePackage(@Nullable String pkg) {
        if (pkg == null) {
            return "";
        }
        return pkg.trim().replaceAll("\\.$", "");
    }

    private static boolean isRestrictedRoot(String pkg) {
        if (pkg.equals("java") || pkg.startsWith("java.") || pkg.equals("javax") || pkg.startsWith("javax.") || pkg.equals("jakarta") || pkg.startsWith("jakarta.")) {
            return true;
        }
        if (pkg.equals("org.hibernate") || pkg.startsWith("org.hibernate.")) {
            return true;
        }
        return pkg.equals("com.fasterxml") || pkg.startsWith("com.fasterxml.");
    }

    private static String relocateResourcePath(String name, Map<String, String> relocations) {
        Object bestFrom = null;
        String bestTo = null;
        int bestLen = -1;
        for (Map.Entry<String, String> e : relocations.entrySet()) {
            String fromPath = e.getKey().replace('.', '/') + "/";
            if (!name.startsWith(fromPath) || fromPath.length() <= bestLen) continue;
            bestFrom = fromPath;
            bestTo = e.getValue().replace('.', '/') + "/";
            bestLen = fromPath.length();
        }
        if (bestFrom != null) {
            return bestTo + name.substring(((String)bestFrom).length());
        }
        return name;
    }

    private void loadRelocationsFromSystemProperties() {
        String excludes;
        String basePrefix;
        String spec = System.getProperty(RELOCATIONS_PROPERTY);
        if (spec != null && !spec.trim().isEmpty()) {
            String[] pairs;
            for (String pair : pairs = spec.split(",")) {
                String t = pair.trim();
                if (t.isEmpty()) continue;
                int idx = t.indexOf("=>");
                if (idx <= 0 || idx >= t.length() - 2) {
                    LOGGER.warning("Invalid relocation mapping (expected 'from=>to'): " + t);
                    continue;
                }
                String from = RemappingDependencyManager.normalizePackage(t.substring(0, idx));
                String to = RemappingDependencyManager.normalizePackage(t.substring(idx + 2));
                if (from.isEmpty() || to.isEmpty()) {
                    LOGGER.warning("Ignoring empty relocation mapping: " + t);
                    continue;
                }
                this.relocate(from, to);
            }
        }
        if ((basePrefix = System.getProperty(RELOCATIONS_PREFIX_PROPERTY)) != null && !basePrefix.trim().isEmpty()) {
            LOGGER.fine("Relocation base prefix configured (no automatic detection in legacy path): " + basePrefix.trim());
        }
        if ((excludes = System.getProperty(RELOCATIONS_EXCLUDES_PROPERTY)) != null && !excludes.trim().isEmpty()) {
            LOGGER.fine("Additional excluded relocation roots: " + excludes);
        }
    }

    private static boolean isOutputUpToDate(@NotNull Path output, @NotNull Path input) {
        try {
            if (!Files.exists(output, new LinkOption[0]) || !Files.isRegularFile(output, new LinkOption[0])) {
                return false;
            }
            FileTime inTime = Files.getLastModifiedTime(input, new LinkOption[0]);
            FileTime outTime = Files.getLastModifiedTime(output, new LinkOption[0]);
            long outSize = Files.size(output);
            return outSize > 0L && outTime.compareTo(inTime) >= 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void ensureDirectories() {
        try {
            Files.createDirectories(this.librariesDirectory, new FileAttribute[0]);
            Files.createDirectories(this.remappedDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to create libraries directories: " + e.getMessage(), e);
        }
    }

    public String debugInfo() {
        String base = "dataDir=" + String.valueOf(this.dataDirectory) + ", libraries=" + String.valueOf(this.librariesDirectory) + ", remapped=" + String.valueOf(this.remappedDirectory) + ", deps=" + this.coordinates.size() + ", relocations=" + this.relocations.size();
        Object pluginInfo = this.plugin != null ? ", plugin=" + this.plugin.getName() + ", anchor=" + (this.anchorClass != null ? this.anchorClass.getName() : "null") : ", plugin=null, anchor=null";
        return base + (String)pluginInfo;
    }

    private static Path pathFromUrl(@NotNull String url) {
        String decoded = URLDecoder.decode(url, StandardCharsets.UTF_8);
        return Path.of(decoded.replace("file:", ""), new String[0]);
    }

    private static final class PrefixRelocationRemapper
    extends Remapper {
        private final Map<String, String> prefixMapInternal = new LinkedHashMap<String, String>();

        PrefixRelocationRemapper(Map<String, String> relocations) {
            relocations.entrySet().stream().sorted(Comparator.comparingInt(e -> -((String)e.getKey()).length())).forEach(e -> this.prefixMapInternal.put(((String)e.getKey()).replace('.', '/'), ((String)e.getValue()).replace('.', '/')));
        }

        public String map(String internalName) {
            if (internalName == null) {
                return null;
            }
            if (internalName.startsWith("[")) {
                return super.map(internalName);
            }
            return this.relocateInternal(internalName);
        }

        public String mapPackageName(String name) {
            if (name == null) {
                return null;
            }
            String internal = name.replace('.', '/');
            String mapped = this.relocateInternal(internal);
            return mapped.replace('/', '.');
        }

        private String relocateInternal(String internal) {
            for (Map.Entry<String, String> e : this.prefixMapInternal.entrySet()) {
                String from = e.getKey();
                if (!internal.equals(from) && !internal.startsWith(from + "/")) continue;
                return e.getValue() + internal.substring(from.length());
            }
            return internal;
        }
    }
}

