/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.dependency.remapper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class PackageRemapper {
    private static final Logger LOGGER = Logger.getLogger(PackageRemapper.class.getName());
    private final Map<String, String> packageMappings = new LinkedHashMap<String, String>();

    public void addMapping(@NotNull String originalPackage, @NotNull String remappedPackage) {
        String from = PackageRemapper.normalizePackage(originalPackage);
        String to = PackageRemapper.normalizePackage(remappedPackage);
        if (from.isEmpty() || to.isEmpty() || from.equals(to)) {
            return;
        }
        this.packageMappings.put(from, to);
    }

    public void addMappings(@NotNull Map<String, String> mappings) {
        mappings.forEach(this::addMapping);
    }

    public void remap(@NotNull Path inputJar, @NotNull Path outputJar) throws IOException {
        if (this.packageMappings.isEmpty()) {
            PackageRemapper.copyVerbatim(inputJar, outputJar);
            return;
        }
        Files.createDirectories(outputJar.getParent(), new FileAttribute[0]);
        try (JarFile in = new JarFile(inputJar.toFile());
             JarOutputStream out = new JarOutputStream(Files.newOutputStream(outputJar, new OpenOption[0]), PackageRemapper.copyOrCreateManifest(in));){
            LinkedHashSet<String> written = new LinkedHashSet<String>();
            written.add("META-INF/MANIFEST.MF");
            PrefixRelocationRemapper remapper = new PrefixRelocationRemapper(this.packageMappings);
            in.stream().sorted(Comparator.comparing(ZipEntry::getName)).forEach(entry -> {
                try {
                    if (entry.isDirectory()) {
                        return;
                    }
                    String name = entry.getName();
                    if (PackageRemapper.isSignatureFile(name)) {
                        return;
                    }
                    if (PackageRemapper.isManifestFile(name) || PackageRemapper.isIndexList(name)) {
                        return;
                    }
                    if (PackageRemapper.isServiceFile(name)) {
                        byte[] data = PackageRemapper.readAll(in, entry);
                        byte[] rewritten = PackageRemapper.rewriteServiceFile(data, this.packageMappings);
                        PackageRemapper.writeBytes(out, written, name, rewritten);
                        return;
                    }
                    if (name.startsWith("META-INF/") && !name.startsWith("META-INF/versions/")) {
                        PackageRemapper.writeEntryIfAbsent(in, entry, out, written, name);
                        return;
                    }
                    if (name.endsWith(".class")) {
                        byte[] original = PackageRemapper.readAll(in, entry);
                        byte[] transformed = PackageRemapper.transformClass(original, remapper);
                        String remappedName = PackageRemapper.relocateResourcePath(name, this.packageMappings);
                        PackageRemapper.writeBytes(out, written, remappedName, transformed);
                    } else {
                        String remappedName = PackageRemapper.relocateResourcePath(name, this.packageMappings);
                        PackageRemapper.writeEntryIfAbsent(in, entry, out, written, remappedName);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            out.flush();
        }
        catch (RuntimeException rte) {
            Throwable throwable = rte.getCause();
            if (throwable instanceof IOException) {
                IOException ioe = (IOException)throwable;
                throw ioe;
            }
            throw rte;
        }
        catch (IOException ioe) {
            try {
                Files.deleteIfExists(outputJar);
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, "Failed to delete incomplete output: " + String.valueOf(outputJar), ex);
            }
            throw ioe;
        }
    }

    private static Manifest copyOrCreateManifest(JarFile in) throws IOException {
        Manifest manifest = in.getManifest();
        if (manifest != null) {
            Attributes main = manifest.getMainAttributes();
            if (main.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
                main.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            }
            return manifest;
        }
        Manifest mf = new Manifest();
        mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        return mf;
    }

    private static void copyVerbatim(@NotNull Path inputJar, @NotNull Path outputJar) throws IOException {
        Files.createDirectories(outputJar.getParent(), new FileAttribute[0]);
        try (JarFile in = new JarFile(inputJar.toFile());
             JarOutputStream out = new JarOutputStream(Files.newOutputStream(outputJar, new OpenOption[0]), PackageRemapper.copyOrCreateManifest(in));){
            LinkedHashSet<String> written = new LinkedHashSet<String>();
            written.add("META-INF/MANIFEST.MF");
            in.stream().sorted(Comparator.comparing(ZipEntry::getName)).forEach(entry -> {
                try {
                    if (entry.isDirectory()) {
                        return;
                    }
                    String name = entry.getName();
                    if (PackageRemapper.isSignatureFile(name)) {
                        return;
                    }
                    if (PackageRemapper.isManifestFile(name) || PackageRemapper.isIndexList(name)) {
                        return;
                    }
                    PackageRemapper.writeEntryIfAbsent(in, entry, out, written, name);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            out.flush();
        }
        catch (RuntimeException rte) {
            Throwable throwable = rte.getCause();
            if (throwable instanceof IOException) {
                IOException ioe = (IOException)throwable;
                throw ioe;
            }
            throw rte;
        }
    }

    private static void writeEntryIfAbsent(JarFile in, JarEntry src, JarOutputStream out, Set<String> written, String name) throws IOException {
        if (written.add(name)) {
            JarEntry dst = new JarEntry(name);
            if (src.getLastModifiedTime() != null) {
                dst.setLastModifiedTime(src.getLastModifiedTime());
            }
            out.putNextEntry(dst);
            try (InputStream is = in.getInputStream(src);){
                is.transferTo(out);
            }
            out.closeEntry();
        }
    }

    private static void writeBytes(JarOutputStream out, Set<String> written, String name, byte[] bytes) throws IOException {
        if (written.add(name)) {
            JarEntry dst = new JarEntry(name);
            out.putNextEntry(dst);
            out.write(bytes);
            out.closeEntry();
        }
    }

    private static byte[] readAll(JarFile in, JarEntry entry) throws IOException {
        try (InputStream is = in.getInputStream(entry);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream(Math.max(8192, Math.toIntExact(entry.getSize() > 0L ? entry.getSize() : 0L)));
            is.transferTo(baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private static byte[] transformClass(byte[] original, Remapper remapper) {
        ClassReader reader = new ClassReader(original);
        ClassWriter writer = new ClassWriter(0);
        ClassRemapper classRemapper = new ClassRemapper((ClassVisitor)writer, remapper);
        reader.accept((ClassVisitor)classRemapper, 0);
        return writer.toByteArray();
    }

    private static boolean isServiceFile(String name) {
        return name.startsWith("META-INF/services/") && !name.endsWith("/");
    }

    private static boolean isManifestFile(String name) {
        return "META-INF/MANIFEST.MF".equalsIgnoreCase(name);
    }

    private static boolean isIndexList(String name) {
        return "META-INF/INDEX.LIST".equalsIgnoreCase(name);
    }

    private static boolean isSignatureFile(String name) {
        String lower = name.toLowerCase();
        return lower.startsWith("meta-inf/") && (lower.endsWith(".sf") || lower.endsWith(".dsa") || lower.endsWith(".rsa") || lower.endsWith(".ec") || lower.endsWith(".p7s"));
    }

    private static String relocateResourcePath(String path, Map<String, String> mappings) {
        Object bestFrom = null;
        String bestTo = null;
        int bestLen = -1;
        for (Map.Entry<String, String> e : mappings.entrySet()) {
            String fromPath = e.getKey().replace('.', '/') + "/";
            if (!path.startsWith(fromPath) || fromPath.length() <= bestLen) continue;
            bestFrom = fromPath;
            bestTo = e.getValue().replace('.', '/') + "/";
            bestLen = fromPath.length();
        }
        if (bestFrom != null) {
            return bestTo + path.substring(((String)bestFrom).length());
        }
        return path;
    }

    private static byte[] rewriteServiceFile(byte[] original, Map<String, String> mappings) throws IOException {
        String content = new String(original, StandardCharsets.UTF_8);
        String[] lines = content.split("\\R", -1);
        StringBuilder out = new StringBuilder(content.length() + 64);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int hash = line.indexOf(35);
            String comment = hash >= 0 ? line.substring(hash) : null;
            Object body = hash >= 0 ? line.substring(0, hash) : line;
            String trimmed = ((String)body).trim();
            if (!trimmed.isEmpty()) {
                String relocated = PackageRemapper.applyDotRelocations(trimmed, mappings);
                int leading = ((String)body).indexOf(trimmed);
                String leadingWs = leading >= 0 ? ((String)body).substring(0, leading) : "";
                body = leadingWs + relocated;
            }
            out.append((String)body);
            if (comment != null) {
                out.append(comment);
            }
            if (i >= lines.length - 1) continue;
            out.append('\n');
        }
        return out.toString().getBytes(StandardCharsets.UTF_8);
    }

    private static String applyDotRelocations(String fqcn, Map<String, String> mappings) {
        String bestFrom = null;
        String bestTo = null;
        int bestLen = -1;
        for (Map.Entry<String, String> e : mappings.entrySet()) {
            String from = e.getKey();
            if (!fqcn.equals(from) && !fqcn.startsWith(from + ".") || from.length() <= bestLen) continue;
            bestFrom = from;
            bestTo = e.getValue();
            bestLen = from.length();
        }
        if (bestFrom != null) {
            return bestTo + fqcn.substring(bestFrom.length());
        }
        return fqcn;
    }

    private static String normalizePackage(String pkg) {
        if (pkg == null) {
            return "";
        }
        return pkg.trim().replaceAll("\\.$", "");
    }

    private static final class PrefixRelocationRemapper
    extends Remapper {
        private final Map<String, String> prefixMapInternal = new LinkedHashMap<String, String>();

        PrefixRelocationRemapper(Map<String, String> mappings) {
            mappings.entrySet().stream().sorted(Comparator.comparingInt(e -> -((String)e.getKey()).length())).forEach(e -> this.prefixMapInternal.put(((String)e.getKey()).replace('.', '/'), ((String)e.getValue()).replace('.', '/')));
        }

        public String map(String internalName) {
            if (internalName == null) {
                return null;
            }
            if (internalName.startsWith("[")) {
                return super.map(internalName);
            }
            return this.relocateInternal(internalName);
        }

        public String mapPackageName(String name) {
            if (name == null) {
                return null;
            }
            String internal = name.replace('.', '/');
            String mapped = this.relocateInternal(internal);
            return mapped.replace('/', '.');
        }

        private String relocateInternal(String internal) {
            for (Map.Entry<String, String> e : this.prefixMapInternal.entrySet()) {
                String from = e.getKey();
                if (!internal.equals(from) && !internal.startsWith(from + "/")) continue;
                return e.getValue() + internal.substring(from.length());
            }
            return internal;
        }
    }
}

