/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.dependency.module;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import sun.reflect.ReflectionFactory;

public class Deencapsulation {
    private static final Logger LOGGER = Logger.getLogger(Deencapsulation.class.getName());
    private static final int JAVA_VERSION = Deencapsulation.determineJavaVersion();
    private static final Map<Module, Set<String>> openedPackages = new HashMap<Module, Set<String>>();

    private Deencapsulation() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static void deencapsulate(@NotNull Class<?> anchorClass) {
        if (JAVA_VERSION < 9) {
            LOGGER.fine("Java version < 9, module deencapsulation not required");
            return;
        }
        try {
            Deencapsulation.performDeencapsulation(anchorClass);
            LOGGER.fine("Module deencapsulation completed successfully");
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Module deencapsulation failed", exception);
        }
    }

    @NotNull
    public static MethodHandles.Lookup createPrivilegedLookup(@NotNull Class<?> lookupClass) {
        try {
            Constructor<?> lookupConstructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(MethodHandles.Lookup.class, MethodHandles.Lookup.class.getDeclaredConstructor(Class.class));
            return (MethodHandles.Lookup)lookupConstructor.newInstance(lookupClass);
        }
        catch (ReflectiveOperationException exception) {
            ReflectiveOperationException cause = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException() : exception;
            throw new IllegalStateException("Failed to create privileged lookup", cause);
        }
    }

    public static void closeOpenedPackages() {
        if (JAVA_VERSION < 9) {
            return;
        }
        try {
            MethodHandle closePackageMethod = Deencapsulation.createPrivilegedLookup(Module.class).findVirtual(Module.class, "implRemoveOpens", MethodType.methodType(Void.TYPE, String.class));
            for (Map.Entry<Module, Set<String>> moduleEntry : openedPackages.entrySet()) {
                Module module = moduleEntry.getKey();
                for (String packageName : moduleEntry.getValue()) {
                    try {
                        closePackageMethod.invokeExact(module, packageName);
                    }
                    catch (Throwable throwable) {
                        LOGGER.finest("Failed to close package: " + packageName);
                    }
                }
            }
            openedPackages.clear();
            LOGGER.fine("Closed all opened packages");
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.WARNING, "Failed to close opened packages", throwable);
        }
    }

    private static void performDeencapsulation(@NotNull Class<?> anchorClass) {
        Set<Module> relevantModules = Deencapsulation.collectRelevantModules(anchorClass);
        try {
            MethodHandle openPackageMethod = Deencapsulation.createPrivilegedLookup(Module.class).findVirtual(Module.class, "implAddOpens", MethodType.methodType(Void.TYPE, String.class));
            for (Module module : relevantModules) {
                Deencapsulation.openModulePackages(module, openPackageMethod);
            }
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Failed to perform deencapsulation", throwable);
        }
    }

    @NotNull
    private static Set<Module> collectRelevantModules(@NotNull Class<?> anchorClass) {
        HashSet<Module> modules = new HashSet<Module>();
        Module anchorModule = anchorClass.getModule();
        ModuleLayer anchorModuleLayer = anchorModule.getLayer();
        if (anchorModuleLayer != null) {
            modules.addAll(anchorModuleLayer.modules());
        }
        modules.addAll(ModuleLayer.boot().modules());
        for (ClassLoader classLoader = anchorClass.getClassLoader(); classLoader != null; classLoader = classLoader.getParent()) {
            modules.add(classLoader.getUnnamedModule());
        }
        return modules;
    }

    private static void openModulePackages(@NotNull Module module, @NotNull MethodHandle openPackageMethod) throws Throwable {
        Set moduleOpenedPackages = openedPackages.computeIfAbsent(module, k -> new HashSet());
        for (String packageName : module.getPackages()) {
            if (!moduleOpenedPackages.add(packageName)) continue;
            try {
                openPackageMethod.invokeExact(module, packageName);
                LOGGER.finest("Opened package: " + packageName + " in module: " + module.getName());
            }
            catch (Throwable throwable) {
                LOGGER.finest("Could not open package: " + packageName);
            }
        }
    }

    private static int determineJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            return Integer.parseInt(version.substring(2, 3));
        }
        int dotIndex = version.indexOf(46);
        if (dotIndex != -1) {
            return Integer.parseInt(version.substring(0, dotIndex));
        }
        return Integer.parseInt(version);
    }
}

