/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.dependency.model;

import de.jexcellence.dependency.model.DependencyCoordinate;
import de.jexcellence.dependency.model.DownloadResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ProcessingResult {
    private final List<DependencyCoordinate> successful;
    private final List<DownloadResult> failed;
    private final long processingTimeMillis;

    public ProcessingResult(@NotNull List<DependencyCoordinate> successful, @NotNull List<DownloadResult> failed, long processingTimeMillis) {
        this.successful = new ArrayList<DependencyCoordinate>(successful);
        this.failed = new ArrayList<DownloadResult>(failed);
        this.processingTimeMillis = processingTimeMillis;
    }

    @NotNull
    public List<DependencyCoordinate> getSuccessful() {
        return Collections.unmodifiableList(this.successful);
    }

    @NotNull
    public List<DownloadResult> getFailed() {
        return Collections.unmodifiableList(this.failed);
    }

    public long getProcessingTimeMillis() {
        return this.processingTimeMillis;
    }

    public int getTotalCount() {
        return this.successful.size() + this.failed.size();
    }

    public int getSuccessCount() {
        return this.successful.size();
    }

    public int getFailureCount() {
        return this.failed.size();
    }

    public boolean hasFailures() {
        return !this.failed.isEmpty();
    }

    public boolean isFullySuccessful() {
        return this.failed.isEmpty() && !this.successful.isEmpty();
    }
}

