/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.dependency.model;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record DependencyCoordinate(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier) {
    public DependencyCoordinate(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier) {
        Objects.requireNonNull(groupId, "groupId cannot be null");
        Objects.requireNonNull(artifactId, "artifactId cannot be null");
        Objects.requireNonNull(version, "version cannot be null");
    }

    public DependencyCoordinate(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        this(Objects.requireNonNull(groupId, "groupId cannot be null"), Objects.requireNonNull(artifactId, "artifactId cannot be null"), Objects.requireNonNull(version, "version cannot be null"), null);
    }

    @NotNull
    public String toGavString() {
        StringBuilder builder = new StringBuilder().append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
        if (this.classifier != null && !this.classifier.isEmpty()) {
            builder.append(':').append(this.classifier);
        }
        return builder.toString();
    }

    @NotNull
    public String toFileName() {
        StringBuilder builder = new StringBuilder().append(this.artifactId).append('-').append(this.version);
        if (this.classifier != null && !this.classifier.isEmpty()) {
            builder.append('-').append(this.classifier);
        }
        return builder.append(".jar").toString();
    }

    @NotNull
    public String toRepositoryPath() {
        return this.groupId.replace('.', '/') + "/" + this.artifactId + "/" + this.version + "/" + this.toFileName();
    }

    @Nullable
    public static DependencyCoordinate parse(@NotNull String gavCoordinates) {
        Objects.requireNonNull(gavCoordinates, "GAV coordinates cannot be null");
        String[] parts = gavCoordinates.split(":");
        if (parts.length < 3) {
            return null;
        }
        String classifier = parts.length > 3 ? parts[3] : null;
        return new DependencyCoordinate(parts[0], parts[1], parts[2], classifier);
    }
}

