/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.dependency.model;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Dependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier, @Nullable String repository) {
    public Dependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version, @Nullable String classifier, @Nullable String repository) {
        Objects.requireNonNull(groupId, "groupId cannot be null");
        Objects.requireNonNull(artifactId, "artifactId cannot be null");
        Objects.requireNonNull(version, "version cannot be null");
    }

    public Dependency(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        this(groupId, artifactId, version, null, null);
    }

    @NotNull
    public String toFileName() {
        StringBuilder builder = new StringBuilder().append(this.artifactId).append('-').append(this.version);
        if (this.classifier != null && !this.classifier.isEmpty()) {
            builder.append('-').append(this.classifier);
        }
        return builder.append(".jar").toString();
    }

    @NotNull
    public String toRepositoryPath() {
        return this.groupId.replace('.', '/') + "/" + this.artifactId + "/" + this.version + "/" + this.toFileName();
    }

    @NotNull
    public String toGavString() {
        StringBuilder builder = new StringBuilder().append(this.groupId).append(':').append(this.artifactId).append(':').append(this.version);
        if (this.classifier != null && !this.classifier.isEmpty()) {
            builder.append(':').append(this.classifier);
        }
        return builder.toString();
    }

    @NotNull
    public static Dependency parse(@NotNull String dependencyString) {
        Objects.requireNonNull(dependencyString, "dependencyString cannot be null");
        String[] parts = dependencyString.split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Invalid dependency format: " + dependencyString);
        }
        String classifier = parts.length > 3 ? parts[3] : null;
        return new Dependency(parts[0], parts[1], parts[2], classifier, null);
    }
}

