/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.dependency.manager;

import de.jexcellence.dependency.downloader.DependencyDownloader;
import de.jexcellence.dependency.injector.ClasspathInjector;
import de.jexcellence.dependency.loader.YamlDependencyLoader;
import de.jexcellence.dependency.model.DependencyCoordinate;
import de.jexcellence.dependency.model.DownloadResult;
import de.jexcellence.dependency.model.ProcessingResult;
import de.jexcellence.dependency.module.Deencapsulation;
import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyManager {
    private static final String LIBRARIES_DIRECTORY = "libraries";
    private final Logger logger;
    private final JavaPlugin plugin;
    private final Class<?> anchorClass;
    private final DependencyDownloader downloader;
    private final ClasspathInjector injector;
    private final YamlDependencyLoader yamlLoader;

    public DependencyManager(@NotNull JavaPlugin plugin, @NotNull Class<?> anchorClass) {
        this.plugin = plugin;
        this.anchorClass = anchorClass;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.downloader = new DependencyDownloader();
        this.injector = new ClasspathInjector();
        this.yamlLoader = new YamlDependencyLoader();
    }

    public void initialize(@Nullable String[] additionalDependencies) {
        this.logger.info("Initializing dependency management for: " + this.plugin.getName());
        long startTime = System.currentTimeMillis();
        File pluginJar = this.determinePluginJarLocation();
        if (pluginJar == null) {
            this.logger.severe("Failed to determine plugin JAR location");
            return;
        }
        File librariesDirectory = this.setupLibrariesDirectory();
        ClassLoader targetClassLoader = this.anchorClass.getClassLoader();
        this.performModuleDeencapsulation();
        List<DependencyCoordinate> coordinates = this.collectDependencies(additionalDependencies);
        if (coordinates.isEmpty()) {
            this.logger.info("No dependencies to process");
            return;
        }
        this.logger.info("Processing " + coordinates.size() + " dependencies...");
        ProcessingResult result = this.processDependencies(coordinates, librariesDirectory, targetClassLoader);
        long duration = System.currentTimeMillis() - startTime;
        this.logProcessingSummary(result, librariesDirectory, duration);
        this.logger.info("Dependency management initialization completed in " + duration + "ms");
    }

    @NotNull
    public CompletableFuture<ProcessingResult> initializeAsync(@Nullable String[] additionalDependencies) {
        return CompletableFuture.supplyAsync(() -> {
            long startTime = System.currentTimeMillis();
            File librariesDirectory = this.setupLibrariesDirectory();
            ClassLoader targetClassLoader = this.anchorClass.getClassLoader();
            this.performModuleDeencapsulation();
            List<DependencyCoordinate> coordinates = this.collectDependencies(additionalDependencies);
            if (coordinates.isEmpty()) {
                return new ProcessingResult(List.of(), List.of(), 0L);
            }
            List<CompletableFuture> downloadFutures = coordinates.stream().map(coord -> this.downloader.downloadAsync((DependencyCoordinate)coord, librariesDirectory)).toList();
            List<DownloadResult> downloadResults = downloadFutures.stream().map(CompletableFuture::join).toList();
            ArrayList<DependencyCoordinate> successful = new ArrayList<DependencyCoordinate>();
            ArrayList<DownloadResult> failed = new ArrayList<DownloadResult>();
            for (DownloadResult result : downloadResults) {
                if (result.success() && result.file() != null) {
                    if (this.injector.tryInject(targetClassLoader, result.file())) {
                        successful.add(result.coordinate());
                        continue;
                    }
                    failed.add(result);
                    continue;
                }
                failed.add(result);
            }
            long duration = System.currentTimeMillis() - startTime;
            return new ProcessingResult(successful, failed, duration);
        });
    }

    @Nullable
    private File determinePluginJarLocation() {
        try {
            CodeSource codeSource = this.anchorClass.getProtectionDomain().getCodeSource();
            if (codeSource == null) {
                return null;
            }
            URL location = codeSource.getLocation();
            return new File(location.toURI());
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Failed to determine plugin JAR location", exception);
            return null;
        }
    }

    @NotNull
    private File setupLibrariesDirectory() {
        File librariesDir;
        File dataFolder = this.plugin.getDataFolder();
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        if (!(librariesDir = new File(dataFolder, LIBRARIES_DIRECTORY)).exists()) {
            librariesDir.mkdirs();
        }
        return librariesDir;
    }

    private void performModuleDeencapsulation() {
        try {
            Deencapsulation.deencapsulate(this.anchorClass);
            this.logger.fine("Module deencapsulation completed");
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Module deencapsulation failed", exception);
        }
    }

    @NotNull
    private List<DependencyCoordinate> collectDependencies(@Nullable String[] additionalDependencies) {
        ArrayList<DependencyCoordinate> coordinates = new ArrayList<DependencyCoordinate>();
        List<String> yamlDependencies = this.yamlLoader.loadDependencies(this.anchorClass);
        if (yamlDependencies != null) {
            for (String dependency : yamlDependencies) {
                DependencyCoordinate coordinate = DependencyCoordinate.parse(dependency);
                if (coordinate != null) {
                    coordinates.add(coordinate);
                    this.logger.fine("YAML dependency: " + dependency);
                    continue;
                }
                this.logger.warning("Invalid dependency format: " + dependency);
            }
        }
        if (additionalDependencies != null) {
            this.logger.info("Adding " + additionalDependencies.length + " additional dependencies");
            for (String dependency : additionalDependencies) {
                DependencyCoordinate coordinate = DependencyCoordinate.parse(dependency);
                if (coordinate != null) {
                    coordinates.add(coordinate);
                    this.logger.fine("Additional dependency: " + dependency);
                    continue;
                }
                this.logger.warning("Invalid dependency format: " + dependency);
            }
        }
        return coordinates;
    }

    @NotNull
    private ProcessingResult processDependencies(@NotNull List<DependencyCoordinate> coordinates, @NotNull File librariesDirectory, @NotNull ClassLoader classLoader) {
        long startTime = System.currentTimeMillis();
        ArrayList<DependencyCoordinate> successful = new ArrayList<DependencyCoordinate>();
        ArrayList<DownloadResult> failed = new ArrayList<DownloadResult>();
        for (DependencyCoordinate coordinate : coordinates) {
            DownloadResult result = this.downloader.download(coordinate, librariesDirectory);
            if (result.success() && result.file() != null) {
                if (this.injector.tryInject(classLoader, result.file())) {
                    successful.add(coordinate);
                    continue;
                }
                failed.add(DownloadResult.failure(coordinate, "Injection failed"));
                continue;
            }
            failed.add(result);
        }
        long duration = System.currentTimeMillis() - startTime;
        return new ProcessingResult(successful, failed, duration);
    }

    private void logProcessingSummary(@NotNull ProcessingResult result, @NotNull File librariesDirectory, long totalDuration) {
        File[] jarFiles;
        this.logger.info("Dependency processing summary:");
        this.logger.info(String.format("  Total: %d | Success: %d | Failed: %d | Time: %dms", result.getTotalCount(), result.getSuccessCount(), result.getFailureCount(), totalDuration));
        if (result.hasFailures()) {
            String failedList = result.getFailed().stream().map(dr -> dr.coordinate().toGavString()).collect(Collectors.joining(", "));
            this.logger.warning("Failed dependencies: " + failedList);
        }
        int totalLibraries = (jarFiles = librariesDirectory.listFiles((dir, name) -> name.endsWith(".jar"))) != null ? jarFiles.length : 0;
        this.logger.info("Libraries directory contains " + totalLibraries + " JAR files");
    }

    public void shutdown() {
        this.downloader.shutdown();
    }
}

