/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.dependency.loader;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlDependencyLoader {
    private static final String LOGGER_NAME = "JExDependency";
    private static final String DEPENDENCIES_YAML_PATH = "/dependency/dependencies.yml";
    private static final String PAPER_DEPENDENCIES_PATH = "/dependency/paper/dependencies.yml";
    private static final String SPIGOT_DEPENDENCIES_PATH = "/dependency/spigot/dependencies.yml";
    private static final String DEPENDENCIES_SECTION = "dependencies:";
    private static final String LIST_PREFIX = "- ";
    private static final String QUOTE = "\"";
    private static final String COMMENT = "#";
    private final Logger logger = Logger.getLogger("JExDependency");
    private final ServerType serverType = this.detectServerType();

    @Nullable
    public List<String> loadDependencies(@NotNull Class<?> anchorClass) {
        List<String> dependencies;
        String serverSpecificPath = this.getServerSpecificPath();
        if (serverSpecificPath != null && (dependencies = this.loadFromPath(anchorClass, serverSpecificPath)) != null) {
            this.logger.fine("Loaded " + dependencies.size() + " dependencies from server-specific config");
            return dependencies;
        }
        dependencies = this.loadFromPath(anchorClass, DEPENDENCIES_YAML_PATH);
        if (dependencies != null) {
            this.logger.fine("Loaded " + dependencies.size() + " dependencies from config");
        } else {
            this.logger.fine("No dependency configuration found");
        }
        return dependencies;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public List<String> loadDependenciesFromJar(@NotNull Path jarPath) {
        try (JarFile jarFile = new JarFile(jarPath.toFile());){
            String genericPath;
            List<String> dependencies;
            InputStream inputStream;
            String entryPath;
            JarEntry entry;
            String serverSpecificPath = this.getServerSpecificPath();
            if (serverSpecificPath != null && (entry = jarFile.getJarEntry(entryPath = serverSpecificPath.startsWith("/") ? serverSpecificPath.substring(1) : serverSpecificPath)) != null) {
                inputStream = jarFile.getInputStream(entry);
                try {
                    dependencies = this.parseDependencies(inputStream);
                    if (!dependencies.isEmpty()) {
                        this.logger.fine("Loaded " + dependencies.size() + " dependencies from plugin JAR");
                        List<String> list = dependencies;
                        return list;
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            if ((entry = jarFile.getJarEntry(genericPath = DEPENDENCIES_YAML_PATH.startsWith("/") ? DEPENDENCIES_YAML_PATH.substring(1) : DEPENDENCIES_YAML_PATH)) != null) {
                inputStream = jarFile.getInputStream(entry);
                try {
                    dependencies = this.parseDependencies(inputStream);
                    if (!dependencies.isEmpty()) {
                        this.logger.fine("Loaded " + dependencies.size() + " dependencies from plugin JAR");
                        List<String> list = dependencies;
                        return list;
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            this.logger.fine("No dependency configuration found in plugin JAR");
            List<String> list = null;
            return list;
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Failed to load dependencies from plugin JAR: " + String.valueOf(jarPath), exception);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private List<String> loadFromPath(@NotNull Class<?> anchorClass, @NotNull String path) {
        try (InputStream inputStream = anchorClass.getResourceAsStream(path);){
            if (inputStream == null) {
                this.logger.finest("No configuration found at: " + path);
                List<String> list2 = null;
                return list2;
            }
            List<String> list = this.parseDependencies(inputStream);
            return list;
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Failed to load dependencies from: " + path, exception);
            return null;
        }
    }

    @NotNull
    private List<String> parseDependencies(@NotNull InputStream inputStream) {
        ArrayList<String> dependencies = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            boolean inDependenciesSection = false;
            while ((line = reader.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.equals(DEPENDENCIES_SECTION)) {
                    inDependenciesSection = true;
                    continue;
                }
                if (!inDependenciesSection) continue;
                if (this.isEndOfSection(trimmed)) {
                    break;
                }
                String dependency = this.extractDependency(trimmed);
                if (dependency == null) continue;
                dependencies.add(dependency);
                this.logger.finest("Parsed dependency: " + dependency);
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Error parsing YAML dependencies", exception);
        }
        return dependencies;
    }

    private boolean isEndOfSection(@NotNull String line) {
        return !line.isEmpty() && !line.startsWith(COMMENT) && !line.startsWith(LIST_PREFIX);
    }

    @Nullable
    private String extractDependency(@NotNull String line) {
        if (!line.startsWith(LIST_PREFIX)) {
            return null;
        }
        String content = line.substring(LIST_PREFIX.length()).trim();
        if (content.startsWith(QUOTE) && content.endsWith(QUOTE)) {
            content = content.substring(1, content.length() - 1);
        }
        if (content.isEmpty() || content.startsWith(COMMENT)) {
            return null;
        }
        return content;
    }

    @Nullable
    private String getServerSpecificPath() {
        return switch (this.serverType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> PAPER_DEPENDENCIES_PATH;
            case 1 -> SPIGOT_DEPENDENCIES_PATH;
            case 2 -> null;
        };
    }

    @NotNull
    private ServerType detectServerType() {
        if (this.isPaperServer()) {
            this.logger.fine("Detected Paper server");
            return ServerType.PAPER;
        }
        this.logger.fine("Detected Spigot/CraftBukkit server");
        return ServerType.SPIGOT;
    }

    private boolean isPaperServer() {
        return this.isClassPresent("com.destroystokyo.paper.PaperConfig") || this.isClassPresent("io.papermc.paper.configuration.Configuration");
    }

    private boolean isClassPresent(@NotNull String className) {
        try {
            YamlDependencyLoader.classForName(className);
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    @NotNull
    static Class<?> classForName(@NotNull String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    private static enum ServerType {
        PAPER,
        SPIGOT,
        UNKNOWN;

    }
}

