/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.dependency.loader;

import de.jexcellence.dependency.downloader.DependencyDownloader;
import de.jexcellence.dependency.loader.YamlDependencyLoader;
import de.jexcellence.dependency.model.DependencyCoordinate;
import de.jexcellence.dependency.model.DownloadResult;
import io.papermc.paper.plugin.loader.PluginClasspathBuilder;
import io.papermc.paper.plugin.loader.PluginLoader;
import io.papermc.paper.plugin.loader.library.ClassPathLibrary;
import io.papermc.paper.plugin.loader.library.impl.JarLibrary;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class PaperPluginLoader
implements PluginLoader {
    private static final String LOGGER_NAME = "JExDependency";
    private static final String REMAP_PROPERTY = "jedependency.remap";
    private static final String RELOCATIONS_PROPERTY = "jedependency.relocations";
    private static final String RELOCATIONS_PREFIX_PROPERTY = "jedependency.relocations.prefix";
    private static final String RELOCATIONS_EXCLUDES_PROPERTY = "jedependency.relocations.excludes";
    private static final String PAPER_LOADER_PROPERTY = "paper.plugin.loader.active";
    private static final String REMAPPED_DIRECTORY_NAME = "remapped";
    private static final String LIBRARIES_DIRECTORY_NAME = "libraries";
    private static final long MINIMUM_JAR_SIZE = 1024L;
    private final DependencyDownloader dependencyDownloader;
    private final YamlDependencyLoader yamlDependencyLoader;
    private String pluginName = "Unknown";
    private Logger logger = this.createLogger("JExDependency");

    public PaperPluginLoader() {
        this.dependencyDownloader = new DependencyDownloader();
        this.yamlDependencyLoader = new YamlDependencyLoader();
    }

    private Logger createLogger(String loggerName) {
        Logger log = Logger.getLogger(loggerName);
        log.setUseParentHandlers(false);
        for (Handler handler : log.getHandlers()) {
            log.removeHandler(handler);
        }
        final String currentPluginName = this.pluginName;
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new Formatter(this){

            @Override
            public String format(LogRecord record) {
                return String.format("[%s/%s] %s%n", PaperPluginLoader.LOGGER_NAME, currentPluginName, record.getMessage());
            }
        });
        handler.setLevel(Level.ALL);
        log.addHandler(handler);
        log.setLevel(Level.INFO);
        return log;
    }

    private String extractPluginName(@NotNull Path dataDirectory) {
        try {
            Path fileName = dataDirectory.getFileName();
            if (fileName != null) {
                return fileName.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "Unknown";
    }

    public void classloader(@NotNull PluginClasspathBuilder classpathBuilder) {
        System.setProperty(PAPER_LOADER_PROPERTY, "true");
        Path dataDirectory = classpathBuilder.getContext().getDataDirectory().toAbsolutePath();
        Path pluginSource = classpathBuilder.getContext().getPluginSource();
        Path librariesDirectory = this.determineLibrariesDirectory(dataDirectory);
        Path remappedDirectory = librariesDirectory.resolve(REMAPPED_DIRECTORY_NAME);
        this.pluginName = this.extractPluginName(dataDirectory);
        this.logger = this.createLogger("JExDependency." + this.pluginName);
        try {
            this.logger.info("Loading dependencies...");
            this.ensureDirectoryExists(librariesDirectory);
            this.warnIfNestedLibraries(librariesDirectory);
            this.initializeDependencies(librariesDirectory.toFile(), pluginSource);
            Path effectiveDirectory = this.determineEffectiveDirectory(librariesDirectory, remappedDirectory);
            this.loadJarFilesIntoClasspath(classpathBuilder, effectiveDirectory);
        }
        catch (IOException exception) {
            throw new RuntimeException("Failed to initialize libraries directory: " + String.valueOf(librariesDirectory), exception);
        }
    }

    @NotNull
    private Path determineLibrariesDirectory(@NotNull Path dataDirectory) {
        return dataDirectory.resolve(LIBRARIES_DIRECTORY_NAME);
    }

    private void ensureDirectoryExists(@NotNull Path directory) throws IOException {
        Files.createDirectories(directory, new FileAttribute[0]);
        if (!Files.exists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            throw new IOException("Failed to create or access directory: " + String.valueOf(directory));
        }
    }

    private void warnIfNestedLibraries(@NotNull Path librariesDirectory) {
        Path nested = librariesDirectory.resolve(LIBRARIES_DIRECTORY_NAME);
        if (Files.isDirectory(nested, new LinkOption[0])) {
            this.logger.warning("Detected nested libraries folder - please clean up: " + String.valueOf(nested));
        }
    }

    private void initializeDependencies(@NotNull File librariesDirectory, @NotNull Path pluginSource) {
        try {
            List<String> yamlDependencies = this.yamlDependencyLoader.loadDependenciesFromJar(pluginSource);
            if (yamlDependencies == null || yamlDependencies.isEmpty()) {
                this.logger.fine("No dependencies in plugin JAR, checking loader resources");
                yamlDependencies = this.yamlDependencyLoader.loadDependencies(this.getClass());
            }
            if (yamlDependencies == null || yamlDependencies.isEmpty()) {
                this.logger.info("No dependencies configured");
                return;
            }
            this.logger.info("Found " + yamlDependencies.size() + " dependencies");
            this.processDependencies(yamlDependencies, librariesDirectory);
        }
        catch (Exception exception) {
            this.logger.log(Level.WARNING, "Failed to load dependencies", exception);
        }
    }

    private void processDependencies(@NotNull List<String> dependencies, @NotNull File librariesDirectory) {
        int total = dependencies.size();
        int completed = 0;
        int failed = 0;
        int lastLoggedPercent = 0;
        for (String dependencyString : dependencies) {
            try {
                DependencyCoordinate coordinate = DependencyCoordinate.parse(dependencyString);
                if (coordinate == null) {
                    this.logger.warning("Invalid dependency: " + dependencyString);
                    ++failed;
                    ++completed;
                    continue;
                }
                DownloadResult result = this.dependencyDownloader.download(coordinate, librariesDirectory);
                ++completed;
                if (result.success()) {
                    int percent = completed * 100 / total;
                    if (percent < lastLoggedPercent + 25 && completed != total) continue;
                    this.logger.info("Downloading dependencies... " + completed + "/" + total + " (" + percent + "%)");
                    lastLoggedPercent = percent / 25 * 25;
                    continue;
                }
                ++failed;
                this.logger.warning("Failed to download: " + coordinate.artifactId());
            }
            catch (Exception exception) {
                ++completed;
                ++failed;
                this.logger.log(Level.FINE, "Error downloading dependency: " + dependencyString, exception);
            }
        }
        if (failed > 0) {
            this.logger.warning("Downloaded " + (total - failed) + "/" + total + " dependencies (" + failed + " failed)");
        }
    }

    @NotNull
    private RemapMode getRemapMode() {
        String value = System.getProperty(REMAP_PROPERTY, "auto");
        if (value == null) {
            return RemapMode.AUTO;
        }
        String normalized = value.trim().toLowerCase(Locale.ROOT);
        if ("true".equals(normalized) || "1".equals(normalized) || "yes".equals(normalized) || "on".equals(normalized)) {
            return RemapMode.TRUE;
        }
        if ("false".equals(normalized) || "0".equals(normalized) || "no".equals(normalized) || "off".equals(normalized)) {
            return RemapMode.FALSE;
        }
        return RemapMode.AUTO;
    }

    private boolean isRemapperAvailable() {
        try {
            Class.forName("de.jexcellence.dependency.remapper.RemappingDependencyManager", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    private boolean shouldEnableRemapping() {
        RemapMode mode = this.getRemapMode();
        return switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> false;
            case 2 -> this.isRemapperAvailable();
        };
    }

    @NotNull
    private Path determineEffectiveDirectory(@NotNull Path librariesDirectory, @NotNull Path remappedDirectory) {
        RemapMode mode = this.getRemapMode();
        if (mode == RemapMode.FALSE) {
            this.logger.fine("Remapping disabled via system property: jedependency.remap");
            return librariesDirectory;
        }
        if (!this.isRemapperAvailable()) {
            if (mode == RemapMode.TRUE) {
                this.logger.warning("Remapping requested but the remapper component is not present. Either add the remapper to the plugin classpath or disable remapping with -Djedependency.remap=false");
            } else {
                this.logger.fine("Remapper not present; skipping remapping (mode=auto)");
            }
            return librariesDirectory;
        }
        boolean remappingSuccessful = this.attemptRemapping(librariesDirectory, remappedDirectory);
        if (remappingSuccessful) {
            this.logger.fine("Using remapped libraries from: " + String.valueOf(remappedDirectory));
            return remappedDirectory;
        }
        this.logger.warning("Remapping failed, using original libraries");
        return librariesDirectory;
    }

    private boolean attemptRemapping(@NotNull Path inputDirectory, @NotNull Path outputDirectory) {
        Objects.requireNonNull(inputDirectory, "inputDirectory cannot be null");
        Objects.requireNonNull(outputDirectory, "outputDirectory cannot be null");
        try {
            Files.createDirectories(outputDirectory, new FileAttribute[0]);
        }
        catch (IOException exception) {
            this.logger.log(Level.WARNING, "Failed to create remapped directory: " + String.valueOf(outputDirectory), exception);
            return false;
        }
        List<Path> inputJars = this.collectJarFiles(inputDirectory);
        if (inputJars.isEmpty()) {
            this.logger.fine("No input JARs to remap in: " + String.valueOf(inputDirectory));
            return false;
        }
        Path dataDirectory = inputDirectory.getParent() != null ? inputDirectory.getParent() : inputDirectory;
        Object remappingManager = this.createRemappingManager(dataDirectory);
        if (remappingManager == null) {
            return false;
        }
        int relocationsApplied = this.applyRelocations(remappingManager, inputJars);
        if (relocationsApplied == 0) {
            this.logger.warning("No relocations were applied. Remapping will not change packages.");
        }
        return this.processRemapping(remappingManager, inputJars, outputDirectory);
    }

    @NotNull
    private List<Path> collectJarFiles(@NotNull Path directory) {
        List list;
        block8: {
            Stream<Path> files = Files.list(directory);
            try {
                list = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".jar")).collect(Collectors.toCollection(ArrayList::new));
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    this.logger.log(Level.FINE, "Failed to list JAR files in " + String.valueOf(directory), exception);
                    return List.of();
                }
            }
            files.close();
        }
        return list;
    }

    private Object createRemappingManager(@NotNull Path dataDirectory) {
        try {
            Class<?> managerClass = Class.forName("de.jexcellence.dependency.remapper.RemappingDependencyManager");
            Constructor<?> constructor = managerClass.getConstructor(Path.class);
            return constructor.newInstance(dataDirectory);
        }
        catch (Throwable throwable) {
            this.logger.log(Level.WARNING, "RemappingDependencyManager not available or failed to initialize", throwable);
            return null;
        }
    }

    private int applyRelocations(@NotNull Object remappingManager, @NotNull List<Path> inputJars) {
        int explicitRelocations = this.applyExplicitRelocations(remappingManager);
        if (explicitRelocations > 0) {
            return explicitRelocations;
        }
        int automaticRelocations = this.applyAutomaticRelocations(remappingManager, inputJars);
        if (automaticRelocations > 0) {
            this.logger.fine("Applied " + automaticRelocations + " automatic relocations");
        }
        return automaticRelocations;
    }

    private int applyExplicitRelocations(@NotNull Object remappingManager) {
        String[] pairs;
        String relocationsSpec = System.getProperty(RELOCATIONS_PROPERTY);
        if (relocationsSpec == null || relocationsSpec.trim().isEmpty()) {
            return 0;
        }
        int applied = 0;
        for (String pair : pairs = relocationsSpec.split(",")) {
            String trimmedPair = pair.trim();
            if (trimmedPair.isEmpty()) continue;
            int separatorIndex = trimmedPair.indexOf("=>");
            if (separatorIndex <= 0 || separatorIndex >= trimmedPair.length() - 2) {
                this.logger.warning("Invalid relocation mapping, expected 'from=>to': " + trimmedPair);
                continue;
            }
            String fromPackage = trimmedPair.substring(0, separatorIndex).trim();
            String toPackage = trimmedPair.substring(separatorIndex + 2).trim();
            if (!fromPackage.isEmpty() && !toPackage.isEmpty()) {
                this.invokeRelocate(remappingManager, fromPackage, toPackage);
                ++applied;
                continue;
            }
            this.logger.warning("Ignoring empty relocation mapping: " + trimmedPair);
        }
        return applied;
    }

    private int applyAutomaticRelocations(@NotNull Object remappingManager, @NotNull List<Path> jars) {
        String defaultPrefix = "de.jexcellence.remapped";
        String basePrefix = System.getProperty(RELOCATIONS_PREFIX_PROPERTY, "de.jexcellence.remapped");
        if (basePrefix == null || basePrefix.trim().isEmpty()) {
            basePrefix = "de.jexcellence.remapped";
        }
        basePrefix = basePrefix.trim().replaceAll("\\.$", "");
        Set<String> excludedRoots = this.createExcludedRootsSet();
        HashSet<String> detectedRoots = new HashSet<String>();
        for (Path jar : jars) {
            detectedRoots.addAll(this.detectPackageRoots(jar, excludedRoots));
        }
        int applied = 0;
        for (String root : detectedRoots) {
            String targetPackage = basePrefix + "." + root;
            this.invokeRelocate(remappingManager, root, targetPackage);
            ++applied;
        }
        if (applied > 0) {
            this.logger.fine("Automatic relocation will map " + applied + " root package(s) under '" + basePrefix + "'");
        }
        return applied;
    }

    @NotNull
    private Set<String> createExcludedRootsSet() {
        HashSet<String> excludes = new HashSet<String>(Arrays.asList("java", "javax", "jakarta", "sun", "com.sun", "jdk", "org.w3c", "org.xml", "org.ietf", "org.hibernate", "org.h2", "com.mysql", "org.postgresql", "org.mariadb", "com.microsoft", "com.fasterxml"));
        String excludesProperty = System.getProperty(RELOCATIONS_EXCLUDES_PROPERTY);
        if (excludesProperty != null && !excludesProperty.trim().isEmpty()) {
            Arrays.stream(excludesProperty.split(",")).map(String::trim).filter(s -> !s.isEmpty()).forEach(excludes::add);
        }
        return excludes;
    }

    @NotNull
    private Set<String> detectPackageRoots(@NotNull Path jarPath, @NotNull Set<String> excludedRoots) {
        HashSet<String> roots = new HashSet<String>();
        try (JarFile jarFile = new JarFile(jarPath.toFile());){
            for (JarEntry entry : Collections.list(jarFile.entries())) {
                String packagePath;
                String packageName;
                String rootPackage;
                int lastSlashIndex;
                if (entry.isDirectory() || !entry.getName().endsWith(".class") || entry.getName().endsWith("module-info.class") || (lastSlashIndex = entry.getName().lastIndexOf(47)) <= 0 || this.shouldExcludePackage(rootPackage = this.extractFirstTwoSegments(packageName = (packagePath = entry.getName().substring(0, lastSlashIndex)).replace('/', '.')), excludedRoots)) continue;
                roots.add(rootPackage);
            }
        }
        catch (IOException exception) {
            this.logger.log(Level.FINE, "Failed to scan JAR for package roots: " + String.valueOf(jarPath), exception);
        }
        return roots;
    }

    @NotNull
    private String extractFirstTwoSegments(@NotNull String packageName) {
        int firstDotIndex = packageName.indexOf(46);
        if (firstDotIndex < 0) {
            return packageName;
        }
        int secondDotIndex = packageName.indexOf(46, firstDotIndex + 1);
        if (secondDotIndex < 0) {
            return packageName.substring(0, Math.max(firstDotIndex, packageName.length()));
        }
        return packageName.substring(0, secondDotIndex);
    }

    private boolean shouldExcludePackage(@NotNull String rootPackage, @NotNull Set<String> excludedRoots) {
        if (rootPackage.isEmpty()) {
            return true;
        }
        for (String excluded : excludedRoots) {
            if (!rootPackage.equals(excluded) && !rootPackage.startsWith(excluded + ".")) continue;
            return true;
        }
        return false;
    }

    private void invokeRelocate(@NotNull Object remappingManager, @NotNull String fromPackage, @NotNull String toPackage) {
        try {
            Method method = remappingManager.getClass().getMethod("relocate", String.class, String.class);
            method.invoke(remappingManager, fromPackage, toPackage);
        }
        catch (Exception exception) {
            this.logger.log(Level.FINE, "Failed to invoke relocate method", exception);
        }
    }

    private boolean processRemapping(@NotNull Object remappingManager, @NotNull List<Path> inputJars, @NotNull Path outputDirectory) {
        int total = inputJars.size();
        int processedCount = 0;
        int remappedCount = 0;
        int lastLoggedPercent = 0;
        for (Path inputJar : inputJars) {
            int percent;
            Path outputJar = outputDirectory.resolve(inputJar.getFileName());
            if (this.isRemappedJarUpToDate(outputJar, inputJar)) {
                this.logger.fine("Using cached: " + String.valueOf(outputJar.getFileName()));
                ++processedCount;
                ++remappedCount;
            } else {
                this.deleteExistingFile(outputJar);
                if (this.performRemapping(remappingManager, inputJar, outputJar)) {
                    ++processedCount;
                    if (this.isValidJarFile(outputJar)) {
                        ++remappedCount;
                        this.logger.fine("Remapped: " + String.valueOf(inputJar.getFileName()));
                    } else {
                        this.logger.warning("Failed to remap: " + String.valueOf(inputJar.getFileName()));
                    }
                }
            }
            if ((percent = processedCount * 100 / total) < lastLoggedPercent + 25 && processedCount != total) continue;
            this.logger.info("Remapping libraries... " + processedCount + "/" + total + " (" + percent + "%)");
            lastLoggedPercent = percent / 25 * 25;
        }
        if (processedCount == 0) {
            this.logger.warning("No libraries to remap");
            return false;
        }
        return remappedCount > 0;
    }

    private boolean isRemappedJarUpToDate(@NotNull Path outputJar, @NotNull Path inputJar) {
        try {
            if (!Files.exists(outputJar, new LinkOption[0]) || !Files.isRegularFile(outputJar, new LinkOption[0])) {
                return false;
            }
            FileTime inputTime = Files.getLastModifiedTime(inputJar, new LinkOption[0]);
            FileTime outputTime = Files.getLastModifiedTime(outputJar, new LinkOption[0]);
            long outputSize = Files.size(outputJar);
            return outputSize > 0L && outputTime.compareTo(inputTime) >= 0;
        }
        catch (IOException exception) {
            return false;
        }
    }

    private void deleteExistingFile(@NotNull Path file) {
        try {
            if (Files.exists(file, new LinkOption[0])) {
                Files.delete(file);
            }
        }
        catch (IOException exception) {
            this.logger.log(Level.FINE, "Failed to delete existing file: " + String.valueOf(file), exception);
        }
    }

    private boolean performRemapping(@NotNull Object remappingManager, @NotNull Path inputJar, @NotNull Path outputJar) {
        try {
            Method method = remappingManager.getClass().getMethod("remap", Path.class, Path.class);
            method.invoke(remappingManager, inputJar, outputJar);
            return true;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause() != null ? ite.getCause() : ite;
            this.logger.warning("Failed to remap: " + String.valueOf(inputJar.getFileName()));
            this.logger.log(Level.FINE, "Remap error details for " + String.valueOf(inputJar.getFileName()), cause);
            return false;
        }
        catch (Throwable throwable) {
            this.logger.warning("Failed to remap: " + String.valueOf(inputJar.getFileName()));
            this.logger.log(Level.FINE, "Remap error details for " + String.valueOf(inputJar.getFileName()), throwable);
            return false;
        }
    }

    private boolean isValidJarFile(@NotNull Path file) {
        try {
            return Files.isRegularFile(file, new LinkOption[0]) && Files.size(file) > 1024L && file.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".jar");
        }
        catch (IOException exception) {
            return false;
        }
    }

    private void loadJarFilesIntoClasspath(@NotNull PluginClasspathBuilder classpathBuilder, @NotNull Path librariesDirectory) {
        try (Stream<Path> jarFiles = Files.walk(librariesDirectory, 1, new FileVisitOption[0]);){
            AtomicInteger jarCount = new AtomicInteger(0);
            jarFiles.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().toLowerCase(Locale.ROOT).endsWith(".jar")).forEach(jarPath -> {
                try {
                    classpathBuilder.addLibrary((ClassPathLibrary)new JarLibrary(jarPath));
                    jarCount.incrementAndGet();
                    this.logger.fine("Added: " + String.valueOf(jarPath.getFileName()));
                }
                catch (Exception exception) {
                    this.logger.log(Level.WARNING, "Failed to load: " + String.valueOf(jarPath.getFileName()), exception);
                }
            });
            this.logger.info("Loaded " + jarCount.get() + " libraries");
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "Failed to load libraries", exception);
        }
    }

    private static enum RemapMode {
        TRUE,
        FALSE,
        AUTO;

    }
}

