/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.dependency.injector;

import de.jexcellence.dependency.exception.InjectionException;
import de.jexcellence.dependency.module.Deencapsulation;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class ClasspathInjector {
    private static final String ADD_URL_METHOD_NAME = "addURL";
    private static boolean moduleDeencapsulated = false;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Set<URL> injectedUrls = new HashSet<URL>();

    public void inject(@NotNull ClassLoader classLoader, @NotNull File jarFile) {
        this.validateJarFile(jarFile);
        this.ensureModuleDeencapsulation();
        try {
            URL jarUrl = jarFile.toURI().toURL();
            if (this.isAlreadyInjected(jarUrl)) {
                this.logger.fine("Already injected: " + jarFile.getName());
                return;
            }
            this.performInjection(classLoader, jarUrl);
            this.injectedUrls.add(jarUrl);
            this.logger.fine("Successfully injected: " + jarFile.getName());
        }
        catch (Exception exception) {
            throw new InjectionException("Failed to inject JAR into classpath: " + jarFile.getName(), exception);
        }
    }

    public boolean tryInject(@NotNull ClassLoader classLoader, @NotNull File jarFile) {
        try {
            this.inject(classLoader, jarFile);
            return true;
        }
        catch (InjectionException exception) {
            this.logger.log(Level.WARNING, "Failed to inject: " + jarFile.getName(), exception);
            return false;
        }
    }

    @NotNull
    public Set<URL> getInjectedUrls() {
        return Collections.unmodifiableSet(this.injectedUrls);
    }

    public boolean isClassAvailable(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    private void validateJarFile(@NotNull File jarFile) {
        if (!jarFile.exists()) {
            throw new InjectionException("JAR file does not exist: " + jarFile.getAbsolutePath());
        }
        if (!jarFile.isFile()) {
            throw new InjectionException("Path is not a file: " + jarFile.getAbsolutePath());
        }
        if (!jarFile.canRead()) {
            throw new InjectionException("JAR file is not readable: " + jarFile.getAbsolutePath());
        }
    }

    private void ensureModuleDeencapsulation() {
        if (!moduleDeencapsulated) {
            try {
                Deencapsulation.deencapsulate(this.getClass());
                moduleDeencapsulated = true;
                this.logger.fine("Module deencapsulation completed");
            }
            catch (Exception exception) {
                this.logger.log(Level.WARNING, "Module deencapsulation failed", exception);
            }
        }
    }

    private boolean isAlreadyInjected(@NotNull URL jarUrl) {
        return this.injectedUrls.contains(jarUrl);
    }

    private void performInjection(@NotNull ClassLoader classLoader, @NotNull URL jarUrl) throws Exception {
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            this.injectIntoUrlClassLoader(urlClassLoader, jarUrl);
        } else {
            this.injectUsingReflection(classLoader, jarUrl);
        }
    }

    private void injectIntoUrlClassLoader(@NotNull URLClassLoader classLoader, @NotNull URL jarUrl) throws Exception {
        Method addUrlMethod = URLClassLoader.class.getDeclaredMethod(ADD_URL_METHOD_NAME, URL.class);
        addUrlMethod.setAccessible(true);
        addUrlMethod.invoke((Object)classLoader, jarUrl);
    }

    private void injectUsingReflection(@NotNull ClassLoader classLoader, @NotNull URL jarUrl) throws Exception {
        Method addUrlMethod = classLoader.getClass().getDeclaredMethod(ADD_URL_METHOD_NAME, URL.class);
        addUrlMethod.setAccessible(true);
        addUrlMethod.invoke((Object)classLoader, jarUrl);
    }
}

