/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.dependency.delegate;

import de.jexcellence.dependency.delegate.PluginDelegate;
import java.io.File;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPluginDelegate<T extends JavaPlugin>
implements PluginDelegate<T> {
    private final T plugin;

    protected AbstractPluginDelegate(@NotNull T plugin) {
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public final T getPlugin() {
        return this.plugin;
    }

    @NotNull
    protected Logger getLogger() {
        return this.plugin.getLogger();
    }

    @NotNull
    protected Server getServer() {
        return this.plugin.getServer();
    }

    @NotNull
    protected PluginManager getPluginManager() {
        return this.getServer().getPluginManager();
    }

    @NotNull
    protected File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @NotNull
    protected FileConfiguration getConfig() {
        return this.plugin.getConfig();
    }

    protected void saveConfig() {
        this.plugin.saveConfig();
    }

    protected void saveDefaultConfig() {
        this.plugin.saveDefaultConfig();
    }

    protected void reloadConfig() {
        this.plugin.reloadConfig();
    }

    @NotNull
    protected PluginDescriptionFile getDescription() {
        return this.plugin.getDescription();
    }

    @NotNull
    protected String getName() {
        return this.getDescription().getName();
    }

    @NotNull
    protected String getVersion() {
        return this.getDescription().getVersion();
    }

    @Nullable
    protected PluginCommand getCommand(@NotNull String name) {
        return this.plugin.getCommand(name);
    }
}

