/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.dependency;

import de.jexcellence.dependency.injector.ClasspathInjector;
import de.jexcellence.dependency.manager.DependencyManager;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEDependency {
    private static final String REMAPPING_MANAGER_CLASS = "de.jexcellence.dependency.remapper.RemappingDependencyManager";
    private static final String REMAP_PROPERTY = "jedependency.remap";
    private static final String PAPER_LOADER_PROPERTY = "paper.plugin.loader.active";

    private JEDependency() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static void initialize(@NotNull JavaPlugin plugin, @NotNull Class<?> anchorClass) {
        JEDependency.initialize(plugin, anchorClass, null);
    }

    public static void initialize(@NotNull JavaPlugin plugin, @NotNull Class<?> anchorClass, @Nullable String[] additionalDependencies) {
        JEDependency.performInitialization(plugin, anchorClass, additionalDependencies, false);
    }

    public static void initializeWithRemapping(@NotNull JavaPlugin plugin, @NotNull Class<?> anchorClass) {
        JEDependency.initializeWithRemapping(plugin, anchorClass, null);
    }

    public static void initializeWithRemapping(@NotNull JavaPlugin plugin, @NotNull Class<?> anchorClass, @Nullable String[] additionalDependencies) {
        JEDependency.performInitialization(plugin, anchorClass, additionalDependencies, true);
    }

    @NotNull
    public static CompletableFuture<Void> initializeAsync(@NotNull JavaPlugin plugin, @NotNull Class<?> anchorClass) {
        return JEDependency.initializeAsync(plugin, anchorClass, null);
    }

    @NotNull
    public static CompletableFuture<Void> initializeAsync(@NotNull JavaPlugin plugin, @NotNull Class<?> anchorClass, @Nullable String[] additionalDependencies) {
        return CompletableFuture.runAsync(() -> JEDependency.performInitialization(plugin, anchorClass, additionalDependencies, false));
    }

    @NotNull
    public static String getServerType() {
        if (JEDependency.isPaperPluginLoaderActive()) {
            return "Paper (with plugin loader)";
        }
        if (JEDependency.isPaperServer()) {
            return "Paper (legacy mode)";
        }
        return "Spigot/CraftBukkit";
    }

    public static boolean isPaperServer() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            return true;
        }
        catch (ClassNotFoundException exception) {
            try {
                Class.forName("io.papermc.paper.configuration.Configuration");
                return true;
            }
            catch (ClassNotFoundException exception2) {
                return false;
            }
        }
    }

    private static void performInitialization(@NotNull JavaPlugin plugin, @NotNull Class<?> anchorClass, @Nullable String[] additionalDependencies, boolean forceRemapping) {
        String serverType = JEDependency.getServerType();
        plugin.getLogger().info("JEDependency initializing on " + serverType);
        if (JEDependency.isPaperPluginLoaderActive()) {
            plugin.getLogger().info("Paper plugin loader detected - injecting pre-downloaded libraries, then continuing with full initialization");
            JEDependency.injectPreDownloadedLibraries(plugin, anchorClass);
        }
        JEDependency.logServerSpecificLoading(plugin);
        boolean shouldUseRemapping = forceRemapping || JEDependency.shouldEnableRemapping();
        boolean remappingAvailable = JEDependency.isRemappingManagerAvailable();
        if (shouldUseRemapping && remappingAvailable) {
            String remappingSource = forceRemapping ? "API" : "system property";
            plugin.getLogger().info("Using RemappingDependencyManager (remapping requested via " + remappingSource + ")");
            if (JEDependency.initializeWithRemappingManager(plugin, anchorClass, additionalDependencies)) {
                plugin.getLogger().info("JEDependency initialization completed with remapping");
                return;
            }
            plugin.getLogger().warning("Remapping initialization failed - falling back to standard DependencyManager");
        } else if (shouldUseRemapping) {
            plugin.getLogger().warning("Remapping requested but RemappingDependencyManager not found - falling back to standard DependencyManager");
        }
        DependencyManager dependencyManager = new DependencyManager(plugin, anchorClass);
        dependencyManager.initialize(additionalDependencies);
        plugin.getLogger().info("JEDependency initialization completed");
    }

    private static void injectPreDownloadedLibraries(@NotNull JavaPlugin plugin, @NotNull Class<?> anchorClass) {
        File targetFolder;
        ClasspathInjector injector = new ClasspathInjector();
        File pluginDataFolder = plugin.getDataFolder();
        File remappedLibsFolder = new File(pluginDataFolder, "libraries/remapped");
        File libsFolder = new File(pluginDataFolder, "libraries");
        File file = targetFolder = remappedLibsFolder.exists() && remappedLibsFolder.isDirectory() ? remappedLibsFolder : libsFolder;
        if (!targetFolder.exists() || !targetFolder.isDirectory()) {
            plugin.getLogger().warning("Libraries folder not found: " + String.valueOf(targetFolder));
            return;
        }
        File[] jarFiles = targetFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
        if (jarFiles == null || jarFiles.length == 0) {
            plugin.getLogger().info("No JAR files found in: " + String.valueOf(targetFolder));
            return;
        }
        ClassLoader pluginClassLoader = anchorClass.getClassLoader();
        int injected = 0;
        int failed = 0;
        for (File jarFile : jarFiles) {
            boolean ok = injector.tryInject(pluginClassLoader, jarFile);
            if (ok) {
                ++injected;
                plugin.getLogger().fine("Injected: " + jarFile.getName());
                continue;
            }
            ++failed;
            plugin.getLogger().warning("Failed to inject " + jarFile.getName());
        }
        plugin.getLogger().info("Injected " + injected + " libraries" + (String)(failed > 0 ? " (" + failed + " failed)" : "") + " from " + targetFolder.getName() + " into runtime classloader");
    }

    private static void logServerSpecificLoading(@NotNull JavaPlugin plugin) {
        if (JEDependency.isPaperServer()) {
            plugin.getLogger().info("Server-specific dependency loading: Paper dependencies will be prioritized");
        } else {
            plugin.getLogger().info("Server-specific dependency loading: Spigot dependencies will be prioritized");
        }
    }

    private static boolean shouldEnableRemapping() {
        String propertyValue = System.getProperty(REMAP_PROPERTY);
        if (propertyValue == null) {
            return false;
        }
        String normalizedValue = propertyValue.trim().toLowerCase();
        return "true".equals(normalizedValue) || "1".equals(normalizedValue) || "yes".equals(normalizedValue) || "on".equals(normalizedValue);
    }

    private static boolean isRemappingManagerAvailable() {
        try {
            Class.forName(REMAPPING_MANAGER_CLASS);
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    private static boolean initializeWithRemappingManager(@NotNull JavaPlugin plugin, @NotNull Class<?> anchorClass, @Nullable String[] additionalDependencies) {
        try {
            Class<?> remapperClass = Class.forName(REMAPPING_MANAGER_CLASS);
            Constructor<?> constructor = JEDependency.findSuitableConstructor(remapperClass);
            if (constructor == null) {
                plugin.getLogger().severe("No compatible constructor found in RemappingDependencyManager");
                return false;
            }
            Object manager = JEDependency.createRemappingManagerInstance(constructor, plugin, anchorClass);
            if (manager == null) {
                return false;
            }
            return JEDependency.invokeInitializeMethod(manager, additionalDependencies, plugin, anchorClass);
        }
        catch (Throwable throwable) {
            plugin.getLogger().severe("Failed to initialize RemappingDependencyManager: " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
            return false;
        }
    }

    @Nullable
    private static Constructor<?> findSuitableConstructor(@NotNull Class<?> remapperClass) {
        try {
            return remapperClass.getConstructor(JavaPlugin.class, Class.class);
        }
        catch (NoSuchMethodException exception) {
            try {
                return remapperClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException exception2) {
                return null;
            }
        }
    }

    @Nullable
    private static Object createRemappingManagerInstance(@NotNull Constructor<?> constructor, @NotNull JavaPlugin plugin, @NotNull Class<?> anchorClass) {
        try {
            return constructor.getParameterCount() == 2 ? constructor.newInstance(plugin, anchorClass) : constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean invokeInitializeMethod(@NotNull Object manager, @Nullable String[] additionalDependencies, @NotNull JavaPlugin plugin, @NotNull Class<?> anchorClass) {
        try {
            Method initializeMethod = manager.getClass().getMethod("initialize", String[].class);
            initializeMethod.invoke(manager, new Object[]{additionalDependencies});
            return true;
        }
        catch (NoSuchMethodException exception) {
            return JEDependency.tryAlternativeInitialization(manager, additionalDependencies, anchorClass);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean tryAlternativeInitialization(@NotNull Object manager, @Nullable String[] additionalDependencies, @NotNull Class<?> anchorClass) {
        try {
            Method addDependenciesMethod = null;
            try {
                addDependenciesMethod = manager.getClass().getMethod("addDependencies", String[].class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            Method loadAllMethod = manager.getClass().getMethod("loadAll", ClassLoader.class);
            if (addDependenciesMethod != null && additionalDependencies != null) {
                addDependenciesMethod.invoke(manager, new Object[]{additionalDependencies});
            }
            ClassLoader classLoader = anchorClass.getClassLoader();
            loadAllMethod.invoke(manager, classLoader);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean isPaperPluginLoaderActive() {
        String paperLoaderActive = System.getProperty(PAPER_LOADER_PROPERTY);
        if ("true".equals(paperLoaderActive)) {
            return true;
        }
        try {
            Class.forName("io.papermc.paper.plugin.loader.PluginLoader");
            Class.forName("io.papermc.paper.plugin.bootstrap.PluginBootstrap");
            return "true".equals(paperLoaderActive);
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }
}

