/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.configmapper.sections;

import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public abstract class AConfigSection {
    private final EvaluationEnvironmentBuilder baseEnvironment;
    public final IEvaluationEnvironment builtBaseEnvironment;
    private final Map<Class<?>, DefaultSupplier> fieldDefaultSuppliers = new HashMap();

    public AConfigSection(EvaluationEnvironmentBuilder baseEnvironment) {
        this.baseEnvironment = baseEnvironment;
        this.builtBaseEnvironment = baseEnvironment.build();
    }

    public EvaluationEnvironmentBuilder getBaseEnvironment() {
        return this.baseEnvironment.duplicate();
    }

    @Nullable
    public Class<?> runtimeDecide(String field) {
        return null;
    }

    @Nullable
    public Object defaultFor(Field field) {
        return null;
    }

    public void afterParsing(List<Field> fields) throws Exception {
        for (Field field : fields) {
            DefaultSupplier defaultSupplier;
            if (field.get(this) != null || (defaultSupplier = this.fieldDefaultSuppliers.get(field.getType())) == null || defaultSupplier.fieldExceptions.contains(field.getName())) continue;
            field.set(this, defaultSupplier.supplier.get());
        }
    }

    protected void registerFieldDefault(Class<?> type, Supplier<Object> supplier, String ... fieldExceptions) {
        this.fieldDefaultSuppliers.put(type, new DefaultSupplier(supplier, Arrays.stream(fieldExceptions).collect(Collectors.toSet())));
    }

    private static class DefaultSupplier {
        private final Supplier<Object> supplier;
        private final Set<String> fieldExceptions;

        public DefaultSupplier(Supplier<Object> supplier, Set<String> fieldExceptions) {
            this.supplier = supplier;
            this.fieldExceptions = fieldExceptions;
        }
    }
}

