/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.configmapper.preprocessor;

import de.jexcellence.configmapper.preprocessor.BlankLine;
import de.jexcellence.configmapper.preprocessor.CommentLine;
import de.jexcellence.configmapper.preprocessor.EnvironmentComment;
import de.jexcellence.configmapper.preprocessor.InputConflict;
import de.jexcellence.configmapper.preprocessor.KeyValueLine;
import de.jexcellence.configmapper.preprocessor.PreProcessorInputException;
import de.jexcellence.configmapper.preprocessor.PreProcessorLine;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class PreProcessorInput {
    private static final int LINE_BUFFER_SIZE = 1024;
    private final Map<String, KeyValueLine> parsedLineByKey = new HashMap<String, KeyValueLine>();
    private final List<PreProcessorLine> lines = new ArrayList<PreProcessorLine>();

    public Collection<String> getKeys() {
        return Collections.unmodifiableSet(this.parsedLineByKey.keySet());
    }

    @Nullable
    public String getValue(String key) {
        KeyValueLine parsedLine = this.parsedLineByKey.get(key.toLowerCase());
        if (parsedLine == null) {
            return null;
        }
        return parsedLine.value;
    }

    public void load(Reader reader) throws IOException {
        this.parsedLineByKey.clear();
        this.lines.clear();
        char[] lineBuffer = new char[1024];
        int lineBufferIndex = 0;
        int lineCounter = 0;
        boolean readSuccess = true;
        KeyValueLine previousKeyValueLine = null;
        ArrayList<CommentLine> consecutiveComments = new ArrayList<CommentLine>();
        PreProcessorLine previousLine = null;
        while (readSuccess) {
            boolean bl = readSuccess = reader.read(lineBuffer, lineBufferIndex, 1) != -1;
            if (!readSuccess && lineBufferIndex != 0 || lineBuffer[lineBufferIndex] == '\n') {
                PreProcessorLine currentLine;
                String lineContent = new String(lineBuffer, 0, lineBufferIndex);
                if ((currentLine = this.parseLine(lineContent, ++lineCounter, consecutiveComments)) instanceof CommentLine) {
                    CommentLine commentLine = (CommentLine)currentLine;
                    consecutiveComments.add(commentLine);
                } else {
                    if (!(currentLine instanceof KeyValueLine)) {
                        this.lines.addAll(consecutiveComments);
                    }
                    consecutiveComments.clear();
                }
                if (currentLine instanceof KeyValueLine) {
                    KeyValueLine keyValueLine = (KeyValueLine)currentLine;
                    this.lines.add(keyValueLine);
                    this.parsedLineByKey.put(keyValueLine.key.toLowerCase(), keyValueLine);
                    if (previousKeyValueLine != null) {
                        keyValueLine.previous = previousKeyValueLine;
                        previousKeyValueLine.next = keyValueLine;
                    }
                    previousKeyValueLine = keyValueLine;
                    if (previousLine instanceof BlankLine) {
                        keyValueLine.hadBlankBefore = true;
                    }
                } else if (currentLine instanceof BlankLine) {
                    this.lines.add(currentLine);
                    if (previousLine instanceof KeyValueLine) {
                        KeyValueLine keyValueLine = (KeyValueLine)previousLine;
                        keyValueLine.hadBlankAfter = true;
                    }
                }
                previousLine = currentLine;
                lineBufferIndex = 0;
                continue;
            }
            ++lineBufferIndex;
        }
        if (!consecutiveComments.isEmpty()) {
            this.lines.addAll(consecutiveComments);
        }
    }

    private int indexOfWhitespace(String input, int fromIndex, boolean isWhitespace) {
        for (int i = fromIndex; i < input.length(); ++i) {
            if (input.charAt(i) == ' ' != isWhitespace) continue;
            return i;
        }
        return -1;
    }

    private PreProcessorLine parseLine(String line, int lineNumber, List<CommentLine> previousConsecutiveComments) {
        char previousChar;
        char nextChar;
        int keyBegin = this.indexOfWhitespace(line, 0, false);
        if (keyBegin < 0) {
            return new BlankLine(line);
        }
        if (line.charAt(keyBegin) == '#') {
            return new CommentLine(line.substring(0, keyBegin), keyBegin == line.length() - 1 ? "" : line.substring(keyBegin + 1));
        }
        int keyEnd = this.indexOfWhitespace(line, keyBegin + 1, true);
        keyEnd = keyEnd < 0 ? line.length() - 1 : --keyEnd;
        String key = line.substring(keyBegin, keyEnd + 1);
        for (int keyIndex = 0; keyIndex < key.length(); ++keyIndex) {
            char keyChar = key.charAt(keyIndex);
            if (keyChar >= 'A' && keyChar <= 'Z' || keyChar >= '0' && keyChar <= '9' || keyChar == '-') continue;
            throw new PreProcessorInputException(lineNumber, InputConflict.INVALID_KEY_CHARACTERS);
        }
        int valueBegin = this.indexOfWhitespace(line, keyEnd + 1, false);
        if (valueBegin < 0) {
            throw new PreProcessorInputException(lineNumber, InputConflict.BLANK_VALUE);
        }
        int valueEnd = line.length() - 1;
        int valueLength = valueEnd - valueBegin + 1;
        if (valueLength > 1 && line.charAt(valueBegin) == '\\' && ((nextChar = line.charAt(valueBegin + 1)) == ' ' || valueLength > 2 && nextChar == '\\' && line.charAt(valueBegin + 2) == ' ')) {
            ++valueBegin;
        }
        if (valueLength > 1 && line.charAt(valueEnd) == '\\' && ((previousChar = line.charAt(valueEnd - 1)) == ' ' || valueLength > 2 && previousChar == '\\' && line.charAt(valueEnd - 2) == ' ')) {
            --valueEnd;
        }
        String value = line.substring(valueBegin, valueEnd + 1);
        return new KeyValueLine(line, key, value, new ArrayList<CommentLine>(previousConsecutiveComments), lineNumber);
    }

    @Nullable
    private KeyValueLine checkExistenceByWalkingLinks(KeyValueLine line, boolean previous) {
        KeyValueLine currentLine = line;
        while ((currentLine = previous ? currentLine.previous : currentLine.next) != null) {
            if (!this.parsedLineByKey.containsKey(currentLine.key.toLowerCase())) continue;
            return currentLine;
        }
        return null;
    }

    private boolean extendMissingKey(KeyValueLine missingLine) {
        int referenceAfterDistance;
        int referencePriorDistance;
        if (this.parsedLineByKey.containsKey(missingLine.key.toLowerCase())) {
            return false;
        }
        this.parsedLineByKey.put(missingLine.key.toLowerCase(), missingLine);
        KeyValueLine referencePrior = this.checkExistenceByWalkingLinks(missingLine, true);
        KeyValueLine referenceAfter = this.checkExistenceByWalkingLinks(missingLine, false);
        if (referencePrior == null && referenceAfter == null) {
            this.lines.add(new BlankLine(""));
            this.lines.add(missingLine);
            return true;
        }
        KeyValueLine nearestReference = referencePrior == null ? referenceAfter : (referenceAfter == null ? referencePrior : ((referencePriorDistance = Math.abs(missingLine.lineNumberAsRead - referencePrior.lineNumberAsRead)) <= (referenceAfterDistance = Math.abs(missingLine.lineNumberAsRead - referenceAfter.lineNumberAsRead)) ? referencePrior : referenceAfter));
        for (int lineIndex = 0; lineIndex < this.lines.size(); ++lineIndex) {
            PreProcessorLine preProcessorLine = this.lines.get(lineIndex);
            if (!(preProcessorLine instanceof KeyValueLine)) continue;
            KeyValueLine keyValueLine = (KeyValueLine)preProcessorLine;
            if (!keyValueLine.key.equals(nearestReference.key)) continue;
            int addIndex = lineIndex + (nearestReference == referencePrior ? 1 : 0);
            this.lines.add(addIndex, missingLine);
            if (missingLine.hadBlankBefore && (addIndex <= 0 || !(this.lines.get(addIndex - 1) instanceof BlankLine))) {
                this.lines.add(addIndex, new BlankLine(""));
            }
            if (missingLine.hadBlankAfter && (addIndex + 1 >= this.lines.size() || !(this.lines.get(addIndex + 1) instanceof BlankLine))) {
                this.lines.add(addIndex + 1, new BlankLine(""));
            }
            return true;
        }
        throw new IllegalStateException("Could not find a previously located reference-line: " + nearestReference.content);
    }

    @Nullable
    private EnvironmentComment tryParseEnvironmentComment(CommentLine line) {
        int hyphenIndex = line.value.indexOf(45);
        if (hyphenIndex < 0) {
            return null;
        }
        int nameBeginIndex = this.indexOfWhitespace(line.value, hyphenIndex + 1, false);
        if (nameBeginIndex < 0) {
            return null;
        }
        int colonIndex = line.value.indexOf(58, nameBeginIndex + 1);
        if (colonIndex < 0) {
            return null;
        }
        int typeBeginIndex = this.indexOfWhitespace(line.value, colonIndex + 1, false);
        if (typeBeginIndex < 0) {
            return null;
        }
        return new EnvironmentComment(line.value.substring(nameBeginIndex, colonIndex), line.value.substring(typeBeginIndex).stripTrailing(), line);
    }

    private void updateEnvironmentComments(KeyValueLine otherLine) {
        KeyValueLine localLine = this.parsedLineByKey.get(otherLine.key.toLowerCase());
        if (localLine == null) {
            throw new IllegalStateException("Assumed local existence of key=" + otherLine.key);
        }
        LinkedHashSet<EnvironmentComment> otherEnvironmentComments = new LinkedHashSet<EnvironmentComment>();
        for (CommentLine otherComment : otherLine.attachedComments) {
            EnvironmentComment otherEnvironmentComment = this.tryParseEnvironmentComment(otherComment);
            if (otherEnvironmentComment == null) continue;
            otherEnvironmentComments.add(otherEnvironmentComment);
        }
        for (int commentIndex = localLine.attachedComments.size() - 1; commentIndex >= 0; --commentIndex) {
            CommentLine localComment = localLine.attachedComments.get(commentIndex);
            EnvironmentComment localEnvironmentComment = this.tryParseEnvironmentComment(localComment);
            if (localEnvironmentComment == null || otherEnvironmentComments.remove(localEnvironmentComment)) continue;
            localLine.attachedComments.remove(commentIndex);
        }
        for (EnvironmentComment otherEnvironmentComment : otherEnvironmentComments) {
            localLine.attachedComments.add(otherEnvironmentComment.commentLine);
        }
    }

    public int migrateTo(PreProcessorInput other) {
        int extendedKeys = 0;
        for (KeyValueLine otherLine : other.parsedLineByKey.values()) {
            if (this.extendMissingKey(otherLine)) {
                ++extendedKeys;
                continue;
            }
            this.updateEnvironmentComments(otherLine);
        }
        return extendedKeys;
    }

    public void save(Writer writer) throws IOException {
        for (int i = 0; i < this.lines.size(); ++i) {
            PreProcessorLine line = this.lines.get(i);
            if (i != 0) {
                writer.write(10);
            }
            line.append(writer);
        }
    }
}

