/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.configmapper.preprocessor;

import de.jexcellence.configmapper.YamlConfig;
import de.jexcellence.configmapper.preprocessor.PreProcessConflict;
import de.jexcellence.configmapper.preprocessor.PreProcessorException;
import de.jexcellence.configmapper.preprocessor.PreProcessorInput;
import de.jexcellence.gpeee.Tuple;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class PreProcessor {
    private final Field scalarNodeValueField = ScalarNode.class.getDeclaredField("value");

    public PreProcessor() throws Exception {
        this.scalarNodeValueField.setAccessible(true);
    }

    public Tuple<String, Boolean> preProcess(String input, PreProcessorInput substitutions) {
        StringBuilder result = new StringBuilder();
        int contentBegin = -1;
        int substitutionBegin = -1;
        boolean didSubstitute = false;
        for (int i = 0; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            if (currentChar == '@' && i != input.length() - 1 && input.charAt(i + 1) == '{') {
                if (contentBegin >= 0) {
                    result.append(input, contentBegin, i);
                    contentBegin = -1;
                }
                substitutionBegin = i;
                continue;
            }
            if (substitutionBegin >= 0 && currentChar == '}') {
                String substitutionKey;
                String substitution;
                int closingParenthesisIndex;
                String substitutionContent = input.substring(substitutionBegin + 2, i);
                int openingParenthesisIndex = substitutionContent.indexOf(40);
                Map<String, String> temporaryVariables = Map.of();
                if (openingParenthesisIndex >= 0 && (closingParenthesisIndex = substitutionContent.indexOf(41)) > openingParenthesisIndex) {
                    String temporaryVariablesContent = substitutionContent.substring(openingParenthesisIndex + 1, closingParenthesisIndex);
                    temporaryVariables = this.parseTemporaryVariables(temporaryVariablesContent, openingParenthesisIndex + 1);
                    substitutionContent = substitutionContent.substring(0, openingParenthesisIndex).trim();
                }
                if ((substitution = substitutions.getValue(substitutionKey = substitutionContent)) == null) {
                    throw new PreProcessorException(substitutionBegin, PreProcessConflict.VARIABLE_NOT_FOUND);
                }
                result.append(this.renderInterpolations(substitution, temporaryVariables));
                substitutionBegin = -1;
                didSubstitute = true;
                continue;
            }
            if (substitutionBegin >= 0 || contentBegin != -1) continue;
            contentBegin = i;
        }
        if (contentBegin >= 0) {
            result.append(input.substring(contentBegin));
        }
        return new Tuple<String, Boolean>(result.toString(), didSubstitute);
    }

    public Map<String, String> parseTemporaryVariables(String input, int beginIndex) {
        String[] assignments;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String assignment : assignments = input.split(";")) {
            String[] assignmentParts = assignment.split("=", 2);
            if (assignmentParts.length != 2) {
                throw new PreProcessorException(beginIndex, PreProcessConflict.MALFORMED_TEMPORARY_VARIABLE);
            }
            String key = assignmentParts[0].strip().toLowerCase();
            String value = assignmentParts[1].strip();
            if (key.isBlank() || value.isBlank()) {
                throw new PreProcessorException(beginIndex, PreProcessConflict.MALFORMED_TEMPORARY_VARIABLE);
            }
            result.put(key, value);
        }
        return result;
    }

    public void forEachScalarValue(YamlConfig config, ScalarNodeHandler handler) throws Exception {
        this.forEachScalarValue((Node)config.getRootNode(), null, config.getExpressionMarkerSuffix(), handler);
    }

    public void setScalarValue(ScalarNode node, String value) throws Exception {
        this.scalarNodeValueField.set(node, value);
    }

    public void forEachScalarValue(Node valueNode, @Nullable ScalarNode keyNode, String expressionMarkerSuffix, ScalarNodeHandler handler) throws Exception {
        if (valueNode instanceof ScalarNode) {
            ScalarNode scalarNode = (ScalarNode)valueNode;
            if (handler.handle(scalarNode) && keyNode != null && !keyNode.getValue().endsWith(expressionMarkerSuffix)) {
                this.setScalarValue(keyNode, keyNode.getValue() + expressionMarkerSuffix);
            }
            return;
        }
        if (valueNode instanceof MappingNode) {
            MappingNode mappingNode = (MappingNode)valueNode;
            for (NodeTuple entry : mappingNode.getValue()) {
                Node node = entry.getKeyNode();
                if (!(node instanceof ScalarNode)) continue;
                ScalarNode currentKeyNode = (ScalarNode)node;
                this.forEachScalarValue(entry.getValueNode(), currentKeyNode, expressionMarkerSuffix, handler);
            }
            return;
        }
        if (valueNode instanceof SequenceNode) {
            SequenceNode sequenceNode = (SequenceNode)valueNode;
            for (Node entry : sequenceNode.getValue()) {
                this.forEachScalarValue(entry, keyNode, expressionMarkerSuffix, handler);
            }
        }
    }

    private boolean isValidSubstitutionChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_';
    }

    public String renderInterpolations(String input, Map<String, String> temporaryVariables) {
        StringBuilder result = new StringBuilder();
        StringBuilder stringBuffer = new StringBuilder();
        StringBuilder interpolationBuffer = new StringBuilder();
        boolean wasPreviousCharBackslash = false;
        for (int i = 0; i < input.length(); ++i) {
            char currentChar = input.charAt(i);
            boolean isEscaped = wasPreviousCharBackslash;
            boolean bl = wasPreviousCharBackslash = currentChar == '\\';
            if (currentChar == '{') {
                if (isEscaped) {
                    stringBuffer.setLength(stringBuffer.length() - 1);
                } else {
                    interpolationBuffer.append(currentChar);
                    continue;
                }
            }
            if (!interpolationBuffer.isEmpty()) {
                Object substitution;
                String temporaryValue;
                if (currentChar != '}') {
                    if (!this.isValidSubstitutionChar(currentChar)) {
                        stringBuffer.append((CharSequence)interpolationBuffer);
                        stringBuffer.append(currentChar);
                        interpolationBuffer.setLength(0);
                        continue;
                    }
                    interpolationBuffer.append(currentChar);
                    continue;
                }
                if (!stringBuffer.isEmpty()) {
                    if (!result.isEmpty()) {
                        result.append(" & ");
                    }
                    result.append('\"').append((CharSequence)stringBuffer).append('\"').append(" & ");
                    stringBuffer.setLength(0);
                }
                if ((temporaryValue = temporaryVariables.get(((String)(substitution = interpolationBuffer.substring(1))).toLowerCase())) != null) {
                    substitution = "(" + temporaryValue + ")";
                }
                result.append((String)substitution);
                interpolationBuffer.setLength(0);
                continue;
            }
            if (currentChar == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(currentChar);
        }
        if (!interpolationBuffer.isEmpty()) {
            stringBuffer.append((CharSequence)interpolationBuffer);
        }
        if (!stringBuffer.isEmpty()) {
            if (!result.isEmpty()) {
                result.append(" & ");
            }
            result.append('\"').append((CharSequence)stringBuffer).append('\"');
        }
        return result.toString();
    }

    @FunctionalInterface
    public static interface ScalarNodeHandler {
        public boolean handle(ScalarNode var1) throws Exception;
    }
}

