/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.configmapper;

import de.jexcellence.configmapper.FExtensionCandidateHandler;
import de.jexcellence.configmapper.FMappingNodeConsumer;
import de.jexcellence.configmapper.IConfig;
import de.jexcellence.configmapper.MergedNodeTuple;
import de.jexcellence.configmapper.StringUtils;
import de.jexcellence.configmapper.logging.DebugLogSource;
import de.jexcellence.gpeee.IExpressionEvaluator;
import de.jexcellence.gpeee.Tuple;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.comments.CommentLine;
import org.yaml.snakeyaml.comments.CommentType;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class YamlConfig
implements IConfig {
    private static final Yaml YAML;
    private static final DumperOptions DUMPER_OPTIONS;
    @Nullable
    private final IExpressionEvaluator evaluator;
    private final Logger logger;
    @Nullable
    private final String expressionMarkerSuffix;
    private final Map<MappingNode, Map<String, @Nullable NodeTuple>> locateKeyCache;
    private final List<MergedNodeTuple> mergedTuples;
    private MappingNode rootNode;
    private String header;

    public YamlConfig(@Nullable IExpressionEvaluator evaluator, Logger logger, @Nullable String expressionMarkerSuffix) {
        this.evaluator = evaluator;
        this.logger = logger;
        this.expressionMarkerSuffix = expressionMarkerSuffix;
        this.locateKeyCache = new HashMap<MappingNode, Map<String, NodeTuple>>();
        this.mergedTuples = new ArrayList<MergedNodeTuple>();
    }

    @Nullable
    public String getExpressionMarkerSuffix() {
        return this.expressionMarkerSuffix;
    }

    public MappingNode getRootNode() {
        return this.rootNode;
    }

    public String getHeader() {
        return this.header;
    }

    public void clearKeyCache() {
        this.locateKeyCache.clear();
    }

    public void load(Reader reader) {
        Node root;
        Iterator nodes = YAML.composeAll(reader).iterator();
        Object object = root = nodes.hasNext() ? (Node)nodes.next() : this.createNewMappingNode(null);
        if (nodes.hasNext()) {
            throw new IllegalStateException("Encountered multiple nodes");
        }
        if (!(root instanceof MappingNode)) {
            throw new IllegalStateException("The top level of a config has to be a map.");
        }
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "Successfully loaded the YAML root node using the provided reader");
        this.rootNode = (MappingNode)root;
        this.mergedTuples.clear();
        this.extractHeader();
        this.processMergeKeys(this.rootNode);
        this.locateKeyCache.clear();
    }

    private void processMergeKeys(MappingNode node) {
        this.forAllMappingsRecursively(node, (currentContainer, currentKey, currentValue) -> {
            if (currentKey.getTag() == Tag.MERGE) {
                this.mergeNodes(currentContainer, currentValue);
            }
        });
    }

    private void mergeNodes(MappingNode destination, MappingNode source) {
        for (NodeTuple sourceTuple : source.getValue()) {
            Node sourceKey = sourceTuple.getKeyNode();
            Node sourceValue = sourceTuple.getValueNode();
            if (!(sourceKey instanceof ScalarNode)) continue;
            if (sourceKey.getTag() == Tag.MERGE) {
                if (!(sourceValue instanceof MappingNode)) {
                    throw new IllegalStateException("Cannot merge a non-mapping node into another node");
                }
                this.mergeNodes(destination, (MappingNode)sourceValue);
                continue;
            }
            String sourceKeyString = ((ScalarNode)sourceKey).getValue();
            boolean valueAbsent = true;
            List destinationTuples = destination.getValue();
            int destinationTuplesSize = destinationTuples.size();
            for (int i = 0; i < destinationTuplesSize; ++i) {
                String destinationKeyString;
                NodeTuple destinationTuple = (NodeTuple)destinationTuples.get(i);
                Node destinationKey = destinationTuple.getKeyNode();
                Node destinationValue = destinationTuple.getValueNode();
                if (!(destinationKey instanceof ScalarNode) || !sourceKeyString.equals(destinationKeyString = ((ScalarNode)destinationKey).getValue())) continue;
                valueAbsent = false;
                if (!(destinationValue instanceof MappingNode)) {
                    int sourcePointer;
                    int destinationPointer = destinationValue.getStartMark().getPointer();
                    if (destinationPointer >= (sourcePointer = sourceValue.getStartMark().getPointer())) break;
                    destinationTuples.set(i, new NodeTuple(destinationKey, sourceValue));
                    break;
                }
                this.mergeNodes((MappingNode)destinationValue, (MappingNode)sourceValue);
            }
            if (!valueAbsent) continue;
            NodeTuple tuple = new NodeTuple(sourceKey, sourceValue);
            MergedNodeTuple mergedTuple = new MergedNodeTuple(tuple, () -> destinationTuples.add(tuple), () -> destinationTuples.remove(tuple));
            this.mergedTuples.add(mergedTuple);
            mergedTuple.addRoutine.run();
        }
    }

    private void extractHeader() {
        List rootTuples = this.rootNode.getValue();
        if (rootTuples.size() == 0) {
            this.header = "";
            return;
        }
        Node firstKey = ((NodeTuple)rootTuples.get(0)).getKeyNode();
        List firstKeyBlockComments = firstKey.getBlockComments();
        if (firstKeyBlockComments == null) {
            this.header = "";
            return;
        }
        ArrayList untouchedBlockComments = new ArrayList(firstKeyBlockComments);
        StringBuilder headerBuilder = new StringBuilder();
        boolean foundBlankLine = false;
        boolean foundBlockLine = false;
        while (firstKeyBlockComments.size() > 0) {
            CommentLine firstLine = (CommentLine)firstKeyBlockComments.remove(0);
            CommentType type = firstLine.getCommentType();
            String value = firstLine.getValue();
            if (type == CommentType.BLOCK) {
                headerBuilder.append("#").append(value).append('\n');
                foundBlockLine = true;
                continue;
            }
            if (!foundBlockLine || firstLine.getCommentType() != CommentType.BLANK_LINE) break;
            headerBuilder.append('\n');
            foundBlankLine = true;
            break;
        }
        if (!foundBlankLine) {
            firstKey.setBlockComments(untouchedBlockComments);
            headerBuilder.setLength(0);
        }
        this.header = headerBuilder.toString();
    }

    public void save(Writer writer) throws IOException {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "Serializing the YAML root node to the provided writer");
        if (this.rootNode == null || this.rootNode.getValue().size() == 0) {
            writer.write("");
            return;
        }
        writer.write(this.header);
        this.executeWhileMergedTuplesAbsent(() -> YAML.serialize((Node)this.rootNode, writer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWhileMergedTuplesAbsent(Runnable executable) {
        List<MergedNodeTuple> list = this.mergedTuples;
        synchronized (list) {
            Iterator<MergedNodeTuple> mergedTuplesIterator = this.mergedTuples.iterator();
            while (mergedTuplesIterator.hasNext()) {
                MergedNodeTuple mergedTuple = mergedTuplesIterator.next();
                if (mergedTuple.removeRoutine.get().booleanValue()) continue;
                mergedTuplesIterator.remove();
            }
            executable.run();
            for (MergedNodeTuple mergedTuple : this.mergedTuples) {
                mergedTuple.addRoutine.run();
            }
        }
    }

    @Nullable
    private NodeTuple findTupleNodeRecursively(Node node, Predicate<NodeTuple> matchPredicate, Predicate<MappingNode> skipPredicate) {
        block5: {
            block4: {
                if (!(node instanceof MappingNode)) break block4;
                if (skipPredicate.test((MappingNode)node)) {
                    return null;
                }
                for (NodeTuple entry : ((MappingNode)node).getValue()) {
                    if (matchPredicate.test(entry)) {
                        return entry;
                    }
                    NodeTuple result = this.findTupleNodeRecursively(entry.getValueNode(), matchPredicate, skipPredicate);
                    if (result == null) continue;
                    return result;
                }
                break block5;
            }
            if (!(node instanceof SequenceNode)) break block5;
            for (Node entry : ((SequenceNode)node).getValue()) {
                NodeTuple result = this.findTupleNodeRecursively(entry, matchPredicate, skipPredicate);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private boolean isKeyCommentedOut(String key, Node container) {
        NodeTuple nextTuple;
        Mark containerStart;
        Predicate<CommentLine> commentedKeyMatcher = comment -> comment.getValue().trim().startsWith(key + ":");
        if (container instanceof MappingNode) {
            for (NodeTuple containerTuple : ((MappingNode)container).getValue()) {
                if (!containerTuple.getKeyNode().getBlockComments().stream().anyMatch(commentedKeyMatcher)) continue;
                return true;
            }
        }
        if ((containerStart = container.getStartMark()) != null && (nextTuple = this.findTupleNodeRecursively((Node)this.rootNode, currentNode -> {
            Mark otherStart = currentNode.getKeyNode().getStartMark();
            return otherStart.getLine() > containerStart.getLine() && otherStart.getColumn() <= containerStart.getColumn();
        }, currentContainer -> currentContainer == container)) != null && nextTuple.getKeyNode().getBlockComments().stream().anyMatch(commentedKeyMatcher)) {
            return true;
        }
        List endComments = this.rootNode.getEndComments();
        return endComments != null && endComments.stream().anyMatch(commentedKeyMatcher);
    }

    public int extendMissingKeys(YamlConfig other) {
        if (other.rootNode == null) {
            throw new IllegalStateException("Other config has not yet been loaded");
        }
        return this.forEachKeyPathRecursively(other.rootNode, null, (tuple, pathOfTuple, indexOfTuple) -> {
            if (this.exists(pathOfTuple)) {
                return false;
            }
            String key = ((ScalarNode)tuple.getKeyNode()).getValue();
            LocateNodeResult locateResult = this.locateNode(pathOfTuple, true, false);
            MappingNode parentNode = locateResult.getLastContainer();
            if (parentNode != null && this.isKeyCommentedOut(key, (Node)parentNode)) {
                return false;
            }
            MappingNode container = (MappingNode)this.locateContainerNode((String)pathOfTuple, (boolean)true).a;
            List containerTuples = container.getValue();
            if (indexOfTuple >= containerTuples.size()) {
                containerTuples.add(tuple);
                this.invalidateLocateKeyCacheFor(container, key);
                return true;
            }
            containerTuples.add(indexOfTuple, tuple);
            this.invalidateLocateKeyCacheFor(container, key);
            return true;
        });
    }

    private int forEachKeyPathRecursively(MappingNode node, @Nullable String parentPath, FExtensionCandidateHandler handler) {
        int updatedKeys = 0;
        List nodeTuples = node.getValue();
        for (int tupleIndex = 0; tupleIndex < nodeTuples.size(); ++tupleIndex) {
            NodeTuple tuple = (NodeTuple)nodeTuples.get(tupleIndex);
            Node valueNode = tuple.getValueNode();
            Node keyNode = tuple.getKeyNode();
            if (!(keyNode instanceof ScalarNode)) continue;
            String keyString = ((ScalarNode)keyNode).getValue();
            Object keyPath = parentPath != null ? parentPath + "." + keyString : keyString;
            boolean didConsumerUpdate = handler.apply(tuple, (String)keyPath, tupleIndex);
            if (didConsumerUpdate) {
                ++updatedKeys;
            }
            if (didConsumerUpdate || !(valueNode instanceof MappingNode)) continue;
            String nextKeyParentPath = parentPath == null ? keyString : parentPath + "." + keyString;
            updatedKeys += this.forEachKeyPathRecursively((MappingNode)valueNode, nextKeyParentPath, handler);
        }
        return updatedKeys;
    }

    @Override
    @Nullable
    public Object get(@Nullable String path) {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "Object at path=" + path + " has been requested");
        LocateNodeResult target = this.locateNode(path, false, false);
        Object value = target.node == null ? null : this.unwrapNode(target.node, target.markedForExpressions);
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "Returning content of path=" + path + " with value=" + String.valueOf(value));
        return value;
    }

    @Override
    public void set(@Nullable String path, @Nullable Object value) {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "An update of value=" + String.valueOf(value) + " at path=" + path + " has been requested");
        Node wrappedValue = this.wrapValue(value);
        if (path == null) {
            if (!(wrappedValue instanceof MappingNode)) {
                throw new IllegalArgumentException("Cannot exchange the root-node for a non-map node");
            }
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "Swapped out the root node");
            this.rootNode = (MappingNode)wrappedValue;
            this.extractHeader();
            return;
        }
        this.updatePathValue(path, wrappedValue, true);
    }

    @Override
    public void setWithFlatKeys(@Nullable String path, @Nullable Object value) {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "An update of value=" + String.valueOf(value) + " at path=" + path + " with flat keys has been requested");
        Node wrappedValue = this.wrapValue(value, true);
        if (path == null) {
            if (!(wrappedValue instanceof MappingNode)) {
                throw new IllegalArgumentException("Cannot exchange the root-node for a non-map node");
            }
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "Swapped out the root node");
            this.rootNode = (MappingNode)wrappedValue;
            this.extractHeader();
            return;
        }
        this.updatePathValue(path, wrappedValue, true);
    }

    @Override
    public void remove(@Nullable String path) {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "The removal of path=" + path + " has been requested");
        if (path == null) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "Reset the root node");
            this.rootNode = this.createNewMappingNode(null);
            return;
        }
        this.updatePathValue(path, null, false);
    }

    private MappingNode createNewMappingNode(@Nullable List<NodeTuple> items) {
        if (items == null) {
            items = new ArrayList<NodeTuple>();
        }
        return new MappingNode(Tag.MAP, true, items, null, null, DUMPER_OPTIONS.getDefaultFlowStyle());
    }

    @Override
    public boolean exists(@Nullable String path) {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "An existence check of path=" + path + " has been requested");
        boolean exists = this.locateNode((String)path, (boolean)true, (boolean)false).node != null;
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "Returning existence value for path=" + path + " of exists=" + exists);
        return exists;
    }

    @Override
    public void attachComment(@Nullable String path, List<String> lines, boolean self) {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "Attaching a comment to path=" + path + " (self=" + self + ") of lines=" + String.valueOf(lines) + " has been requested");
        Node target = this.locateNode((String)path, (boolean)self, (boolean)false).node;
        if (target == null) {
            throw new IllegalStateException("Cannot attach a comment to a non-existing path");
        }
        ArrayList<CommentLine> comments = new ArrayList<CommentLine>();
        for (String line : lines) {
            CommentType type = StringUtils.isBlank(line) ? CommentType.BLANK_LINE : CommentType.BLOCK;
            comments.add(new CommentLine(null, null, line, type));
        }
        target.setBlockComments(comments);
    }

    @Override
    @Nullable
    public List<String> readComment(@Nullable String path, boolean self) {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "Reading the comment at path=" + path + " (self=" + self + ") has been requested");
        Node target = this.locateNode((String)path, (boolean)self, (boolean)false).node;
        if (target == null) {
            return null;
        }
        ArrayList<String> comments = new ArrayList<String>();
        List targetComments = target.getBlockComments();
        for (CommentLine comment : targetComments) {
            if (comment.getCommentType() == CommentType.BLANK_LINE) {
                comments.add("\n");
                continue;
            }
            comments.add(comment.getValue());
        }
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.YAML) + "Returning comments for path=" + path + " comments=" + String.valueOf(comments));
        return comments;
    }

    private Tuple<MappingNode, String> locateContainerNode(String keyPath, boolean forceCreateMappings) {
        String keyPart;
        MappingNode container;
        int lastDotIndex = keyPath.lastIndexOf(46);
        if (lastDotIndex < 0) {
            container = this.rootNode;
            keyPart = keyPath;
        } else {
            keyPart = keyPath.substring(lastDotIndex + 1);
            container = (MappingNode)this.locateNode((String)keyPath.substring((int)0, (int)lastDotIndex), (boolean)false, (boolean)forceCreateMappings).node;
        }
        if (container == null || StringUtils.isBlank(keyPart)) {
            throw new IllegalArgumentException("Invalid path specified: " + keyPath);
        }
        if (!keyPath.endsWith(keyPart)) {
            throw new IllegalStateException("Could not locate the containing node for path: " + keyPath);
        }
        return new Tuple<MappingNode, String>(container, keyPart);
    }

    private void updatePathValue(String keyPath, @Nullable Node value, boolean forceCreateMappings) {
        Tuple<MappingNode, String> containerAndKeyPart = this.locateContainerNode(keyPath, forceCreateMappings);
        MappingNode container = (MappingNode)containerAndKeyPart.a;
        String keyPart = (String)containerAndKeyPart.b;
        NodeTuple existingTuple = this.locateKey(container, keyPart);
        Node existingKey = null;
        int existingIndex = -1;
        this.invalidateLocateKeyCacheFor(container, keyPart);
        if (existingTuple != null) {
            existingKey = existingTuple.getKeyNode();
            existingIndex = container.getValue().indexOf(existingTuple);
            container.getValue().remove(existingIndex);
            Node valueNode = existingTuple.getValueNode();
            if (valueNode instanceof MappingNode) {
                this.forAllMappingsRecursively((MappingNode)valueNode, (currentContainer, currentKey, currentValue) -> this.invalidateLocateKeyCacheFor(currentValue, currentKey.getValue()));
            }
        }
        if (value != null) {
            NodeTuple newTuple = this.createNewTuple(existingKey, keyPart, value);
            if (existingIndex >= 0) {
                container.getValue().add(existingIndex, newTuple);
            } else {
                container.getValue().add(newTuple);
            }
        }
    }

    private void invalidateLocateKeyCacheFor(MappingNode node, String key) {
        Map<String, @Nullable NodeTuple> containerCache = this.locateKeyCache.get(node);
        if (containerCache != null) {
            containerCache.remove(key);
            if (this.expressionMarkerSuffix != null) {
                if (key.endsWith(this.expressionMarkerSuffix)) {
                    containerCache.remove(key.substring(0, key.length() - 1));
                } else {
                    containerCache.remove(key + this.expressionMarkerSuffix);
                }
            }
        }
    }

    private void forAllMappingsRecursively(MappingNode node, FMappingNodeConsumer consumer) {
        List tupleList = node.getValue();
        for (int currentTupleIndex = 0; currentTupleIndex < tupleList.size(); ++currentTupleIndex) {
            NodeTuple currentTuple = (NodeTuple)tupleList.get(currentTupleIndex);
            Node valueNode = currentTuple.getValueNode();
            Node keyNode = currentTuple.getKeyNode();
            if (!(valueNode instanceof MappingNode) || !(keyNode instanceof ScalarNode)) continue;
            this.forAllMappingsRecursively((MappingNode)valueNode, consumer);
            consumer.accept(node, (ScalarNode)keyNode, (MappingNode)valueNode);
        }
    }

    private NodeTuple createNewTuple(@Nullable Node keyNode, @Nullable String key, Node value) {
        if (keyNode == null) {
            assert (key != null);
            keyNode = new ScalarNode(Tag.STR, key, null, null, DumperOptions.ScalarStyle.PLAIN);
        }
        return new NodeTuple(keyNode, value);
    }

    @NotNull
    private LocateNodeResult locateNode(@Nullable String path, boolean self, boolean forceCreateMappings) {
        if (path == null) {
            return new LocateNodeResult((Node)this.rootNode, false, null);
        }
        if (StringUtils.isBlank(path = path.trim())) {
            throw new IllegalArgumentException("Invalid path specified: " + path);
        }
        MappingNode node = this.rootNode;
        boolean markedForExpressions = false;
        Stack<MappingNode> containerStack = new Stack<MappingNode>();
        int endIndex = path.indexOf(46);
        int beginIndex = 0;
        do {
            String remainingPath;
            NodeTuple quotedKeyTuple;
            boolean markedAlready;
            if (endIndex < 0) {
                endIndex = path.length();
            }
            String pathPart = path.substring(beginIndex, endIndex);
            if (!(node instanceof MappingNode)) {
                return new LocateNodeResult(null, markedForExpressions, containerStack);
            }
            MappingNode mapping = node;
            containerStack.push(mapping);
            NodeTuple keyValueTuple = this.locateKey(mapping, pathPart);
            boolean bl = markedAlready = this.expressionMarkerSuffix != null && pathPart.endsWith(this.expressionMarkerSuffix);
            if (keyValueTuple == null && !markedAlready) {
                keyValueTuple = this.locateKey(mapping, pathPart + this.expressionMarkerSuffix);
                markedAlready = true;
            }
            if (keyValueTuple == null && endIndex < path.length() && (quotedKeyTuple = this.locateQuotedKey(mapping, remainingPath = path.substring(beginIndex))) != null) {
                if (self) {
                    return new LocateNodeResult(quotedKeyTuple.getKeyNode(), markedForExpressions, containerStack);
                }
                return new LocateNodeResult(quotedKeyTuple.getValueNode(), markedForExpressions, containerStack);
            }
            if (keyValueTuple != null && markedAlready) {
                markedForExpressions = true;
            }
            if (forceCreateMappings && (keyValueTuple == null || !(keyValueTuple.getValueNode() instanceof MappingNode))) {
                Node tupleKey = keyValueTuple == null ? null : keyValueTuple.getKeyNode();
                List mappingTuples = mapping.getValue();
                mappingTuples.remove(keyValueTuple);
                keyValueTuple = this.createNewTuple(tupleKey, pathPart, (Node)this.createNewMappingNode(null));
                mappingTuples.add(keyValueTuple);
                this.invalidateLocateKeyCacheFor(mapping, pathPart);
            }
            if (keyValueTuple == null) {
                return new LocateNodeResult(null, markedForExpressions, containerStack);
            }
            node = endIndex == path.length() && self ? keyValueTuple.getKeyNode() : keyValueTuple.getValueNode();
            if (endIndex == path.length()) break;
            beginIndex = endIndex + 1;
            endIndex = path.indexOf(46, beginIndex);
        } while (node != null);
        return new LocateNodeResult((Node)node, markedForExpressions, containerStack);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    private NodeTuple locateKey(MappingNode node, String key) {
        @Nullable Map nodeCache = this.locateKeyCache.computeIfAbsent(node, k -> new HashMap());
        if (nodeCache.containsKey(key)) {
            return (NodeTuple)nodeCache.get(key);
        }
        List entries = node.getValue();
        for (NodeTuple entry : entries) {
            Node keyNode = entry.getKeyNode();
            if (!(keyNode instanceof ScalarNode) || !((ScalarNode)keyNode).getValue().equalsIgnoreCase(key) || entry.getKeyNode().getTag() == Tag.MERGE) continue;
            nodeCache.put(key, entry);
            return entry;
        }
        nodeCache.put(key, null);
        return null;
    }

    @Nullable
    private NodeTuple locateQuotedKey(MappingNode node, String path) {
        List entries = node.getValue();
        for (NodeTuple entry : entries) {
            ScalarNode scalarKey;
            String keyValue;
            Node keyNode = entry.getKeyNode();
            if (!(keyNode instanceof ScalarNode) || !(keyValue = (scalarKey = (ScalarNode)keyNode).getValue()).contains(".") || !keyValue.equalsIgnoreCase(path)) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    private Object unwrapNode(Node node, boolean markedForExpressions) {
        if (node instanceof ScalarNode) {
            return this.unwrapScalarNode((ScalarNode)node, markedForExpressions);
        }
        if (node instanceof SequenceNode) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Node item : ((SequenceNode)node).getValue()) {
                values.add(this.unwrapNode(item, markedForExpressions));
            }
            return values;
        }
        if (node instanceof MappingNode) {
            LinkedHashMap<Object, Object> values = new LinkedHashMap<Object, Object>();
            for (NodeTuple item : ((MappingNode)node).getValue()) {
                boolean isItemMarkedForExpressions = markedForExpressions;
                Object key = this.unwrapNode(item.getKeyNode(), false);
                if (key instanceof String) {
                    String keyS = (String)key;
                    if (this.expressionMarkerSuffix != null && keyS.endsWith(this.expressionMarkerSuffix)) {
                        key = keyS.substring(0, keyS.length() - 1);
                        isItemMarkedForExpressions = true;
                    }
                }
                values.put(key, this.unwrapNode(item.getValueNode(), isItemMarkedForExpressions));
            }
            return values;
        }
        throw new IllegalStateException("Encountered unknown node type >" + node.getType().getName() + "<");
    }

    private Node wrapValue(@Nullable Object value) {
        return this.wrapValue(value, false);
    }

    private Node wrapValue(@Nullable Object value, boolean flatKeys) {
        Node node = this.wrapScalarNode(value);
        if (node != null) {
            return node;
        }
        if (value instanceof Collection) {
            ArrayList<Node> values = new ArrayList<Node>();
            node = new SequenceNode(Tag.SEQ, true, values, null, null, DUMPER_OPTIONS.getDefaultFlowStyle());
            for (Object item : (Collection)value) {
                values.add(this.wrapValue(item, flatKeys));
            }
            return node;
        }
        if (value instanceof Map) {
            ArrayList<NodeTuple> tuples = new ArrayList<NodeTuple>();
            node = this.createNewMappingNode(tuples);
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String keyString = String.valueOf(entry.getKey());
                DumperOptions.ScalarStyle keyStyle = flatKeys && keyString.contains(".") ? DumperOptions.ScalarStyle.DOUBLE_QUOTED : DumperOptions.ScalarStyle.PLAIN;
                ScalarNode keyNode = this.createScalarNode(keyString, Tag.STR, keyStyle);
                tuples.add(new NodeTuple((Node)keyNode, this.wrapValue(entry.getValue(), flatKeys)));
            }
            return node;
        }
        throw new IllegalArgumentException("Cannot store a value of type " + String.valueOf(value.getClass()));
    }

    @Nullable
    private Object unwrapScalarNode(ScalarNode node, boolean markedForExpressions) {
        Tag tag = node.getTag();
        if (tag == Tag.NULL) {
            return null;
        }
        if (this.evaluator != null && markedForExpressions) {
            return this.evaluator.optimizeExpression(this.evaluator.parseString(node.getValue()));
        }
        if (tag == Tag.STR) {
            return node.getValue();
        }
        if (tag == Tag.BOOL) {
            return node.getValue().equalsIgnoreCase("true");
        }
        if (tag == Tag.INT) {
            return Long.parseLong(node.getValue());
        }
        if (tag == Tag.FLOAT) {
            return Double.parseDouble(node.getValue());
        }
        throw new IllegalStateException("Encountered unknown scalar node type >" + String.valueOf(tag) + "<");
    }

    @Nullable
    private Node wrapScalarNode(@Nullable Object value) {
        String stringValue = String.valueOf(value);
        if (value == null) {
            return this.createScalarNode(stringValue, Tag.NULL);
        }
        if (value instanceof Boolean) {
            return this.createScalarNode(stringValue, Tag.BOOL);
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return this.createScalarNode(stringValue, Tag.INT);
        }
        if (value instanceof Double || value instanceof Float) {
            return this.createScalarNode(stringValue, Tag.FLOAT);
        }
        if (value instanceof String) {
            return this.createScalarNode(stringValue, Tag.STR);
        }
        return null;
    }

    private ScalarNode createScalarNode(String value, Tag tag) {
        return new ScalarNode(tag, value, null, null, DumperOptions.ScalarStyle.PLAIN);
    }

    private ScalarNode createScalarNode(String value, Tag tag, DumperOptions.ScalarStyle style) {
        return new ScalarNode(tag, value, null, null, style);
    }

    static {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setProcessComments(true);
        loaderOptions.setAllowDuplicateKeys(true);
        DUMPER_OPTIONS = new DumperOptions();
        DUMPER_OPTIONS.setProcessComments(true);
        DUMPER_OPTIONS.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        DUMPER_OPTIONS.setAnchorGenerator(Node::getAnchor);
        DUMPER_OPTIONS.setSplitLines(false);
        YAML = new Yaml((BaseConstructor)new Constructor(loaderOptions), new Representer(DUMPER_OPTIONS), DUMPER_OPTIONS, loaderOptions);
    }

    private static class LocateNodeResult {
        @Nullable
        private final Node node;
        private final boolean markedForExpressions;
        private final Stack<MappingNode> containerStack;

        private LocateNodeResult(@Nullable Node node, boolean markedForExpressions, Stack<MappingNode> containerStack) {
            this.node = node;
            this.markedForExpressions = markedForExpressions;
            this.containerStack = containerStack;
        }

        @Nullable
        MappingNode getLastContainer() {
            if (this.containerStack.isEmpty()) {
                return null;
            }
            return this.containerStack.pop();
        }
    }
}

