/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.configmapper;

import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class ScalarType<T> {
    public static final ScalarType<Integer> INT = new ScalarType(Integer.TYPE, (i, e) -> (int)e.getValueInterpreter().asLong(i));
    public static final ScalarType<Long> LONG = new ScalarType(Long.TYPE, (i, e) -> e.getValueInterpreter().asLong(i));
    public static final ScalarType<Double> DOUBLE = new ScalarType(Double.TYPE, (i, e) -> e.getValueInterpreter().asDouble(i));
    public static final ScalarType<Boolean> BOOLEAN = new ScalarType(Boolean.TYPE, (i, e) -> e.getValueInterpreter().asBoolean(i));
    public static final ScalarType<String> STRING = new ScalarType(String.class, (i, e) -> e.getValueInterpreter().asString(i));
    public static final ScalarType<Component> COMPONENT = new ScalarType(Component.class, (i, e) -> e.getValueInterpreter().asComponent(i));
    public static final ScalarType<String> STRING_PRESERVE_NULLS = new ScalarType(String.class, (i, e) -> {
        if (i == null) {
            return null;
        }
        return e.getValueInterpreter().asString(i);
    });
    private final Class<?> type;
    private final BiFunction<@Nullable Object, IEvaluationEnvironment, Object> interpreter;
    private static final Map<Class<?>, ScalarType<?>> lookupTable = new HashMap();

    private ScalarType(Class<?> type, BiFunction<@Nullable Object, IEvaluationEnvironment, Object> interpreter) {
        this.type = type;
        this.interpreter = interpreter;
    }

    public Class<?> getType() {
        return this.type;
    }

    public BiFunction<Object, IEvaluationEnvironment, Object> getInterpreter() {
        return this.interpreter;
    }

    @Nullable
    public static ScalarType<?> fromClass(Class<?> c) {
        return lookupTable.get(c);
    }

    static {
        lookupTable.put(Integer.TYPE, INT);
        lookupTable.put(Integer.class, INT);
        lookupTable.put(Long.TYPE, LONG);
        lookupTable.put(Long.class, LONG);
        lookupTable.put(Double.TYPE, DOUBLE);
        lookupTable.put(Double.class, DOUBLE);
        lookupTable.put(Boolean.TYPE, BOOLEAN);
        lookupTable.put(Boolean.class, BOOLEAN);
        lookupTable.put(String.class, STRING);
        lookupTable.put(Component.class, COMPONENT);
    }
}

