/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.configmapper;

import de.jexcellence.configmapper.IEvaluable;
import de.jexcellence.configmapper.ScalarType;
import de.jexcellence.gpeee.IExpressionEvaluator;
import de.jexcellence.gpeee.interpreter.IEvaluationEnvironment;
import de.jexcellence.gpeee.parser.expression.AExpression;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ConfigValue
implements IEvaluable {
    @Nullable
    protected final Object value;
    private final IExpressionEvaluator evaluator;

    public ConfigValue(@Nullable Object value, IExpressionEvaluator evaluator) {
        this.value = value;
        this.evaluator = evaluator;
    }

    @Override
    public <T> T asScalar(ScalarType<T> type, IEvaluationEnvironment env) {
        return (T)this.interpret(this.value, type.getType(), null, env);
    }

    @Override
    public <T> List<T> asList(ScalarType<T> type, IEvaluationEnvironment env) {
        return this.interpret(this.value, List.class, new ScalarType[]{type}, env);
    }

    @Override
    public <T> Set<T> asSet(ScalarType<T> type, IEvaluationEnvironment env) {
        return this.interpret(this.value, Set.class, new ScalarType[]{type}, env);
    }

    @Override
    public Object asRawObject(IEvaluationEnvironment env) {
        if (this.value instanceof AExpression) {
            return this.evaluator.evaluateExpression((AExpression)this.value, env);
        }
        return this.value;
    }

    @Override
    public <T, U> Map<T, U> asMap(ScalarType<T> key, ScalarType<T> value, IEvaluationEnvironment env) {
        return this.interpret(value, Map.class, new ScalarType[]{key, value}, env);
    }

    protected <T> T interpretScalar(@Nullable Object input, ScalarType<T> type, IEvaluationEnvironment env) {
        Class<?> typeClass = type.getType();
        if (typeClass.isInstance(input)) {
            return (T)input;
        }
        if (input instanceof AExpression) {
            AExpression aExpressionInput = (AExpression)input;
            if (this.evaluator != null) {
                input = this.evaluator.evaluateExpression(aExpressionInput, env);
            }
        }
        return (T)type.getInterpreter().apply(input, env);
    }

    private <T> T interpret(@Nullable Object input, Class<T> type, @Nullable ScalarType<T>[] genericTypes, IEvaluationEnvironment env) {
        if (input instanceof AExpression) {
            input = this.evaluator.evaluateExpression((AExpression)input, env);
        }
        if (type == List.class || type == Set.class) {
            if (genericTypes == null || genericTypes.length < 1 || genericTypes[0] == null) {
                throw new IllegalStateException("Cannot require a List without specifying a generic type");
            }
            List items = !(input instanceof Collection) ? Collections.singletonList(this.interpretScalar(input, genericTypes[0], env)) : (List)input;
            AbstractCollection results = type == List.class ? new ArrayList() : new HashSet();
            for (Object item : items) {
                if (item instanceof AExpression) {
                    Object result = this.evaluator.evaluateExpression((AExpression)item, env);
                    if (result instanceof Collection) {
                        for (Object subItem : (Collection)result) {
                            results.add(genericTypes[0].getInterpreter().apply(subItem, env));
                        }
                        continue;
                    }
                    results.add(genericTypes[0].getInterpreter().apply(result, env));
                    continue;
                }
                results.add(this.interpretScalar(item, genericTypes[0], env));
            }
            return (T)results;
        }
        if (type == Map.class) {
            if (genericTypes == null || genericTypes.length < 2 || genericTypes[0] == null || genericTypes[1] == null) {
                throw new IllegalStateException("Cannot require a Map without specifying generic types");
            }
            if (input == null) {
                return (T)new HashMap();
            }
            if (!(input instanceof Map)) {
                throw new IllegalStateException("Cannot transform type " + input.getClass().getName() + " into a map");
            }
            Map items = (Map)input;
            HashMap<T, T> results = new HashMap<T, T>();
            for (Map.Entry entry : items.entrySet()) {
                results.put(this.interpretScalar(entry.getKey(), genericTypes[0], env), this.interpretScalar(entry.getValue(), genericTypes[1], env));
            }
            return (T)results;
        }
        ScalarType<T> scalarType = ScalarType.fromClass(type);
        if (scalarType == null) {
            throw new IllegalStateException("Unknown scalar type provided: " + String.valueOf(type));
        }
        return this.interpretScalar(input, scalarType, env);
    }

    public String toString() {
        return "ConfigValue{value=" + String.valueOf(this.value) + "}";
    }
}

