/*
 * Decompiled with CFR 0.152.
 */
package de.jexcellence.configmapper;

import de.jexcellence.configmapper.ConfigValue;
import de.jexcellence.configmapper.FValueConverter;
import de.jexcellence.configmapper.IConfig;
import de.jexcellence.configmapper.IConfigMapper;
import de.jexcellence.configmapper.IEvaluable;
import de.jexcellence.configmapper.IValueConverterRegistry;
import de.jexcellence.configmapper.MappingError;
import de.jexcellence.configmapper.ScalarType;
import de.jexcellence.configmapper.StringUtils;
import de.jexcellence.configmapper.logging.DebugLogSource;
import de.jexcellence.configmapper.sections.AConfigSection;
import de.jexcellence.configmapper.sections.CSAlways;
import de.jexcellence.configmapper.sections.CSDecide;
import de.jexcellence.configmapper.sections.CSIgnore;
import de.jexcellence.configmapper.sections.CSInlined;
import de.jexcellence.configmapper.sections.FlatKeys;
import de.jexcellence.gpeee.GPEEE;
import de.jexcellence.gpeee.IExpressionEvaluator;
import de.jexcellence.gpeee.Tuple;
import de.jexcellence.gpeee.interpreter.EvaluationEnvironmentBuilder;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ConfigMapper
implements IConfigMapper {
    private final IConfig config;
    private final Logger logger;
    private final IExpressionEvaluator evaluator;
    @Nullable
    private final IValueConverterRegistry converterRegistry;

    public ConfigMapper(IConfig config, Logger logger, IExpressionEvaluator evaluator, @Nullable IValueConverterRegistry converterRegistry) {
        this.config = config;
        this.logger = logger;
        this.evaluator = evaluator;
        this.converterRegistry = converterRegistry;
    }

    @Override
    public IConfig getConfig() {
        return this.config;
    }

    @Override
    public void saveSection(@Nullable String root, AConfigSection section) throws Exception {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "At the entry point of saving section to path=" + root);
        this.saveSectionSub(root, section);
    }

    private void saveSectionSub(@Nullable String root, AConfigSection section) throws Exception {
        Class<?> type = section.getClass();
        Tuple<List<Field>, Iterator<Field>> fields = this.findApplicableFields(type);
        for (Field f : (List)fields.a) {
            String fName = f.getName();
            String path = f.isAnnotationPresent(CSInlined.class) ? root : this.joinPaths(root, fName);
            Object value = f.get(section);
            if (value == null) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Skipping null field=" + fName);
                continue;
            }
            if (value instanceof AConfigSection) {
                this.saveSectionSub(path, (AConfigSection)value);
                continue;
            }
            if (Map.class.isAssignableFrom(f.getType()) && f.isAnnotationPresent(FlatKeys.class)) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Using setWithFlatKeys for field=" + fName + " at path=" + path);
                this.config.setWithFlatKeys(path, value);
                continue;
            }
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Using set for field=" + fName + " at path=" + path);
            this.config.set(path, value);
        }
    }

    @Override
    public <T extends AConfigSection> T mapSection(@Nullable String root, Class<T> type) throws Exception {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "At the entry point of mapping path=" + root + " to type=" + String.valueOf(type));
        return this.mapSectionSub(root, null, type);
    }

    private <T extends AConfigSection> T mapSectionSub(@Nullable String root, @Nullable Map<?, ?> source, Class<T> type) throws Exception {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "At the subroutine of mapping path=" + root + " to type=" + String.valueOf(type) + " using source=" + String.valueOf(source));
        AConfigSection instance = (AConfigSection)this.findStandardConstructor(type).newInstance(this.evaluator.getBaseEnvironment());
        Tuple<List<Field>, Iterator<Field>> fields = this.findApplicableFields(type);
        while (((Iterator)fields.b).hasNext()) {
            Field f = (Field)((Iterator)fields.b).next();
            String fName = f.getName();
            try {
                Object value;
                Class<?> fieldType;
                Class<?> finalFieldType = fieldType = f.getType();
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Processing field=" + fName + " of type=" + String.valueOf(finalFieldType));
                if (fieldType == Object.class || f.isAnnotationPresent(CSDecide.class)) {
                    Class<?> decidedType = instance.runtimeDecide(fName);
                    if (decidedType == null) {
                        throw new MappingError("Requesting plain objects is disallowed");
                    }
                    this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Called runtimeDecide on field=" + fName + ", yielded type=" + String.valueOf(decidedType));
                    fieldType = decidedType;
                }
                FValueConverter converter = null;
                if (this.converterRegistry != null) {
                    Class<?> requiredType = this.converterRegistry.getRequiredTypeFor(fieldType);
                    converter = this.converterRegistry.getConverterFor(fieldType);
                    if (requiredType != null && converter != null) {
                        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Using custom converter for type=" + String.valueOf(finalFieldType));
                        fieldType = requiredType;
                    }
                }
                if ((value = this.resolveFieldValue(root, source, f, fieldType)) == null) {
                    value = instance.defaultFor(f);
                }
                if (value != null && converter != null) {
                    value = converter.apply(value, this.evaluator);
                }
                if (value == null) continue;
                f.set(instance, value);
            }
            catch (MappingError error) {
                IllegalStateException exception = new IllegalStateException(error.getMessage() + " (at path '" + this.joinPaths(root, fName) + "')");
                exception.addSuppressed(error);
                throw exception;
            }
        }
        instance.afterParsing((List)fields.a);
        return (T)instance;
    }

    private Tuple<List<Field>, Iterator<Field>> findApplicableFields(Class<?> type) {
        ArrayList<Field> affectedFields = new ArrayList<Field>();
        for (Class<?> c = type; c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || f.isAnnotationPresent(CSIgnore.class)) continue;
                if (f.getType() == type) {
                    throw new IllegalStateException("Sections cannot use self-referencing fields (" + String.valueOf(type) + ", " + f.getName() + ")");
                }
                f.setAccessible(true);
                affectedFields.add(f);
            }
        }
        Iterator fieldI = affectedFields.stream().sorted((a, b) -> {
            if (a.getType() == Object.class && b.getType() == Object.class) {
                return 0;
            }
            return a.getType() == Object.class ? 1 : -1;
        }).iterator();
        return new Tuple<List<Field>, Iterator<Field>>(affectedFields, fieldI);
    }

    @Nullable
    private Object resolvePath(String path, @Nullable Map<?, ?> source) {
        if (source == null) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "No resolving source provided, looking up in config");
            return this.config.get(path);
        }
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Resolving source provided, walking map");
        int dotIndex = path.indexOf(46);
        while (!path.isEmpty()) {
            String key;
            String string = key = dotIndex < 0 ? path : path.substring(0, dotIndex);
            if (StringUtils.isBlank(key)) {
                throw new MappingError("Cannot resolve a blank key");
            }
            path = dotIndex < 0 ? "" : path.substring(dotIndex + 1);
            dotIndex = path.indexOf(46);
            Object value = source.get(key);
            if (path.isEmpty()) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Walk ended, returning value=" + String.valueOf(value));
                return value;
            }
            if (!(value instanceof Map)) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Path part key=" + key + " wasn't a map, returning null");
                return null;
            }
            source = (Map)value;
        }
        return source;
    }

    @Nullable
    private Object convertType(@Nullable Object input, Class<?> type) throws Exception {
        Class<?> finalType = type;
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Trying to convert a value to type: " + String.valueOf(finalType));
        if (input == null) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Is null, returning null");
            return null;
        }
        FValueConverter converter = null;
        if (this.converterRegistry != null) {
            Class<?> requiredType = this.converterRegistry.getRequiredTypeFor(type);
            converter = this.converterRegistry.getConverterFor(type);
            if (requiredType != null && converter != null) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Using custom converter for type=" + String.valueOf(finalType));
                type = requiredType;
            }
        }
        if (type == Object.class) {
            if (converter != null) {
                input = converter.apply(input, this.evaluator);
            }
            return input;
        }
        if (type.isEnum()) {
            ?[] enumConstants;
            String upperInput = ((Object)input).toString().toUpperCase(Locale.ROOT);
            for (Object enumConstant : enumConstants = type.getEnumConstants()) {
                if (!((Enum)enumConstant).name().equals(upperInput)) continue;
                return enumConstant;
            }
            String existingConstants = Arrays.stream(enumConstants).map(it -> ((Enum)it).name()).collect(Collectors.joining(", "));
            throw new MappingError("Value \"" + String.valueOf(input) + "\" was not one of " + existingConstants);
        }
        if (AConfigSection.class.isAssignableFrom(type)) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Parsing value as config-section");
            if (!(input instanceof Map)) {
                this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Value was null, falling back on empty section");
                input = new HashMap();
            }
            Object value = this.mapSectionSub(null, input, type.asSubclass(AConfigSection.class));
            if (converter != null) {
                value = converter.apply(value, this.evaluator);
            }
            return value;
        }
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Wrapping value in evaluable");
        ConfigValue evaluable = new ConfigValue(input, this.evaluator);
        if (type == IEvaluable.class) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Returning evaluable");
            return evaluable;
        }
        if (type == String.class) {
            return evaluable.asScalar(ScalarType.STRING, GPEEE.EMPTY_ENVIRONMENT);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return evaluable.asScalar(ScalarType.LONG, GPEEE.EMPTY_ENVIRONMENT).intValue();
        }
        if (type == Long.TYPE || type == Long.class) {
            return evaluable.asScalar(ScalarType.LONG, GPEEE.EMPTY_ENVIRONMENT);
        }
        if (type == Double.TYPE || type == Double.class) {
            return evaluable.asScalar(ScalarType.DOUBLE, GPEEE.EMPTY_ENVIRONMENT);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(evaluable.asScalar(ScalarType.DOUBLE, GPEEE.EMPTY_ENVIRONMENT).floatValue());
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return evaluable.asScalar(ScalarType.BOOLEAN, GPEEE.EMPTY_ENVIRONMENT);
        }
        throw new MappingError("Unsupported type specified: " + String.valueOf(type));
    }

    private Object handleResolveMapField(Field f, Object value) throws Exception {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Resolving map field");
        List<Class<?>> genericTypes = this.getGenericTypes(f);
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        if (!(value instanceof Map)) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Not a map, returning empty map");
            return result;
        }
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Mapping values individually");
        for (Map.Entry entry : ((Map)value).entrySet()) {
            Object resultValue;
            Object resultKey;
            try {
                resultKey = this.convertType(entry.getKey(), genericTypes.getFirst());
            }
            catch (MappingError error) {
                throw new MappingError(error.getMessage() + " (at the key of a map)");
            }
            try {
                resultValue = this.convertType(entry.getValue(), genericTypes.get(1));
            }
            catch (MappingError error) {
                throw new MappingError(error.getMessage() + " (at value for key=" + String.valueOf(resultKey) + " of a map)");
            }
            result.put(resultKey, resultValue);
        }
        return result;
    }

    private Object handleResolveListField(Field f, Object value) throws Exception {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Resolving list field");
        List<Class<?>> genericTypes = this.getGenericTypes(f);
        ArrayList<Object> result = new ArrayList<Object>();
        if (!(value instanceof List)) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Not a list, returning empty list");
            return result;
        }
        List list = (List)value;
        for (int i = 0; i < list.size(); ++i) {
            Object itemValue;
            try {
                itemValue = this.convertType(list.get(i), genericTypes.getFirst());
            }
            catch (MappingError error) {
                throw new MappingError(error.getMessage() + " (at index " + i + " of a list)");
            }
            result.add(itemValue);
        }
        return result;
    }

    private Object handleResolveArrayField(Field f, Object value) throws Exception {
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Resolving array field");
        Class<?> arrayType = f.getType().getComponentType();
        if (!(value instanceof List)) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Not a list, returning empty array");
            return Array.newInstance(arrayType, 0);
        }
        List list = (List)value;
        Object array = Array.newInstance(arrayType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object itemValue;
            try {
                itemValue = this.convertType(list.get(i), arrayType);
            }
            catch (MappingError error) {
                throw new MappingError(error.getMessage() + " (at index " + i + " of an array)");
            }
            Array.set(array, i, itemValue);
        }
        return array;
    }

    @Nullable
    private Object resolveFieldValue(@Nullable String root, @Nullable Map<?, ?> source, Field f, Class<?> type) throws Exception {
        String path = f.isAnnotationPresent(CSInlined.class) ? root : this.joinPaths(root, f.getName());
        boolean always = f.isAnnotationPresent(CSAlways.class) || f.getDeclaringClass().isAnnotationPresent(CSAlways.class);
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Resolving value for field=" + f.getName() + " at path=" + path + " using source=" + String.valueOf(source));
        Object value = this.resolvePath(path, source);
        if (!always && value == null) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Returning null for absent path");
            return null;
        }
        if (AConfigSection.class.isAssignableFrom(type)) {
            this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Type is of another section");
            return this.mapSectionSub(path, source, type.asSubclass(AConfigSection.class));
        }
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Resolving path value as plain object");
        if (type == Object.class) {
            return value;
        }
        this.logger.log(Level.FINEST, () -> String.valueOf((Object)DebugLogSource.MAPPER) + "Resolved value=" + String.valueOf(value));
        if (Map.class.isAssignableFrom(type)) {
            return this.handleResolveMapField(f, value);
        }
        if (List.class.isAssignableFrom(type)) {
            return this.handleResolveListField(f, value);
        }
        if (type.isArray()) {
            return this.handleResolveArrayField(f, value);
        }
        return this.convertType(value, type);
    }

    private String joinPaths(@Nullable String a, @Nullable String b) {
        if (a == null || StringUtils.isBlank(a)) {
            return b;
        }
        if (b == null || StringUtils.isBlank(b)) {
            return a;
        }
        if (a.endsWith(".") && b.startsWith(".")) {
            return a + b.substring(1);
        }
        if (a.endsWith(".") || b.startsWith(".")) {
            return a + b;
        }
        return a + "." + b;
    }

    private <T> Constructor<T> findStandardConstructor(Class<T> type) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(EvaluationEnvironmentBuilder.class);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalStateException("The standard-constructor of a config-section has to be public");
            }
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Please specify a standard-constructor taking an EvaluationEnvironmentBuilder on " + String.valueOf(type));
        }
    }

    @Nullable
    private List<Class<?>> getGenericTypes(Field f) {
        Type genericType = f.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type[] types = parameterizedType.getActualTypeArguments();
        ArrayList result = new ArrayList();
        for (Type type : types) {
            result.add(this.unwrapType(type));
        }
        return result;
    }

    private Class<?> unwrapType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.unwrapType(parameterizedType.getRawType());
        }
        throw new MappingError("Cannot unwrap type of class=" + String.valueOf(type.getClass()));
    }
}

