/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.workload;

import com.raindropcentral.rplatform.workload.Workload;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class WorkloadExecutor
implements Runnable {
    private static final double MAX_MILLIS_PER_TICK = 2.5;
    private static final long MAX_NANOS_PER_TICK = 2500000L;
    private final Deque<Workload> workloadQueue;
    private final Object lock = new Object();

    public WorkloadExecutor() {
        this.workloadQueue = new ArrayDeque<Workload>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(@NotNull Workload workload) {
        Object object = this.lock;
        synchronized (object) {
            this.workloadQueue.offer(workload);
        }
    }

    @NotNull
    public CompletableFuture<Void> submitAsync(@NotNull Workload workload) {
        return CompletableFuture.runAsync(() -> {
            this.submit(workload);
            while (!this.isCompleted()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            long stopTime = System.nanoTime() + 2500000L;
            while (System.nanoTime() <= stopTime && !this.workloadQueue.isEmpty()) {
                Workload workload = this.workloadQueue.poll();
                if (workload == null) continue;
                workload.execute();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleted() {
        Object object = this.lock;
        synchronized (object) {
            return this.workloadQueue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.workloadQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.workloadQueue.clear();
        }
    }
}

