/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.workload;

import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface Workload {
    public void execute();

    @NotNull
    public static Workload of(@NotNull Runnable runnable) {
        return runnable::run;
    }

    default public int computeCost() {
        return 1;
    }

    @NotNull
    default public Workload andThen(final @NotNull Workload after) {
        final Workload current = this;
        return new Workload(){

            @Override
            public void execute() {
                current.execute();
                after.execute();
            }

            @Override
            public int computeCost() {
                return current.computeCost() + after.computeCost();
            }
        };
    }
}

