/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.view.anvil;

import com.raindropcentral.rplatform.view.anvil.CustomAnvilInput;
import com.raindropcentral.rplatform.view.anvil.CustomAnvilInputConfig;
import com.raindropcentral.rplatform.view.anvil.CustomAnvilInputNMS;
import de.jexcellence.remapped.me.devnatan.inventoryframework.BukkitViewContainer;
import de.jexcellence.remapped.me.devnatan.inventoryframework.IFViewFrame;
import de.jexcellence.remapped.me.devnatan.inventoryframework.PlatformView;
import de.jexcellence.remapped.me.devnatan.inventoryframework.ViewConfig;
import de.jexcellence.remapped.me.devnatan.inventoryframework.ViewContainer;
import de.jexcellence.remapped.me.devnatan.inventoryframework.ViewFrame;
import de.jexcellence.remapped.me.devnatan.inventoryframework.ViewType;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.CloseContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.IFCloseContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.IFContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.IFOpenContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.IFRenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.IFSlotClickContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.OpenContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.SlotClickContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.feature.Feature;
import de.jexcellence.remapped.me.devnatan.inventoryframework.pipeline.PipelineInterceptor;
import de.jexcellence.remapped.me.devnatan.inventoryframework.pipeline.StandardPipelinePhases;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValue;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateWatcher;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public final class CustomAnvilInputFeature
implements Feature<CustomAnvilInputConfig, Void, ViewFrame> {
    private static final int INGREDIENT_SLOT = 0;
    public static final Feature<CustomAnvilInputConfig, Void, ViewFrame> AnvilInput = new CustomAnvilInputFeature();
    private CustomAnvilInputConfig config;
    private PipelineInterceptor frameInterceptor;
    private static final Method GET_REGISTERED_VIEWS_METHOD;

    private CustomAnvilInputFeature() {
    }

    @NotNull
    public String name() {
        return "Anvil Input";
    }

    @NotNull
    public Void install(ViewFrame framework, UnaryOperator<CustomAnvilInputConfig> configure) {
        CustomAnvilInputConfig defaults;
        CustomAnvilInputConfig base = (defaults = CustomAnvilInput.defaultConfig()).copy();
        CustomAnvilInputConfig overrides = (CustomAnvilInputConfig)configure.apply(base);
        this.config = defaults.merge(overrides == null ? base : overrides);
        this.frameInterceptor = this.createFrameworkInterceptor();
        framework.getPipeline().intercept(IFViewFrame.FRAME_REGISTERED, this.frameInterceptor);
        return null;
    }

    public void uninstall(ViewFrame framework) {
        framework.getPipeline().removeInterceptor(IFViewFrame.FRAME_REGISTERED, this.frameInterceptor);
    }

    private PipelineInterceptor createFrameworkInterceptor() {
        return (pipeline, subject) -> {
            HashMap views;
            try {
                views = new HashMap((Map)GET_REGISTERED_VIEWS_METHOD.invoke(subject, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            for (PlatformView view : views.values()) {
                this.handleOpen(view);
                this.handleClose(view);
                this.handleClick(view);
            }
        };
    }

    private CustomAnvilInput getAnvilInput(IFContext context) {
        if (context.getConfig().getType() != ViewType.ANVIL) {
            return null;
        }
        Optional<ViewConfig.Modifier> optional = context.getConfig().getModifiers().stream().filter(CustomAnvilInput.class::isInstance).findFirst();
        if (!optional.isPresent()) {
            return null;
        }
        return (CustomAnvilInput)optional.get();
    }

    private void updatePhysicalResult(String newText, ViewContainer container) {
        Inventory inventory = ((BukkitViewContainer)container).getInventory();
        ItemStack ingredientItem = Objects.requireNonNull(inventory.getItem(0));
        ItemMeta ingredientMeta = Objects.requireNonNull(ingredientItem.getItemMeta());
        ingredientMeta.setDisplayName(newText);
        ingredientItem.setItemMeta(ingredientMeta);
    }

    private void handleClick(PlatformView view) {
        view.getPipeline().intercept(StandardPipelinePhases.CLICK, (pipeline, subject) -> {
            if (!(subject instanceof IFSlotClickContext)) {
                return;
            }
            SlotClickContext context = (SlotClickContext)subject;
            CustomAnvilInput anvilInput = this.getAnvilInput((IFContext)context);
            if (anvilInput == null) {
                return;
            }
            int resultSlot = context.getContainer().getType().getResultSlots()[0];
            if (context.getClickedSlot() != resultSlot) {
                return;
            }
            ItemStack resultItem = context.getItem();
            if (resultItem == null || resultItem.getType() == Material.AIR) {
                return;
            }
            ItemMeta resultMeta = Objects.requireNonNull(resultItem.getItemMeta());
            String text = resultMeta.getDisplayName();
            Inventory clickedInventory = Objects.requireNonNull(context.getClickOrigin().getClickedInventory(), "Clicked inventory cannot be null");
            ItemStack ingredientItem = Objects.requireNonNull(clickedInventory.getItem(0));
            ItemMeta ingredientMeta = Objects.requireNonNull(ingredientItem.getItemMeta());
            ingredientMeta.setDisplayName(text);
            context.updateState((State)anvilInput, (Object)text);
            ingredientItem.setItemMeta(ingredientMeta);
            if (this.config.isCloseOnSelect()) {
                context.closeForPlayer();
            }
        });
    }

    private void handleOpen(PlatformView view) {
        view.getPipeline().intercept(StandardPipelinePhases.OPEN, (pipeline, subject) -> {
            if (!(subject instanceof IFOpenContext)) {
                return;
            }
            OpenContext context = (OpenContext)subject;
            CustomAnvilInput anvilInput = this.getAnvilInput((IFContext)context);
            if (anvilInput == null) {
                return;
            }
            context.getInternalStateValue((State)anvilInput);
            context.watchState(anvilInput.internalId(), new StateWatcher(){

                public void stateRegistered(@NotNull State<?> state, Object caller) {
                }

                public void stateUnregistered(@NotNull State<?> state, Object caller) {
                }

                public void stateValueGet(@NotNull State<?> state, @NotNull StateValueHost host, @NotNull StateValue internalValue, Object rawValue) {
                }

                public void stateValueSet(@NotNull StateValueHost host, @NotNull StateValue value, Object rawOldValue, Object rawNewValue) {
                    CustomAnvilInputFeature.this.updatePhysicalResult((String)rawNewValue, ((IFRenderContext)host).getContainer());
                }
            });
            String globalInitialInput = this.config.getInitialInput();
            String scopedInitialInput = (String)anvilInput.get((StateValueHost)context);
            Inventory inventory = CustomAnvilInputNMS.open(context.getPlayer(), context.getConfig().getTitle(), scopedInitialInput.isEmpty() ? globalInitialInput : scopedInitialInput);
            BukkitViewContainer container = new BukkitViewContainer(inventory, context.isShared(), ViewType.ANVIL, true);
            context.setContainer((ViewContainer)container);
        });
    }

    private void handleClose(PlatformView view) {
        view.getPipeline().intercept(StandardPipelinePhases.CLOSE, (pipeline, subject) -> {
            if (!(subject instanceof IFCloseContext)) {
                return;
            }
            CloseContext context = (CloseContext)subject;
            CustomAnvilInput anvilInput = this.getAnvilInput((IFContext)context);
            if (anvilInput == null) {
                return;
            }
            BukkitViewContainer container = (BukkitViewContainer)context.getContainer();
            int slot = container.getType().getResultSlots()[0];
            ItemStack item = container.getInventory().getItem(slot);
            if (item == null || item.getType() == Material.AIR) {
                return;
            }
            String input = Objects.requireNonNull(item.getItemMeta()).getDisplayName();
            context.updateState((State)anvilInput, (Object)input);
        });
    }

    static {
        try {
            GET_REGISTERED_VIEWS_METHOD = IFViewFrame.class.getDeclaredMethod("getRegisteredViews", new Class[0]);
            GET_REGISTERED_VIEWS_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Cannot access getRegisteredViews method", e);
        }
    }
}

