/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.view.anvil;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.Contract;

public class CustomAnvilInputConfig {
    private String initialInput = "";
    private boolean closeOnSelect;
    private UnaryOperator<String> inputChangeHandler;
    private boolean initialInputConfigured;
    private boolean closeOnSelectConfigured;
    private boolean inputChangeHandlerConfigured;

    CustomAnvilInputConfig() {
    }

    public String getInitialInput() {
        return this.initialInput;
    }

    public boolean isCloseOnSelect() {
        return this.closeOnSelect;
    }

    public UnaryOperator<String> getInputChangeHandler() {
        return this.inputChangeHandler;
    }

    @Contract(value="_ -> this")
    public CustomAnvilInputConfig initialInput(String initialInput) {
        this.initialInput = initialInput == null ? "" : initialInput;
        this.initialInputConfigured = true;
        return this;
    }

    @Contract(value="-> this")
    public CustomAnvilInputConfig closeOnSelect() {
        return this.closeOnSelect(true);
    }

    @Contract(value="_ -> this")
    public CustomAnvilInputConfig closeOnSelect(boolean closeOnSelect) {
        this.closeOnSelect = closeOnSelect;
        this.closeOnSelectConfigured = true;
        return this;
    }

    @Contract(value="_ -> this")
    public CustomAnvilInputConfig onInputChange(UnaryOperator<String> inputChangeHandler) {
        this.inputChangeHandler = inputChangeHandler;
        this.inputChangeHandlerConfigured = true;
        return this;
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> serialized = new LinkedHashMap<String, Object>(3);
        serialized.put("initialInput", this.initialInput);
        serialized.put("closeOnSelect", this.closeOnSelect);
        return serialized;
    }

    public static CustomAnvilInputConfig deserialize(Map<String, Object> serialized) {
        Object close;
        CustomAnvilInputConfig config = new CustomAnvilInputConfig();
        if (serialized == null) {
            return config;
        }
        Object initial = serialized.get("initialInput");
        if (initial instanceof String) {
            config.initialInput((String)initial);
        }
        if ((close = serialized.get("closeOnSelect")) instanceof Boolean) {
            config.closeOnSelect((Boolean)close);
        } else if (close instanceof String) {
            config.closeOnSelect(Boolean.parseBoolean((String)close));
        }
        return config;
    }

    public CustomAnvilInputConfig copy() {
        CustomAnvilInputConfig copy = new CustomAnvilInputConfig();
        copy.initialInput = this.initialInput;
        copy.closeOnSelect = this.closeOnSelect;
        copy.inputChangeHandler = this.inputChangeHandler;
        copy.initialInputConfigured = this.initialInputConfigured;
        copy.closeOnSelectConfigured = this.closeOnSelectConfigured;
        copy.inputChangeHandlerConfigured = this.inputChangeHandlerConfigured;
        return copy;
    }

    public CustomAnvilInputConfig merge(CustomAnvilInputConfig overrides) {
        CustomAnvilInputConfig merged = this.copy();
        if (overrides == null) {
            return merged;
        }
        if (overrides.initialInputConfigured) {
            merged.initialInput = overrides.initialInput;
            merged.initialInputConfigured = true;
        }
        if (overrides.closeOnSelectConfigured) {
            merged.closeOnSelect = overrides.closeOnSelect;
            merged.closeOnSelectConfigured = true;
        }
        if (overrides.inputChangeHandlerConfigured) {
            merged.inputChangeHandler = overrides.inputChangeHandler;
            merged.inputChangeHandlerConfigured = true;
        }
        return merged;
    }
}

