/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.view;

import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.view.BaseView;
import de.jexcellence.jextranslate.i18n.I18n;
import de.jexcellence.remapped.me.devnatan.inventoryframework.View;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.Context;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.OpenContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.SlotClickContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfirmationView
extends BaseView {
    private final State<String> customKey = this.initialState("key");
    private final State<Map<String, Object>> initialData = this.initialState("initialData");
    private final State<Consumer<Boolean>> callback = this.initialState("callback");

    @Override
    protected String getKey() {
        return "";
    }

    @Override
    protected String[] getLayout() {
        return new String[]{"         ", " ccc xxx ", " ccc xxx ", " ccc xxx ", "         ", "b        "};
    }

    @Override
    public void onOpen(@NotNull OpenContext open) {
        String key = (String)this.customKey.get((StateValueHost)open);
        if (key == null) {
            key = super.getTitleKey();
        }
        open.modifyConfig().title(new I18n.Builder(key + ".title", open.getPlayer()).withPlaceholders(this.getTitlePlaceholders(open)).build().component());
    }

    @Override
    protected void handleBackButtonClick(@NotNull SlotClickContext clickContext) {
        clickContext.back(this.mergeWithInitialData(Map.of("confirmed", false), (Context)clickContext));
        Consumer callback = (Consumer)this.callback.get((StateValueHost)clickContext);
        if (callback != null) {
            callback.accept(false);
        }
    }

    @Override
    public void onFirstRender(@NotNull RenderContext render, @NotNull Player player) {
        render.layoutSlot('c', UnifiedBuilderFactory.item(Material.LIME_STAINED_GLASS_PANE).setName((Component)new I18n.Builder((String)this.customKey.get((StateValueHost)render) + ".confirm.name", player).build().component()).setLore(new I18n.Builder((String)this.customKey.get((StateValueHost)render) + ".confirm.lore", player).withPlaceholders((Map)this.initialData.get((StateValueHost)render)).build().children()).build()).onClick(this::handleConfirm);
        render.layoutSlot('x', UnifiedBuilderFactory.item(Material.RED_STAINED_GLASS_PANE).setName((Component)new I18n.Builder((String)this.customKey.get((StateValueHost)render) + ".cancel.name", player).build().component()).setLore(new I18n.Builder((String)this.customKey.get((StateValueHost)render) + ".cancel.lore", player).withPlaceholders((Map)this.initialData.get((StateValueHost)render)).build().children()).build()).onClick(this::handleCancel);
    }

    private void handleConfirm(@NotNull Context clickContext) {
        clickContext.back(this.mergeWithInitialData(Map.of("confirmed", true), clickContext));
        Consumer callback = (Consumer)this.callback.get((StateValueHost)clickContext);
        if (callback != null) {
            callback.accept(true);
        }
    }

    private void handleCancel(@NotNull Context clickContext) {
        clickContext.back(this.mergeWithInitialData(Map.of("confirmed", false), clickContext));
        Consumer callback = (Consumer)this.callback.get((StateValueHost)clickContext);
        if (callback != null) {
            callback.accept(false);
        }
    }

    private Map<String, Object> mergeWithInitialData(@NotNull Map<String, Object> result, @NotNull Context context) {
        Map initial = (Map)this.initialData.get((StateValueHost)context);
        if (initial == null) {
            return result;
        }
        HashMap<String, Object> merged = new HashMap<String, Object>(initial);
        merged.putAll(result);
        return merged;
    }

    public static class Builder {
        private String key;
        private String messageKey;
        private Map<String, Object> initialData;
        private Consumer<Boolean> callback;
        private Class<? extends View> parentViewClass;

        public Builder withKey(@NotNull String key) {
            this.key = key;
            return this;
        }

        public Builder withMessageKey(@NotNull String messageKey) {
            this.messageKey = messageKey;
            return this;
        }

        public Builder withInitialData(@Nullable Map<String, Object> initialData) {
            this.initialData = initialData;
            return this;
        }

        public Builder withCallback(@Nullable Consumer<Boolean> callback) {
            this.callback = callback;
            return this;
        }

        public Builder withParentView(@Nullable Class<? extends View> parentViewClass) {
            this.parentViewClass = parentViewClass;
            return this;
        }

        public void openFor(@NotNull Context context, @NotNull Player player) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (this.key != null) {
                data.put("key", this.key);
            }
            if (this.messageKey != null) {
                data.put("messageKey", this.messageKey);
            }
            if (this.initialData != null) {
                data.put("initialData", this.initialData);
            }
            if (this.callback != null) {
                data.put("callback", this.callback);
            }
            if (this.parentViewClass != null) {
                data.put("parentViewClass", this.parentViewClass);
            }
            try {
                context.openForPlayer(ConfirmationView.class, data);
            }
            catch (Exception exception) {
                CentralLogger.getLogger(ConfirmationView.class.getName()).log(Level.WARNING, "Failed to open confirmation dialog", exception);
                context.back(data);
            }
        }
    }
}

