/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.view;

import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.utility.heads.view.Return;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.version.ServerEnvironment;
import de.jexcellence.jextranslate.i18n.I18n;
import de.jexcellence.remapped.me.devnatan.inventoryframework.View;
import de.jexcellence.remapped.me.devnatan.inventoryframework.ViewConfigBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.Context;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.IFContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.OpenContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.SlotClickContext;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseView
extends View {
    protected final Class<? extends View> parentClazz;
    private final String baseKey;

    public BaseView(@Nullable Class<? extends View> parentClazz) {
        this.parentClazz = parentClazz;
        this.baseKey = this.getKey();
    }

    public BaseView() {
        this(null);
    }

    protected abstract String getKey();

    protected String getTitleKey() {
        return "title";
    }

    protected I18n.Builder i18n(@NotNull String suffix, @NotNull Player player) {
        return new I18n.Builder(this.baseKey + "." + suffix, player);
    }

    protected String[] getLayout() {
        return new String[]{"         ", "         ", "         ", "         ", "         ", "         "};
    }

    protected int getSize() {
        return 6;
    }

    protected int getUpdateSchedule() {
        return 0;
    }

    protected Material getFillMaterial() {
        return Material.GRAY_STAINED_GLASS_PANE;
    }

    protected boolean shouldAutoFill() {
        return true;
    }

    protected ItemStack createFillItem(@NotNull Player player) {
        return UnifiedBuilderFactory.item(this.getFillMaterial()).setName((Component)Component.empty()).setLore(new ArrayList<Component>()).build();
    }

    protected Map<String, Object> getTitlePlaceholders(@NotNull OpenContext open) {
        return Map.of();
    }

    @Deprecated
    protected char getBackButtonChar() {
        return 'b';
    }

    protected void handleBackButtonClick(@NotNull SlotClickContext clickContext) {
        if (this.parentClazz == null) {
            clickContext.closeForPlayer();
            return;
        }
        try {
            clickContext.openForPlayer(this.parentClazz, clickContext.getInitialData());
        }
        catch (Exception exception) {
            CentralLogger.getLogger(BaseView.class.getName()).log(Level.WARNING, "Failed to open parent view: " + this.parentClazz.getSimpleName(), exception);
            clickContext.closeForPlayer();
        }
    }

    private boolean meaningfulLayout() {
        String[] layout = this.getLayout();
        if (layout == null) {
            return false;
        }
        for (String row : layout) {
            if (row == null || row.trim().isEmpty()) continue;
            for (char c : row.toCharArray()) {
                if (c == ' ') continue;
                return true;
            }
        }
        return false;
    }

    private int getInventoryRows() {
        if (this.meaningfulLayout()) {
            String[] layout = this.getLayout();
            return layout != null ? layout.length : this.getSize();
        }
        return this.getSize();
    }

    private int getTotalSlots() {
        return this.getInventoryRows() * 9;
    }

    private int getBottomLeftSlot() {
        int rows = this.getInventoryRows();
        return rows <= 1 ? -1 : (rows - 1) * 9;
    }

    public void onInit(@NotNull ViewConfigBuilder config) {
        if (this.meaningfulLayout()) {
            config.layout(this.getLayout());
            CentralLogger.getLogger(BaseView.class.getName()).log(Level.FINE, "Using layout configuration for view: " + ((Object)((Object)this)).getClass().getSimpleName());
        } else {
            config.size(this.getSize());
            CentralLogger.getLogger(BaseView.class.getName()).log(Level.FINE, "Using size configuration (" + this.getSize() + ") for view: " + ((Object)((Object)this)).getClass().getSimpleName());
        }
        if (this.getUpdateSchedule() > 0) {
            config.scheduleUpdate((long)this.getUpdateSchedule());
        }
        config.build();
    }

    public void onOpen(@NotNull OpenContext open) {
        Component titleComponent = (Component)this.i18n(this.getTitleKey(), open.getPlayer()).withPlaceholders(this.getTitlePlaceholders(open)).build().component();
        String titleString = LegacyComponentSerializer.legacySection().serialize(titleComponent);
        open.modifyConfig().title((Object)titleString);
        CentralLogger.getLogger(BaseView.class.getName()).log(Level.FINE, "Set inventory title for " + open.getPlayer().getName() + " using " + ServerEnvironment.getInstance().getServerType().name() + " format");
    }

    public void onFirstRender(@NotNull RenderContext render) {
        Player player = render.getPlayer();
        this.renderNavigationButtons(render, player);
        this.onFirstRender(render, player);
        if (this.shouldAutoFill()) {
            this.autoFillEmptySlots(render, player);
        }
    }

    public void onResume(@NotNull Context origin, @NotNull Context target) {
        super.onResume((IFContext)origin, (IFContext)target);
    }

    private void autoFillEmptySlots(@NotNull RenderContext render, @NotNull Player player) {
        ItemStack fillItem = this.createFillItem(player);
        int totalSlots = this.getTotalSlots();
        CentralLogger.getLogger(BaseView.class.getName()).log(Level.FINE, "Auto-filled " + totalSlots + " slots with " + this.getFillMaterial().name() + " for view: " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public abstract void onFirstRender(@NotNull RenderContext var1, @NotNull Player var2);

    public void renderNavigationButtons(@NotNull RenderContext render, @NotNull Player player) {
        char slotChar;
        int lastRowIndex;
        int bottomLeftSlot = this.getBottomLeftSlot();
        if (bottomLeftSlot < 0) {
            CentralLogger.getLogger(BaseView.class.getName()).log(Level.FINE, "Skipped back button placement (single row inventory) for view: " + ((Object)((Object)this)).getClass().getSimpleName());
            return;
        }
        String[] layout = this.getLayout();
        if (layout != null && layout.length > 0 && (lastRowIndex = layout.length - 1) >= 0 && layout[lastRowIndex] != null && layout[lastRowIndex].length() > 0 && (slotChar = layout[lastRowIndex].charAt(0)) != ' ') {
            CentralLogger.getLogger(BaseView.class.getName()).log(Level.FINE, "Skipped back button placement (slot occupied by '" + slotChar + "') for view: " + ((Object)((Object)this)).getClass().getSimpleName());
            return;
        }
        render.slot(bottomLeftSlot, new Return().getHead(player)).onClick(this::handleBackButtonClick);
        CentralLogger.getLogger(BaseView.class.getName()).log(Level.FINE, "Placed back button at bottom-left slot " + bottomLeftSlot + " for view: " + ((Object)((Object)this)).getClass().getSimpleName());
    }
}

