/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.view;

import com.raindropcentral.rplatform.logging.CentralLogger;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.version.ServerEnvironment;
import de.jexcellence.jextranslate.i18n.I18n;
import de.jexcellence.remapped.me.devnatan.inventoryframework.AnvilInput;
import de.jexcellence.remapped.me.devnatan.inventoryframework.View;
import de.jexcellence.remapped.me.devnatan.inventoryframework.ViewConfig;
import de.jexcellence.remapped.me.devnatan.inventoryframework.ViewConfigBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.ViewType;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.Context;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.OpenContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.MutableState;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAnvilView
extends View {
    private final AnvilInput anvilInput = AnvilInput.createAnvilInput();
    private final Class<? extends View> parentClass;
    private final String baseKey;
    protected final State<Object> data = this.initialState("data");
    protected final MutableState<String> initialInput = this.mutableState("");
    private String cachedTitle;

    protected AbstractAnvilView(@Nullable Class<? extends View> parentClass) {
        this.parentClass = parentClass;
        this.baseKey = this.getKey();
    }

    protected AbstractAnvilView() {
        this(null);
    }

    protected abstract String getKey();

    protected abstract Object processInput(@NotNull String var1, @NotNull Context var2);

    protected String getTitleKey() {
        return this.baseKey + ".title";
    }

    protected Map<String, Object> getTitlePlaceholders(@NotNull OpenContext context) {
        return Map.of();
    }

    protected String getInitialInputText(@NotNull OpenContext context) {
        return "";
    }

    protected boolean isValidInput(@NotNull String input, @NotNull Context context) {
        return !input.trim().isEmpty();
    }

    protected String getValidationErrorKey() {
        return "error.invalid_input";
    }

    protected void setupFirstSlot(@NotNull RenderContext render, @NotNull Player player) {
        String initialText = null;
        try {
            initialText = (String)this.initialInput.get((StateValueHost)render);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (initialText == null || initialText.isEmpty()) {
            initialText = " ";
        }
        ItemStack item = UnifiedBuilderFactory.item(Material.NAME_TAG).setName((Component)Component.text((String)initialText)).setLore(this.i18n("input.lore", player).build().children()).build();
        render.firstSlot(item);
    }

    protected void setupMiddleSlot(@NotNull RenderContext render, @NotNull Player player) {
    }

    protected void onValidationFailed(@Nullable String input, @NotNull Context context) {
        this.i18n(this.getValidationErrorKey(), context.getPlayer()).includePrefix().withPlaceholder("input", input != null ? input : "").build().sendMessage();
    }

    protected void onProcessingFailed(@NotNull String input, @NotNull Context context, @NotNull Exception exception) {
        CentralLogger.getLogger(((Object)((Object)this)).getClass()).log(Level.WARNING, "Failed to process anvil input: " + input, exception);
        this.i18n("error.processing_failed", context.getPlayer()).includePrefix().withPlaceholder("input", input).build().sendMessage();
    }

    protected Map<String, Object> prepareResultData(@Nullable Object result, @NotNull String input, @NotNull Context context) {
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        if (result != null) {
            if (result instanceof ItemStack) {
                resultData.put("item", result);
            } else {
                resultData.put("result", result);
            }
        } else {
            resultData.put("input", input);
        }
        try {
            Object existingData = this.data.get((StateValueHost)context);
            if (existingData instanceof Map) {
                resultData.putAll((Map)existingData);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return resultData;
    }

    protected I18n.Builder i18n(@NotNull String suffix, @NotNull Player player) {
        return new I18n.Builder(this.baseKey + "." + suffix, player);
    }

    private Component buildTitle(@NotNull OpenContext context) {
        return (Component)this.i18n(this.getTitleKey(), context.getPlayer()).withPlaceholders(this.getTitlePlaceholders(context)).build().component();
    }

    public void onInit(@NotNull ViewConfigBuilder config) {
        config.type(ViewType.ANVIL).use((ViewConfig.Modifier)this.anvilInput).title((Object)"");
    }

    public void onOpen(@NotNull OpenContext open) {
        String initialText = this.getInitialInputText(open);
        if (initialText != null && !initialText.isEmpty()) {
            this.initialInput.set((Object)initialText, (StateValueHost)open);
        }
        Component titleComponent = this.buildTitle(open);
        if (ServerEnvironment.getInstance().isPaper()) {
            open.modifyConfig().title((Object)titleComponent);
        } else {
            String legacyTitle = LegacyComponentSerializer.legacySection().serialize(titleComponent);
            open.modifyConfig().title((Object)legacyTitle);
        }
    }

    public void onFirstRender(@NotNull RenderContext render) {
        Player player = render.getPlayer();
        this.setupFirstSlot(render, player);
        this.setupMiddleSlot(render, player);
        this.setupResultSlot(render);
    }

    private void setupResultSlot(@NotNull RenderContext render) {
        ((BukkitItemComponentBuilder)render.resultSlot()).onClick(clickContext -> {
            String input = (String)this.anvilInput.get((StateValueHost)clickContext);
            if (!this.isValidInput(input, (Context)render)) {
                this.onValidationFailed(input, (Context)clickContext);
                return;
            }
            try {
                Object result = this.processInput(input, (Context)clickContext);
                Map<String, Object> resultData = this.prepareResultData(result, input, (Context)clickContext);
                clickContext.back(resultData);
            }
            catch (Exception exception) {
                this.onProcessingFailed(input, (Context)clickContext, exception);
            }
        });
    }
}

