/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.view;

import com.raindropcentral.rplatform.utility.heads.RHead;
import com.raindropcentral.rplatform.utility.heads.view.Next;
import com.raindropcentral.rplatform.utility.heads.view.Previous;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import com.raindropcentral.rplatform.view.BaseView;
import de.jexcellence.jextranslate.i18n.I18n;
import de.jexcellence.remapped.me.devnatan.inventoryframework.View;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.BukkitItemComponentBuilder;
import de.jexcellence.remapped.me.devnatan.inventoryframework.component.Pagination;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.Context;
import de.jexcellence.remapped.me.devnatan.inventoryframework.context.RenderContext;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.State;
import de.jexcellence.remapped.me.devnatan.inventoryframework.state.StateValueHost;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class APaginatedView<T>
extends BaseView {
    private final State<Pagination> pagination = this.buildLazyAsyncPaginationState(this::getAsyncPaginationSource).layoutTarget('O').elementFactory(this::renderEntry).build();

    public APaginatedView(@Nullable Class<? extends View> parentClazz) {
        super(parentClazz);
    }

    public APaginatedView() {
        this(null);
    }

    protected abstract CompletableFuture<List<T>> getAsyncPaginationSource(@NotNull Context var1);

    protected abstract void renderEntry(@NotNull Context var1, @NotNull BukkitItemComponentBuilder var2, int var3, @NotNull T var4);

    @Override
    protected String[] getLayout() {
        return new String[]{"XXXXXXXXX", "XOOOOOOOX", "XOOOOOOOX", "XOOOOOOOX", "XXXXXXXXX", "   <p>   "};
    }

    protected char getPaginationSlotChar() {
        return 'O';
    }

    protected char getPreviousButtonChar() {
        return '<';
    }

    protected char getNextButtonChar() {
        return '>';
    }

    protected char getPageIndicatorChar() {
        return 'p';
    }

    @Override
    public void onFirstRender(@NotNull RenderContext render, @NotNull Player player) {
        this.renderPaginationNavigationButtons(render, player, (Pagination)this.pagination.get((StateValueHost)render));
        this.renderPageIndicator(render, player, (Pagination)this.pagination.get((StateValueHost)render));
        this.onPaginatedRender(render, player);
    }

    protected abstract void onPaginatedRender(@NotNull RenderContext var1, @NotNull Player var2);

    private void renderPaginationNavigationButtons(@NotNull RenderContext render, @NotNull Player player, @NotNull Pagination pagination) {
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.layoutSlot(this.getPreviousButtonChar(), new Previous().getHead(player)).updateOnStateChange(this.pagination)).displayIf(() -> ((Pagination)pagination).canBack())).onClick(() -> ((Pagination)pagination).back());
        ((BukkitItemComponentBuilder)((BukkitItemComponentBuilder)render.layoutSlot(this.getNextButtonChar(), new Next().getHead(player)).updateOnStateChange(this.pagination)).displayIf(() -> ((Pagination)pagination).canAdvance())).onClick(() -> ((Pagination)pagination).advance());
    }

    private void renderPageIndicator(@NotNull RenderContext render, @NotNull Player player, @NotNull Pagination pagination) {
        boolean hasPageIndicator = render.getLayoutSlots().stream().anyMatch(layoutSlot -> layoutSlot.getCharacter() == this.getPageIndicatorChar());
        if (!hasPageIndicator) {
            return;
        }
        int currentPage = pagination.currentPageIndex();
        ItemStack pageItem = this.getPageIndicatorItem(player, currentPage);
        int currentPageDisplay = currentPage + 1;
        int totalPages = pagination.lastPageIndex() + 1;
        int itemsCount = pagination.source() == null ? 0 : pagination.source().size();
        HashMap<String, Object> placeholders = new HashMap<String, Object>();
        placeholders.put("page", currentPageDisplay);
        placeholders.put("max_page", totalPages);
        placeholders.put("current_page", currentPageDisplay);
        placeholders.put("total_pages", totalPages);
        placeholders.put("first_page", 1);
        placeholders.put("items_count", itemsCount);
        render.layoutSlot(this.getPageIndicatorChar(), UnifiedBuilderFactory.item(pageItem).setName((Component)new I18n.Builder("page.name", player).withPlaceholders(placeholders).build().component()).setLore(new I18n.Builder("page.lore", player).withPlaceholders(placeholders).build().children()).build()).updateOnStateChange(this.pagination);
    }

    private ItemStack getPageIndicatorItem(@NotNull Player player, int pageIndex) {
        try {
            if (pageIndex >= 0 && pageIndex <= 9) {
                String className = "com.raindropcentral.rplatform.misc.heads.view.pagination.Number" + pageIndex;
                Class<?> pageIndexClass = Class.forName(className);
                return ((RHead)pageIndexClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getHead(player);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return UnifiedBuilderFactory.item(Material.PAPER).setName((Component)new I18n.Builder("page.fallback", player).withPlaceholder("page", pageIndex + 1).build().component()).build();
    }

    protected final Pagination getPagination(@NotNull RenderContext context) {
        return (Pagination)this.pagination.get((StateValueHost)context);
    }

    @Override
    public void onResume(@NotNull Context origin, @NotNull Context target) {
        super.onResume(origin, target);
    }
}

