/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.version;

import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class ServerEnvironment {
    private static final Logger LOGGER = Logger.getLogger(ServerEnvironment.class.getName());
    private static volatile ServerEnvironment instance;
    private final ServerType serverType = this.detectServerType();
    private final String serverVersion;
    private final String minecraftVersion = this.detectMinecraftVersion();
    private final boolean modernVersion;

    private ServerEnvironment() {
        this.serverVersion = this.detectServerVersion();
        this.modernVersion = this.isVersionModern();
        this.logEnvironmentInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static ServerEnvironment getInstance() {
        if (instance != null) return instance;
        Class<ServerEnvironment> clazz = ServerEnvironment.class;
        synchronized (ServerEnvironment.class) {
            if (instance != null) return instance;
            instance = new ServerEnvironment();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @NotNull
    public ServerType getServerType() {
        return this.serverType;
    }

    @NotNull
    public String getServerVersion() {
        return this.serverVersion;
    }

    @NotNull
    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public boolean isModern() {
        return this.modernVersion;
    }

    public boolean isPaper() {
        return this.serverType == ServerType.PAPER || this.serverType == ServerType.PURPUR;
    }

    public boolean isFolia() {
        return this.serverType == ServerType.FOLIA;
    }

    public boolean isSpigot() {
        return this.serverType == ServerType.SPIGOT;
    }

    public boolean hasClass(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean isVersionAtLeast(@NotNull String targetVersion) {
        return this.serverVersion.compareTo(targetVersion) >= 0;
    }

    @NotNull
    private ServerType detectServerType() {
        if (this.hasClass("io.papermc.paper.threadedregions.RegionizedServer")) {
            return ServerType.FOLIA;
        }
        if (this.hasClass("com.destroystokyo.paper.ParticleBuilder")) {
            if (this.hasClass("org.purpurmc.purpur.PurpurConfig")) {
                return ServerType.PURPUR;
            }
            return ServerType.PAPER;
        }
        return ServerType.SPIGOT;
    }

    @NotNull
    private String detectMinecraftVersion() {
        try {
            return Bukkit.getVersion();
        }
        catch (Exception e) {
            LOGGER.warning("Failed to detect Minecraft version: " + e.getMessage());
            return "unknown";
        }
    }

    @NotNull
    private String detectServerVersion() {
        try {
            String packageName = Bukkit.getServer().getClass().getPackage().getName();
            String[] parts = packageName.split("\\.");
            if (parts.length > 3) {
                return parts[3];
            }
        }
        catch (Exception e) {
            LOGGER.warning("Failed to detect server version: " + e.getMessage());
        }
        return "unknown";
    }

    private boolean isVersionModern() {
        if ("unknown".equals(this.serverVersion)) {
            return true;
        }
        return this.serverVersion.compareTo("v1_13") >= 0;
    }

    private void logEnvironmentInfo() {
        LOGGER.info("=== Server Environment ===");
        LOGGER.info("Type: " + String.valueOf((Object)this.serverType));
        LOGGER.info("Version: " + this.serverVersion);
        LOGGER.info("Minecraft: " + this.minecraftVersion);
        LOGGER.info("Modern: " + this.modernVersion);
        LOGGER.info("=========================");
    }

    public static enum ServerType {
        FOLIA,
        PAPER,
        PURPUR,
        SPIGOT;

    }
}

