/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.utility.itembuilder.skull;

import com.raindropcentral.rplatform.api.PlatformAPI;
import com.raindropcentral.rplatform.utility.itembuilder.skull.SafeHeadBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedHeadBuilder {
    private final PlatformAPI platformAPI;
    private ItemStack head;

    public UnifiedHeadBuilder(@NotNull PlatformAPI platformAPI) {
        this.platformAPI = platformAPI;
        this.head = platformAPI.createPlayerHead((Player)null);
    }

    public UnifiedHeadBuilder(@NotNull PlatformAPI platformAPI, @Nullable Player player) {
        this.platformAPI = platformAPI;
        this.head = platformAPI.createPlayerHead(player);
    }

    public UnifiedHeadBuilder(@NotNull PlatformAPI platformAPI, @Nullable OfflinePlayer offlinePlayer) {
        this.platformAPI = platformAPI;
        this.head = platformAPI.createPlayerHead(offlinePlayer);
    }

    public UnifiedHeadBuilder(@NotNull PlatformAPI platformAPI, @NotNull UUID uuid, @NotNull String textureData) {
        this.platformAPI = platformAPI;
        this.head = platformAPI.createCustomHead(uuid, textureData);
    }

    public UnifiedHeadBuilder() {
        this.platformAPI = null;
        this.head = this.createHeadUsingLegacyBuilders(null, null, null, null);
    }

    public UnifiedHeadBuilder(@Nullable Player player) {
        this.platformAPI = null;
        this.head = this.createHeadUsingLegacyBuilders(player, null, null, null);
    }

    public UnifiedHeadBuilder(@Nullable OfflinePlayer offlinePlayer) {
        this.platformAPI = null;
        this.head = this.createHeadUsingLegacyBuilders(null, offlinePlayer, null, null);
    }

    public UnifiedHeadBuilder(@NotNull UUID uuid, @NotNull String textureData) {
        this.platformAPI = null;
        this.head = this.createHeadUsingLegacyBuilders(null, null, uuid, textureData);
    }

    @NotNull
    private ItemStack createHeadUsingLegacyBuilders(@Nullable Player player, @Nullable OfflinePlayer offlinePlayer, @Nullable UUID uuid, @Nullable String textureData) {
        SafeHeadBuilder builder = new SafeHeadBuilder();
        if (player != null) {
            builder.setPlayerHead(player);
        } else if (offlinePlayer != null) {
            builder.setPlayerHead(offlinePlayer);
        } else if (uuid != null && textureData != null) {
            builder.setCustomTexture(uuid, textureData);
        }
        return builder.build();
    }

    @NotNull
    public UnifiedHeadBuilder setPlayerHead(@Nullable Player player) {
        this.head = this.platformAPI != null ? this.platformAPI.createPlayerHead(player) : this.createHeadUsingLegacyBuilders(player, null, null, null);
        return this;
    }

    @NotNull
    public UnifiedHeadBuilder setPlayerHead(@Nullable OfflinePlayer offlinePlayer) {
        this.head = this.platformAPI != null ? this.platformAPI.createPlayerHead(offlinePlayer) : this.createHeadUsingLegacyBuilders(null, offlinePlayer, null, null);
        return this;
    }

    @NotNull
    public UnifiedHeadBuilder setCustomTexture(@NotNull UUID uuid, @NotNull String textureData) {
        this.head = this.platformAPI != null ? this.platformAPI.applyCustomTexture(this.head, uuid, textureData) : this.createHeadUsingLegacyBuilders(null, null, uuid, textureData);
        return this;
    }

    @NotNull
    public UnifiedHeadBuilder setDisplayName(@Nullable Component displayName) {
        if (this.platformAPI != null) {
            this.head = this.platformAPI.setItemDisplayName(this.head, displayName);
        } else {
            this.setDisplayNameLegacy(displayName);
        }
        return this;
    }

    @NotNull
    public UnifiedHeadBuilder setDisplayName(@Nullable String displayName) {
        TextComponent component = displayName != null ? Component.text((String)displayName) : null;
        return this.setDisplayName((Component)component);
    }

    private void setDisplayNameLegacy(@Nullable Component displayName) {
        ItemMeta meta = this.head.getItemMeta();
        if (meta != null) {
            if (displayName != null) {
                meta.setDisplayName(this.convertComponentToLegacy(displayName));
            } else {
                meta.setDisplayName(null);
            }
            this.head.setItemMeta(meta);
        }
    }

    private void setLoreLegacy(@NotNull List<Component> lore) {
        ItemMeta meta = this.head.getItemMeta();
        if (meta != null) {
            ArrayList<String> legacyLore = new ArrayList<String>();
            for (Component component : lore) {
                legacyLore.add(this.convertComponentToLegacy(component));
            }
            meta.setLore(legacyLore);
            this.head.setItemMeta(meta);
        }
    }

    private String convertComponentToLegacy(@NotNull Component component) {
        return PlainTextComponentSerializer.plainText().serialize(component);
    }

    @NotNull
    private List<Component> getLoreLegacy() {
        ItemMeta meta = this.head.getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return new ArrayList<Component>();
        }
        List legacyLore = meta.getLore();
        if (legacyLore == null) {
            return new ArrayList<Component>();
        }
        ArrayList<Component> componentLore = new ArrayList<Component>();
        for (String line : legacyLore) {
            componentLore.add((Component)Component.text((String)line));
        }
        return componentLore;
    }

    @NotNull
    public UnifiedHeadBuilder setLore(@NotNull List<Component> lore) {
        if (this.platformAPI != null) {
            this.head = this.platformAPI.setItemLore(this.head, lore);
        } else {
            this.setLoreLegacy(lore);
        }
        return this;
    }

    @NotNull
    public UnifiedHeadBuilder addLoreLine(@NotNull Component line) {
        List<Component> currentLore = this.getLore();
        currentLore.add(line);
        return this.setLore(currentLore);
    }

    @NotNull
    public UnifiedHeadBuilder addLoreLine(@NotNull String line) {
        return this.addLoreLine((Component)Component.text((String)line));
    }

    @Nullable
    public Component getDisplayName() {
        if (this.platformAPI != null) {
            return this.platformAPI.getItemDisplayName(this.head);
        }
        ItemMeta meta = this.head.getItemMeta();
        if (meta != null && meta.hasDisplayName()) {
            return Component.text((String)meta.getDisplayName());
        }
        return null;
    }

    @NotNull
    public List<Component> getLore() {
        if (this.platformAPI != null) {
            return this.platformAPI.getItemLore(this.head);
        }
        return this.getLoreLegacy();
    }

    @NotNull
    public ItemStack build() {
        return this.head.clone();
    }

    @NotNull
    public static UnifiedHeadBuilder player(@Nullable Player player) {
        return new UnifiedHeadBuilder(player);
    }

    @NotNull
    public static UnifiedHeadBuilder player(@Nullable OfflinePlayer offlinePlayer) {
        return new UnifiedHeadBuilder(offlinePlayer);
    }

    @NotNull
    public static UnifiedHeadBuilder custom(@NotNull UUID uuid, @NotNull String textureData) {
        return new UnifiedHeadBuilder(uuid, textureData);
    }

    @NotNull
    public static UnifiedHeadBuilder custom(@NotNull String textureData) {
        return new UnifiedHeadBuilder(UUID.randomUUID(), textureData);
    }
}

