/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.utility.itembuilder.skull;

import com.raindropcentral.rplatform.utility.itembuilder.AItemBuilder;
import com.raindropcentral.rplatform.utility.itembuilder.skull.IHeadBuilder;
import com.raindropcentral.rplatform.version.ServerEnvironment;
import java.lang.reflect.Field;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public class SafeHeadBuilder
extends AItemBuilder<SkullMeta, SafeHeadBuilder>
implements IHeadBuilder<SafeHeadBuilder> {
    public SafeHeadBuilder() {
        super(SafeHeadBuilder.createHeadMaterial());
    }

    private static Material createHeadMaterial() {
        try {
            return Material.PLAYER_HEAD;
        }
        catch (Exception e) {
            try {
                return Material.valueOf((String)"SKULL_ITEM");
            }
            catch (Exception ex) {
                return Material.valueOf((String)"PLAYER_HEAD");
            }
        }
    }

    @Override
    public SafeHeadBuilder setPlayerHead(Player player) {
        if (player == null) {
            return this;
        }
        if (ServerEnvironment.getInstance().isPaper()) {
            try {
                ((SkullMeta)this.meta).setPlayerProfile(player.getPlayerProfile());
            }
            catch (Exception e) {
                ((SkullMeta)this.meta).setOwner(player.getName());
            }
        } else {
            ((SkullMeta)this.meta).setOwner(player.getName());
        }
        return this;
    }

    @Override
    public SafeHeadBuilder setPlayerHead(OfflinePlayer offlinePlayer) {
        if (offlinePlayer == null) {
            return this;
        }
        if (ServerEnvironment.getInstance().isPaper()) {
            try {
                ((SkullMeta)this.meta).setPlayerProfile(offlinePlayer.getPlayerProfile());
                ((SkullMeta)this.meta).setOwningPlayer(offlinePlayer);
            }
            catch (Exception e) {
                ((SkullMeta)this.meta).setOwner(offlinePlayer.getName());
                ((SkullMeta)this.meta).setOwningPlayer(offlinePlayer);
            }
        } else {
            ((SkullMeta)this.meta).setOwner(offlinePlayer.getName());
            ((SkullMeta)this.meta).setOwningPlayer(offlinePlayer);
        }
        return this;
    }

    @Override
    public SafeHeadBuilder setCustomTexture(@NotNull UUID uuid, @NotNull String textures) {
        if (ServerEnvironment.getInstance().isPaper()) {
            try {
                this.setPaperCustomTexture(uuid, textures);
                return this;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setLegacyCustomTexture(uuid, textures);
        return this;
    }

    private void setPaperCustomTexture(@NotNull UUID uuid, @NotNull String textures) throws Exception {
        Class<?> bukkitClass = Class.forName("org.bukkit.Bukkit");
        Class<?> playerProfileClass = Class.forName("com.destroystokyo.paper.profile.PlayerProfile");
        Class<?> profilePropertyClass = Class.forName("com.destroystokyo.paper.profile.ProfileProperty");
        Object profile = bukkitClass.getMethod("createProfile", UUID.class, String.class).invoke(null, uuid, null);
        Object property = profilePropertyClass.getConstructor(String.class, String.class, String.class).newInstance("textures", textures, null);
        playerProfileClass.getMethod("setProperty", profilePropertyClass).invoke(profile, property);
        ((SkullMeta)this.meta).getClass().getMethod("setPlayerProfile", playerProfileClass).invoke((Object)this.meta, profile);
    }

    private void setLegacyCustomTexture(@NotNull UUID uuid, @NotNull String textures) {
        try {
            String profileName = ((SkullMeta)this.meta).getOwner();
            if (profileName == null || profileName.trim().isEmpty()) {
                profileName = "CustomHead";
            }
            Object profile = this.createGameProfile(uuid, profileName, textures);
            try {
                ((SkullMeta)this.meta).getClass().getMethod("setProfile", profile.getClass()).invoke((Object)this.meta, profile);
            }
            catch (NoSuchMethodException e) {
                this.setProfileViaField(profile);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to set custom texture: " + e.getMessage());
        }
    }

    private void setProfileViaField(Object profile) throws Exception {
        Field profileField = ((SkullMeta)this.meta).getClass().getDeclaredField("profile");
        profileField.setAccessible(true);
        Class<?> fieldType = profileField.getType();
        if (fieldType.getSimpleName().equals("ResolvableProfile")) {
            Object resolvableProfile = this.createResolvableProfile(profile);
            profileField.set(this.meta, resolvableProfile);
        } else {
            profileField.set(this.meta, profile);
        }
    }

    private Object createResolvableProfile(Object gameProfile) throws Exception {
        try {
            Class<?> resolvableProfileClass = Class.forName("net.minecraft.world.item.component.ResolvableProfile");
            try {
                return resolvableProfileClass.getConstructor(gameProfile.getClass()).newInstance(gameProfile);
            }
            catch (NoSuchMethodException e) {
                try {
                    return resolvableProfileClass.getMethod("of", gameProfile.getClass()).invoke(null, gameProfile);
                }
                catch (NoSuchMethodException e2) {
                    return resolvableProfileClass.getMethod("create", gameProfile.getClass()).invoke(null, gameProfile);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create ResolvableProfile from GameProfile", e);
        }
    }

    @NotNull
    private Object createGameProfile(@NotNull UUID uuid, String name, @NotNull String textureData) throws Exception {
        if (name == null || name.trim().isEmpty()) {
            name = "CustomHead";
        }
        Class<?> gameProfileClass = Class.forName("com.mojang.authlib.GameProfile");
        Class<?> propertyClass = Class.forName("com.mojang.authlib.properties.Property");
        Object profile = gameProfileClass.getConstructor(UUID.class, String.class).newInstance(uuid, name);
        Object property = propertyClass.getConstructor(String.class, String.class).newInstance("textures", textureData);
        Object properties = gameProfileClass.getMethod("getProperties", new Class[0]).invoke(profile, new Object[0]);
        properties.getClass().getMethod("put", Object.class, Object.class).invoke(properties, "textures", property);
        return profile;
    }

    @Override
    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        return this.item;
    }
}

