/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.utility.itembuilder.skull;

import com.raindropcentral.rplatform.utility.itembuilder.AItemBuilder;
import com.raindropcentral.rplatform.utility.itembuilder.skull.IHeadBuilder;
import java.lang.reflect.Field;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public class LegacyHeadBuilder
extends AItemBuilder<SkullMeta, LegacyHeadBuilder>
implements IHeadBuilder<LegacyHeadBuilder> {
    public LegacyHeadBuilder() {
        super(new ItemStack(Material.PLAYER_HEAD, 1, 3));
    }

    @Override
    public LegacyHeadBuilder setPlayerHead(Player player) {
        if (player == null) {
            return this;
        }
        ((SkullMeta)this.meta).setOwner(player.getName());
        return this;
    }

    @Override
    public LegacyHeadBuilder setPlayerHead(OfflinePlayer offlinePlayer) {
        if (offlinePlayer == null) {
            return this;
        }
        ((SkullMeta)this.meta).setOwner(offlinePlayer.getName());
        ((SkullMeta)this.meta).setOwningPlayer(offlinePlayer);
        return this;
    }

    @Override
    public LegacyHeadBuilder setCustomTexture(@NotNull UUID uuid, @NotNull String textures) {
        try {
            String profileName = ((SkullMeta)this.meta).getOwner();
            if (profileName == null || profileName.trim().isEmpty()) {
                profileName = "CustomHead";
            }
            Object profile = this.createGameProfile(uuid, profileName, textures);
            try {
                ((SkullMeta)this.meta).getClass().getMethod("setProfile", profile.getClass()).invoke((Object)this.meta, profile);
            }
            catch (NoSuchMethodException e) {
                this.setProfileViaField(profile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to set custom texture on legacy head", e);
        }
        return this;
    }

    private void setProfileViaField(Object profile) throws Exception {
        Field profileField = ((SkullMeta)this.meta).getClass().getDeclaredField("profile");
        profileField.setAccessible(true);
        Class<?> fieldType = profileField.getType();
        if (fieldType.getSimpleName().equals("ResolvableProfile")) {
            Object resolvableProfile = this.createResolvableProfile(profile);
            profileField.set(this.meta, resolvableProfile);
        } else {
            profileField.set(this.meta, profile);
        }
    }

    private Object createResolvableProfile(Object gameProfile) throws Exception {
        try {
            Class<?> resolvableProfileClass = Class.forName("net.minecraft.world.item.component.ResolvableProfile");
            try {
                return resolvableProfileClass.getConstructor(gameProfile.getClass()).newInstance(gameProfile);
            }
            catch (NoSuchMethodException e) {
                try {
                    return resolvableProfileClass.getMethod("of", gameProfile.getClass()).invoke(null, gameProfile);
                }
                catch (NoSuchMethodException e2) {
                    return resolvableProfileClass.getMethod("create", gameProfile.getClass()).invoke(null, gameProfile);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create ResolvableProfile from GameProfile", e);
        }
    }

    private Object createGameProfile(@NotNull UUID uuid, @NotNull String name, @NotNull String texture) throws Exception {
        if (name.trim().isEmpty()) {
            name = "CustomHead";
        }
        Class<?> gameProfileClass = Class.forName("com.mojang.authlib.GameProfile");
        Class<?> propertyClass = Class.forName("com.mojang.authlib.properties.Property");
        Object profile = gameProfileClass.getConstructor(UUID.class, String.class).newInstance(uuid, name);
        Object property = propertyClass.getConstructor(String.class, String.class).newInstance("textures", texture);
        Object properties = gameProfileClass.getMethod("getProperties", new Class[0]).invoke(profile, new Object[0]);
        properties.getClass().getMethod("put", Object.class, Object.class).invoke(properties, "textures", property);
        return profile;
    }

    @Override
    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        return this.item;
    }
}

