/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.utility.itembuilder;

import com.raindropcentral.rplatform.utility.unified.IUnifiedItemBuilder;
import com.raindropcentral.rplatform.version.ServerEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class AItemBuilder<T extends ItemMeta, B extends IUnifiedItemBuilder<T, B>> {
    protected ItemStack item;
    protected T meta;

    protected AItemBuilder(@NotNull Material material) {
        this(new ItemStack(material));
    }

    protected AItemBuilder(@NotNull ItemStack item) {
        this.item = item;
        this.meta = item.getItemMeta();
    }

    public B setName(@NotNull Component name) {
        if (ServerEnvironment.getInstance().isPaper()) {
            try {
                this.meta.displayName(name);
            }
            catch (NoSuchMethodError e) {
                this.setNameLegacy(name);
            }
        } else {
            this.setNameLegacy(name);
        }
        return (B)((IUnifiedItemBuilder)((Object)this));
    }

    public B setLore(@NotNull List<Component> lore) {
        if (ServerEnvironment.getInstance().isPaper()) {
            try {
                this.meta.lore(lore);
            }
            catch (NoSuchMethodError e) {
                this.setLoreLegacy(lore);
            }
        } else {
            this.setLoreLegacy(lore);
        }
        return (B)((IUnifiedItemBuilder)((Object)this));
    }

    public B addLoreLine(@NotNull Component line) {
        List<Component> currentLore = this.getCurrentLore();
        currentLore.add(line);
        this.setLore(currentLore);
        return (B)((IUnifiedItemBuilder)((Object)this));
    }

    public B addLoreLines(@NotNull List<Component> lore) {
        List<Component> currentLore = this.getCurrentLore();
        currentLore.addAll(lore);
        this.setLore(currentLore);
        return (B)((IUnifiedItemBuilder)((Object)this));
    }

    public B addLoreLines(Component ... lore) {
        List<Component> currentLore = this.getCurrentLore();
        currentLore.addAll(Arrays.asList(lore));
        this.setLore(currentLore);
        return (B)((IUnifiedItemBuilder)((Object)this));
    }

    private void setNameLegacy(@NotNull Component name) {
        String legacyName = LegacyComponentSerializer.legacySection().serialize(name);
        this.meta.setDisplayName(legacyName);
    }

    private void setLoreLegacy(@NotNull List<Component> lore) {
        ArrayList<String> legacyLore = new ArrayList<String>();
        for (Component component : lore) {
            legacyLore.add(LegacyComponentSerializer.legacySection().serialize(component));
        }
        this.meta.setLore(legacyLore);
    }

    private List<Component> getCurrentLore() {
        if (ServerEnvironment.getInstance().isPaper()) {
            try {
                List lore = this.meta.lore();
                return lore != null ? new ArrayList<Component>(lore) : new ArrayList();
            }
            catch (NoSuchMethodError e) {
                return this.getCurrentLoreLegacy();
            }
        }
        return this.getCurrentLoreLegacy();
    }

    private List<Component> getCurrentLoreLegacy() {
        List legacyLore = this.meta.getLore();
        if (legacyLore == null) {
            return new ArrayList<Component>();
        }
        ArrayList<Component> componentLore = new ArrayList<Component>();
        for (String line : legacyLore) {
            componentLore.add((Component)LegacyComponentSerializer.legacySection().deserialize(line));
        }
        return componentLore;
    }

    public B setAmount(int amount) {
        this.item.setAmount(amount);
        return (B)((IUnifiedItemBuilder)((Object)this));
    }

    public B setCustomModelData(int data) {
        this.meta.setCustomModelData(Integer.valueOf(data));
        return (B)((IUnifiedItemBuilder)((Object)this));
    }

    public B addEnchantment(@NotNull Enchantment enchantment, int level) {
        this.meta.addEnchant(enchantment, level, true);
        return (B)((IUnifiedItemBuilder)((Object)this));
    }

    public B addItemFlags(ItemFlag ... flags) {
        this.meta.addItemFlags(flags);
        return (B)((IUnifiedItemBuilder)((Object)this));
    }

    public B setGlowing(boolean glowing) {
        if (glowing) {
            this.meta.addEnchant(Enchantment.LURE, 1, true);
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        } else {
            this.meta.removeEnchant(Enchantment.LURE);
            this.meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        return (B)((IUnifiedItemBuilder)((Object)this));
    }

    public ItemStack build() {
        this.item.setItemMeta(this.meta);
        return this.item;
    }
}

