/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.utility.heads;

import com.raindropcentral.rplatform.utility.heads.EHeadFilter;
import com.raindropcentral.rplatform.utility.itembuilder.skull.IHeadBuilder;
import com.raindropcentral.rplatform.utility.unified.UnifiedBuilderFactory;
import de.jexcellence.jextranslate.i18n.I18n;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class RHead {
    private String identifier;
    private UUID uuid;
    private String texture;
    private EHeadFilter filter;
    private String translationKey;

    private RHead() {
    }

    public RHead(@NotNull String identifier, @NotNull String uuid, @NotNull String texture, @NotNull EHeadFilter filter) {
        this.identifier = identifier;
        this.uuid = UUID.fromString(uuid);
        this.texture = texture;
        this.filter = filter;
        this.translationKey = "head." + this.identifier;
    }

    public RHead(@NotNull String identifier, @NotNull String uuid, @NotNull String texture) {
        this(identifier, uuid, texture, EHeadFilter.INVENTORY);
    }

    public ItemStack getHead(@NotNull Player player) {
        return ((IHeadBuilder)((IHeadBuilder)UnifiedBuilderFactory.head().setCustomTexture(this.uuid, this.texture).setName((Component)new I18n.Builder(this.translationKey + ".name", player).build().component())).setLore(new I18n.Builder(this.translationKey + ".lore", player).build().children())).build();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getTexture() {
        return this.texture;
    }

    public EHeadFilter getFilter() {
        return this.filter;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }
}

