/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.type;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum EStatisticType {
    JOIN_DATE("join_date", StatisticDataType.TIMESTAMP, 0L, StatisticCategory.CORE, "The timestamp when the player first joined the server"),
    LAST_SEEN("last_seen", StatisticDataType.TIMESTAMP, 0L, StatisticCategory.CORE, "The timestamp when the player was last seen online"),
    FIRST_JOIN_SERVER("first_join_server", StatisticDataType.STRING, "", StatisticCategory.CORE, "The name of the server where the player first joined"),
    LOGIN_COUNT("login_count", StatisticDataType.NUMBER, 0.0, StatisticCategory.CORE, "Total number of times the player has logged in"),
    TOTAL_TIME_PLAYED("total_time_played", StatisticDataType.NUMBER, 0.0, StatisticCategory.CORE, "Total time played in milliseconds"),
    PLAYER_VERSION("player_version", StatisticDataType.STRING, "1.0.0", StatisticCategory.CORE, "Player data version for migration purposes"),
    TOTAL_DEATHS("total_deaths", StatisticDataType.NUMBER, 0.0, StatisticCategory.GAMEPLAY, "Total number of player deaths"),
    TOTAL_KILLS("total_kills", StatisticDataType.NUMBER, 0.0, StatisticCategory.GAMEPLAY, "Total number of mob/player kills"),
    BLOCKS_BROKEN("blocks_broken", StatisticDataType.NUMBER, 0.0, StatisticCategory.GAMEPLAY, "Total number of blocks broken"),
    BLOCKS_PLACED("blocks_placed", StatisticDataType.NUMBER, 0.0, StatisticCategory.GAMEPLAY, "Total number of blocks placed"),
    DISTANCE_WALKED("distance_walked", StatisticDataType.NUMBER, 0.0, StatisticCategory.GAMEPLAY, "Total distance walked in blocks"),
    DISTANCE_FLOWN("distance_flown", StatisticDataType.NUMBER, 0.0, StatisticCategory.GAMEPLAY, "Total distance flown in blocks"),
    ITEMS_CRAFTED("items_crafted", StatisticDataType.NUMBER, 0.0, StatisticCategory.GAMEPLAY, "Total number of items crafted"),
    FOOD_EATEN("food_eaten", StatisticDataType.NUMBER, 0.0, StatisticCategory.GAMEPLAY, "Total amount of food consumed"),
    MESSAGES_SENT("messages_sent", StatisticDataType.NUMBER, 0.0, StatisticCategory.SOCIAL, "Total number of chat messages sent"),
    COMMANDS_USED("commands_used", StatisticDataType.NUMBER, 0.0, StatisticCategory.SOCIAL, "Total number of commands executed"),
    TOTAL_MONEY_EARNED("total_money_earned", StatisticDataType.NUMBER, 0.0, StatisticCategory.ECONOMY, "Total money earned throughout gameplay"),
    TOTAL_MONEY_SPENT("total_money_spent", StatisticDataType.NUMBER, 0.0, StatisticCategory.ECONOMY, "Total money spent on purchases"),
    CURRENT_BALANCE("current_balance", StatisticDataType.NUMBER, 0.0, StatisticCategory.ECONOMY, "Current money balance"),
    ITEMS_SOLD("items_sold", StatisticDataType.NUMBER, 0.0, StatisticCategory.ECONOMY, "Total number of items sold"),
    ITEMS_BOUGHT("items_bought", StatisticDataType.NUMBER, 0.0, StatisticCategory.ECONOMY, "Total number of items purchased"),
    CURRENT_LEVEL("current_level", StatisticDataType.NUMBER, 1.0, StatisticCategory.PROGRESSION, "Current player level"),
    TOTAL_EXPERIENCE("total_experience", StatisticDataType.NUMBER, 0.0, StatisticCategory.PROGRESSION, "Total experience points earned"),
    ACHIEVEMENTS_UNLOCKED("achievements_unlocked", StatisticDataType.NUMBER, 0.0, StatisticCategory.PROGRESSION, "Total number of achievements unlocked"),
    QUESTS_COMPLETED("quests_completed", StatisticDataType.NUMBER, 0.0, StatisticCategory.PROGRESSION, "Total number of quests completed"),
    SKILL_POINTS("skill_points", StatisticDataType.NUMBER, 0.0, StatisticCategory.PROGRESSION, "Available skill points to spend"),
    PRESTIGE_LEVEL("prestige_level", StatisticDataType.NUMBER, 0.0, StatisticCategory.PROGRESSION, "Current prestige level"),
    PVP_KILLS("pvp_kills", StatisticDataType.NUMBER, 0.0, StatisticCategory.PVP, "Total player vs player kills"),
    PVP_DEATHS("pvp_deaths", StatisticDataType.NUMBER, 0.0, StatisticCategory.PVP, "Total deaths in player vs player combat"),
    PVP_ASSISTS("pvp_assists", StatisticDataType.NUMBER, 0.0, StatisticCategory.PVP, "Total PvP kill assists"),
    STRUCTURES_BUILT("structures_built", StatisticDataType.NUMBER, 0.0, StatisticCategory.BUILDING, "Total number of structures completed"),
    CREATIVE_TIME("creative_time", StatisticDataType.NUMBER, 0.0, StatisticCategory.BUILDING, "Total time spent in creative mode"),
    PLOTS_OWNED("plots_owned", StatisticDataType.NUMBER, 0.0, StatisticCategory.BUILDING, "Current number of plots owned"),
    TUTORIAL_COMPLETED("tutorial_completed", StatisticDataType.BOOLEAN, false, StatisticCategory.SYSTEM, "Whether the player has completed the tutorial"),
    WELCOME_MESSAGE_SHOWN("welcome_message_shown", StatisticDataType.BOOLEAN, false, StatisticCategory.SYSTEM, "Whether the welcome message has been displayed"),
    SETTINGS_CONFIGURED("settings_configured", StatisticDataType.BOOLEAN, false, StatisticCategory.SYSTEM, "Whether the player has configured their settings"),
    DATA_VERSION("data_version", StatisticDataType.STRING, "1.0", StatisticCategory.SYSTEM, "Version of the player data structure"),
    LAST_IP_ADDRESS("last_ip_address", StatisticDataType.STRING, "", StatisticCategory.SYSTEM, "Last known IP address (for security)"),
    CLIENT_VERSION("client_version", StatisticDataType.STRING, "", StatisticCategory.SYSTEM, "Minecraft client version used"),
    TOTAL_PERKS_ACTIVATED("total_perks_activated", StatisticDataType.NUMBER, 0.0, StatisticCategory.PERKS, "Total number of times any perk has been activated"),
    TOTAL_PERKS_OWNED("total_perks_owned", StatisticDataType.NUMBER, 0.0, StatisticCategory.PERKS, "Total number of perks currently owned by the player"),
    TOTAL_PERKS_PURCHASED("total_perks_purchased", StatisticDataType.NUMBER, 0.0, StatisticCategory.PERKS, "Total number of perks purchased throughout gameplay"),
    ACTIVE_PERKS_COUNT("active_perks_count", StatisticDataType.NUMBER, 0.0, StatisticCategory.PERKS, "Current number of active perks"),
    PERK_COOLDOWN_VIOLATIONS("perk_cooldown_violations", StatisticDataType.NUMBER, 0.0, StatisticCategory.PERKS, "Number of times player tried to activate perk during cooldown"),
    MOST_USED_PERK("most_used_perk", StatisticDataType.STRING, "", StatisticCategory.PERKS, "Identifier of the most frequently used perk"),
    PERK_USAGE_TIME("perk_usage_time", StatisticDataType.NUMBER, 0.0, StatisticCategory.PERKS, "Total time spent with perks active (in milliseconds)"),
    LAST_PERK_ACTIVATION("last_perk_activation", StatisticDataType.TIMESTAMP, 0L, StatisticCategory.PERKS, "Timestamp of the last perk activation"),
    PERK_MONEY_SPENT("perk_money_spent", StatisticDataType.NUMBER, 0.0, StatisticCategory.PERKS, "Total money spent on perk purchases and activations"),
    FAVORITE_PERK_CATEGORY("favorite_perk_category", StatisticDataType.STRING, "", StatisticCategory.PERKS, "Most frequently used perk category");

    private final String key;
    private final StatisticDataType dataType;
    private final Object defaultValue;
    private final StatisticCategory category;
    private final String description;

    private EStatisticType(@NotNull String key, @NotNull StatisticDataType dataType, @NotNull Object defaultValue, StatisticCategory category, String description) {
        this.key = key;
        this.dataType = dataType;
        this.defaultValue = defaultValue;
        this.category = category;
        this.description = description;
    }

    public String getKey() {
        return this.key;
    }

    public StatisticDataType getDataType() {
        return this.dataType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public StatisticCategory getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isOfType(@NotNull StatisticDataType dataType) {
        return this.dataType == dataType;
    }

    public boolean isInCategory(@NotNull StatisticCategory category) {
        return this.category == category;
    }

    public static List<EStatisticType> getByDataType(@NotNull StatisticDataType dataType) {
        return Arrays.stream(EStatisticType.values()).filter(stat -> stat.isOfType(dataType)).toList();
    }

    public static List<EStatisticType> getByCategory(@NotNull StatisticCategory category) {
        return Arrays.stream(EStatisticType.values()).filter(stat -> stat.isInCategory(category)).toList();
    }

    @Nullable
    public static EStatisticType getByKey(@NotNull String key) {
        return Arrays.stream(EStatisticType.values()).filter(stat -> stat.getKey().equals(key)).findFirst().orElse(null);
    }

    public static Map<String, Object> getDefaultValuesForCategory(@NotNull StatisticCategory category) {
        return EStatisticType.getByCategory(category).stream().collect(Collectors.toMap(EStatisticType::getKey, EStatisticType::getDefaultValue));
    }

    public static Map<String, Object> getCoreDefaults() {
        return EStatisticType.getDefaultValuesForCategory(StatisticCategory.CORE);
    }

    public static Map<String, Object> getGameplayDefaults() {
        return EStatisticType.getDefaultValuesForCategory(StatisticCategory.GAMEPLAY);
    }

    public static Map<String, Object> getPerkDefaults() {
        return EStatisticType.getDefaultValuesForCategory(StatisticCategory.PERKS);
    }

    public static List<EStatisticType> getPerkStatistics() {
        return EStatisticType.getByCategory(StatisticCategory.PERKS);
    }

    public static String getPerkActivationCountKey(@NotNull String perkIdentifier) {
        return "perk_activation_count_" + perkIdentifier.toLowerCase();
    }

    public static String getPerkLastUsedKey(@NotNull String perkIdentifier) {
        return "perk_last_used_" + perkIdentifier.toLowerCase();
    }

    public static String getPerkUsageTimeKey(@NotNull String perkIdentifier) {
        return "perk_usage_time_" + perkIdentifier.toLowerCase();
    }

    public static enum StatisticDataType {
        BOOLEAN,
        NUMBER,
        STRING,
        TIMESTAMP;

    }

    public static enum StatisticCategory {
        CORE,
        RDQ,
        GAMEPLAY,
        SOCIAL,
        ECONOMY,
        PROGRESSION,
        PVP,
        BUILDING,
        SYSTEM,
        MINIGAMES,
        PERKS;

    }
}

