/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.service;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceRegistry {
    private static final Logger LOGGER = Logger.getLogger(ServiceRegistry.class.getName());
    private static final int DEFAULT_MAX_ATTEMPTS = 10;
    private static final long DEFAULT_RETRY_DELAY_MS = 500L;
    private final Map<String, Object> services = new ConcurrentHashMap<String, Object>();

    @NotNull
    public <T> ServiceRegistrationBuilder<T> register(@NotNull Class<T> serviceClass) {
        return new ServiceRegistrationBuilder<T>(this, serviceClass);
    }

    @NotNull
    public <T> ServiceRegistrationBuilder<T> register(@NotNull String serviceClass) {
        try {
            Class<?> clazz = Class.forName(serviceClass);
            return new ServiceRegistrationBuilder(this, clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public <T> ServiceRegistrationBuilder<T> register(@NotNull String serviceFqcn, @Nullable String pluginName) {
        return new ServiceRegistrationBuilder(this, serviceFqcn, pluginName);
    }

    @NotNull
    public <T> Optional<T> get(@NotNull Class<T> serviceClass) {
        Object service = this.services.get(serviceClass.getName());
        if (serviceClass.isInstance(service)) {
            return Optional.of(serviceClass.cast(service));
        }
        return Optional.empty();
    }

    @NotNull
    public <T> T getRequired(@NotNull Class<T> serviceClass) {
        return this.get(serviceClass).orElseThrow(() -> new ServiceNotFoundException("Required service not available: " + serviceClass.getSimpleName()));
    }

    public boolean has(@NotNull Class<?> serviceClass) {
        return this.services.containsKey(serviceClass.getName());
    }

    <T> void registerService(@NotNull String key, @NotNull T service) {
        this.services.put(key, service);
        LOGGER.info("Registered service: " + key);
    }

    @Nullable
    <T> T loadFromBukkit(@NotNull Class<T> serviceClass) {
        RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(serviceClass);
        return (T)(provider != null ? provider.getProvider() : null);
    }

    @Nullable
    Class<?> loadClass(@NotNull String fqcn, @Nullable String pluginName) {
        Plugin plugin;
        if (pluginName != null && !pluginName.isBlank() && (plugin = Bukkit.getPluginManager().getPlugin(pluginName)) != null) {
            try {
                return Class.forName(fqcn, false, plugin.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                LOGGER.fine("Class " + fqcn + " not found in plugin " + pluginName);
            }
        }
        try {
            return Class.forName(fqcn);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static final class ServiceRegistrationBuilder<T> {
        private final ServiceRegistry registry;
        private final Class<T> serviceClass;
        private final String serviceFqcn;
        private final String pluginName;
        private boolean required;
        private int maxAttempts = 10;
        private long retryDelayMs = 500L;
        private Consumer<T> onSuccess;
        private Runnable onFailure;

        private ServiceRegistrationBuilder(@NotNull ServiceRegistry registry, @NotNull Class<T> serviceClass) {
            this.registry = registry;
            this.serviceClass = serviceClass;
            this.serviceFqcn = serviceClass.getName();
            this.pluginName = null;
        }

        private ServiceRegistrationBuilder(@NotNull ServiceRegistry registry, @NotNull String serviceFqcn, @Nullable String pluginName) {
            this.registry = registry;
            this.serviceClass = null;
            this.serviceFqcn = serviceFqcn;
            this.pluginName = pluginName;
        }

        @NotNull
        public ServiceRegistrationBuilder<T> required() {
            this.required = true;
            return this;
        }

        @NotNull
        public ServiceRegistrationBuilder<T> optional() {
            this.required = false;
            return this;
        }

        @NotNull
        public ServiceRegistrationBuilder<T> maxAttempts(int attempts) {
            this.maxAttempts = Math.max(1, attempts);
            return this;
        }

        @NotNull
        public ServiceRegistrationBuilder<T> retryDelay(long delayMs) {
            this.retryDelayMs = Math.max(100L, delayMs);
            return this;
        }

        @NotNull
        public ServiceRegistrationBuilder<T> onSuccess(@NotNull Consumer<T> handler) {
            this.onSuccess = handler;
            return this;
        }

        @NotNull
        public ServiceRegistrationBuilder<T> onFailure(@NotNull Runnable handler) {
            this.onFailure = handler;
            return this;
        }

        @NotNull
        public CompletableFuture<Optional<T>> load() {
            return CompletableFuture.supplyAsync(() -> {
                for (int attempt = 1; attempt <= this.maxAttempts; ++attempt) {
                    Optional<T> result = this.tryLoad();
                    if (result.isPresent()) {
                        T service = result.get();
                        this.registry.registerService(this.serviceFqcn, service);
                        if (this.onSuccess != null) {
                            this.onSuccess.accept(service);
                        }
                        return result;
                    }
                    if (attempt >= this.maxAttempts) continue;
                    try {
                        TimeUnit.MILLISECONDS.sleep(this.retryDelayMs);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if (this.required) {
                    LOGGER.warning("Required service not available after " + this.maxAttempts + " attempts: " + this.serviceFqcn);
                } else {
                    LOGGER.info("Optional service not available: " + this.serviceFqcn);
                }
                if (this.onFailure != null) {
                    this.onFailure.run();
                }
                return Optional.empty();
            });
        }

        @NotNull
        private Optional<T> tryLoad() {
            if (this.serviceClass != null) {
                T service = this.registry.loadFromBukkit(this.serviceClass);
                if (service != null) {
                    return Optional.of(service);
                }
            } else {
                Object service;
                Class<?> loadedClass = this.registry.loadClass(this.serviceFqcn, this.pluginName);
                if (loadedClass != null && (service = this.registry.loadFromBukkit(loadedClass)) != null) {
                    return Optional.of(service);
                }
            }
            return Optional.empty();
        }
    }

    public static final class ServiceNotFoundException
    extends RuntimeException {
        public ServiceNotFoundException(@NotNull String message) {
            super(message);
        }
    }
}

