/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.serializer;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocationSerializer {
    private static final String DELIMITER = ",";
    private static final int EXPECTED_PARTS = 6;

    @Nullable
    public Location deserialize(@NotNull String serialized) {
        String[] parts = serialized.split(DELIMITER);
        if (parts.length != 6) {
            return this.createDefaultLocation();
        }
        World world = Bukkit.getWorld((String)parts[0].trim());
        if (world == null) {
            return this.createDefaultLocation();
        }
        try {
            double x = Double.parseDouble(parts[1].trim());
            double y = Double.parseDouble(parts[2].trim());
            double z = Double.parseDouble(parts[3].trim());
            float yaw = Float.parseFloat(parts[4].trim());
            float pitch = Float.parseFloat(parts[5].trim());
            return new Location(world, x, y, z, yaw, pitch);
        }
        catch (NumberFormatException e) {
            return this.createDefaultLocation();
        }
    }

    @NotNull
    public String serialize(@NotNull Location location) {
        if (location.getWorld() == null) {
            throw new IllegalArgumentException("Location world cannot be null");
        }
        return String.format("%s,%s,%s,%s,%s,%s", location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
    }

    @Nullable
    private Location createDefaultLocation() {
        World world = Bukkit.getWorld((String)"world");
        return world != null ? new Location(world, 0.0, 0.0, 0.0, 0.0f, 0.0f) : null;
    }
}

