/*
 * Decompiled with CFR 0.152.
 */
package com.raindropcentral.rplatform.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class ItemStackSerializer {
    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] serialize(@Nullable ItemStack itemStack) {
        ItemStack stack = itemStack != null ? itemStack : new ItemStack(Material.AIR);
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (BukkitObjectOutputStream bukkitOut = new BukkitObjectOutputStream((OutputStream)byteStream);){
                bukkitOut.writeObject((Object)stack);
                byArray = byteStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialize ItemStack", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ItemStack deserialize(byte[] data) {
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(data);){
            ItemStack itemStack;
            try (BukkitObjectInputStream bukkitIn = new BukkitObjectInputStream((InputStream)byteStream);){
                itemStack = (ItemStack)bukkitIn.readObject();
            }
            return itemStack;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("Failed to deserialize ItemStack", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] serializeArray(@Nullable ItemStack[] items) {
        ItemStack[] array = items != null ? items : new ItemStack[]{};
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();){
            byte[] byArray;
            try (BukkitObjectOutputStream bukkitOut = new BukkitObjectOutputStream((OutputStream)byteStream);){
                bukkitOut.writeInt(array.length);
                for (ItemStack item : array) {
                    bukkitOut.writeObject((Object)(item != null ? item : new ItemStack(Material.AIR)));
                }
                byArray = byteStream.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialize ItemStack array", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ItemStack[] deserializeArray(byte[] data) {
        try (ByteArrayInputStream byteStream = new ByteArrayInputStream(data);){
            ItemStack[] itemStackArray;
            try (BukkitObjectInputStream bukkitIn = new BukkitObjectInputStream((InputStream)byteStream);){
                int length = bukkitIn.readInt();
                ItemStack[] items = new ItemStack[length];
                for (int i = 0; i < length; ++i) {
                    items[i] = (ItemStack)bukkitIn.readObject();
                }
                itemStackArray = items;
            }
            return itemStackArray;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("Failed to deserialize ItemStack array", e);
        }
    }

    @NotNull
    public String toBase64(@Nullable ItemStack itemStack) {
        byte[] serialized = this.serialize(itemStack);
        return Base64Coder.encodeLines((byte[])serialized);
    }

    @NotNull
    public ItemStack fromBase64(@NotNull String base64) {
        try {
            byte[] data = Base64Coder.decodeLines((String)base64);
            return this.deserialize(data);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to decode Base64 ItemStack", e);
        }
    }

    @NotNull
    public String arrayToBase64(@Nullable ItemStack[] items) {
        byte[] serialized = this.serializeArray(items);
        return Base64Coder.encodeLines((byte[])serialized);
    }

    @NotNull
    public ItemStack[] arrayFromBase64(@NotNull String base64) {
        try {
            byte[] data = Base64Coder.decodeLines((String)base64);
            return this.deserializeArray(data);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to decode Base64 ItemStack array", e);
        }
    }

    public boolean isEmpty(@Nullable ItemStack itemStack) {
        return itemStack == null || itemStack.getType() == Material.AIR || itemStack.getAmount() <= 0;
    }

    @Nullable
    public ItemStack deepClone(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        byte[] serialized = this.serialize(itemStack);
        return this.deserialize(serialized);
    }
}

